/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.service.StockServiceHolder;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IOutputLog;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.model.OrderHistoryAction;
import ch.elexis.core.model.OrderHistoryEntry;
import ch.elexis.core.serial.Connection;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.constants.OrderConstants;
import ch.elexis.core.ui.dialogs.ContactSelectionDialog;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.core.ui.util.OrderManagementActionFactory;
import ch.elexis.core.ui.util.OrderManagementUtil;
import ch.elexis.core.ui.util.dnd.OrderDropReceiver;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.provider.CompletedOrderTableLabelProvider;
import ch.elexis.core.ui.views.provider.EntryTableLabelProvider;
import ch.elexis.core.ui.views.provider.GenericOrderEditingSupport;
import ch.elexis.core.ui.views.provider.OrderTableLabelProvider;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.part.ViewPart;

public class OrderManagementView
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.OrderManagementView";
    private Composite topComposite;
    private Composite middleComposite;
    private Composite leftComposite;
    private Composite createdComposite;
    private Label cartIcon;
    private Label titleLabel;
    private Label createdLabel;
    private TableViewerColumn[] mainColumns;
    private Label statusLabel;
    private Label statusValue;
    public TableViewer tableViewer;
    private TableViewer orderTable;
    private TableViewer completedTable;
    private Action checkInAction;
    private IOrder actOrder;
    private OrderManagementActionFactory actionFactory;
    private Button orderButton;
    private boolean showDeliveredColumn = false;
    private Composite dispatchedComposite;
    private Label dispatchedLabelTitle;
    private Label dispatchedLabelIcon;
    private Label dispatchedLabelState;
    private Composite bookedComposite;
    private Label bookedLabelTitle;
    private Label bookedLabelIcon;
    private Label bookedLabelState;
    private Label createdLabelState;
    private Composite completedContainer;
    private boolean isUIUpdating = false;
    @Inject
    private IOrderService orderService;
    private Composite rightListComposite;
    private ScrolledComposite scrolledComposite;
    private ScrolledComposite rightScrollComposite;
    private boolean hasFocus = false;
    private boolean showAllYears = false;
    private static final String BARCODE_CONSUMER_KEY = "barcodeInputConsumer.OrderManagementView";
    public static final String BarcodeScanner_COMPORT = "barcode/Symbol/port";
    private static final GridData FILL_HORIZONTAL = new GridData(4, 0x1000000, true, false);
    private static final GridData FILL_BOTH = new GridData(4, 4, true, true);
    private static final GridData FIXED_WIDTH_50 = new GridData(50, -1);
    private static final GridData FIXED_WIDTH_75 = new GridData(75, -1);
    private Map<Integer, Boolean> expandedStates = new HashMap<Integer, Boolean>();
    private final Map<IOrderEntry, Integer> pendingDeliveredValues = new HashMap<IOrderEntry, Integer>();
    private static boolean barcodeScannerActivated = false;
    private boolean isDeliveryEditMode = false;
    private Image orderButtonCustomImage;
    public GenericObjectDropTarget dropTarget;
    private RefreshingPartListener focusListener = new RefreshingPartListener(this){

        @Override
        public void partActivated(IWorkbenchPartReference partRef) {
            if (this.isMatchingPart(partRef)) {
                OrderManagementView.this.hasFocus = true;
                String valueToSet = OrderManagementView.class.getName();
                ContextServiceHolder.get().getRootContext().setNamed(OrderManagementView.BARCODE_CONSUMER_KEY, (Object)valueToSet);
            }
        }

        @Override
        public void partDeactivated(IWorkbenchPartReference partRef) {
            if (this.isMatchingPart(partRef)) {
                OrderManagementView.this.hasFocus = false;
                ContextServiceHolder.get().getRootContext().setNamed(OrderManagementView.BARCODE_CONSUMER_KEY, null);
            }
        }
    };

    public Composite getCompletedContainer() {
        return this.completedContainer;
    }

    public void setCompletedContainer(Composite completedContainer) {
        this.completedContainer = completedContainer;
    }

    public boolean isDeliveryEditMode() {
        return this.isDeliveryEditMode;
    }

    public void setDeliveryEditMode(boolean enabled) {
        this.isDeliveryEditMode = enabled;
    }

    public static void setBarcodeScannerActivated(boolean enabled) {
        barcodeScannerActivated = enabled;
    }

    @Optional
    @Inject
    public void reload(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (IStock.class.equals(clazz)) {
            if (this.actOrder != null) {
                this.refresh();
                this.loadOpenOrders();
            }
            if (this.orderTable != null) {
                this.loadOpenOrders();
            }
        }
    }

    @Inject
    @Optional
    public void barcodeEvent(@UIEventTopic(value="info/elexis/event/barcodeinput") Object event, IContextService contextService) {
        if (!this.hasFocus) {
            return;
        }
        if (event instanceof IArticle) {
            IArticle scannedArticle = (IArticle)event;
            if (OrderManagementView.class.getName().equals(contextService.getNamed(BARCODE_CONSUMER_KEY).orElse(null))) {
                if (this.actOrder == null) {
                    return;
                }
                java.util.Optional<IOrderEntry> matchingEntry = this.actOrder.getEntries().stream().filter(entry -> entry.getArticle() != null && entry.getArticle().getCode().equals(scannedArticle.getCode())).findFirst();
                if (matchingEntry.isPresent()) {
                    IOrderEntry entry2 = matchingEntry.get();
                    if (entry2.getState() == OrderEntryState.OPEN) {
                        int oldAmount = entry2.getAmount();
                        int newAmount = oldAmount + 1;
                        this.updateOrderEntry(entry2, newAmount);
                    } else {
                        boolean confirm;
                        int currentPending = this.pendingDeliveredValues.getOrDefault(entry2, 0);
                        int newPending = currentPending + 1;
                        int ordered = entry2.getAmount();
                        int delivered = entry2.getDelivered();
                        int sumDelivered = delivered + newPending;
                        if (sumDelivered > ordered && !(confirm = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.OrderManagement_Overdelivery_Title, (String)MessageFormat.format(Messages.OrderManagement_Overdelivery_Message, delivered, newPending, sumDelivered, ordered)))) {
                            return;
                        }
                        this.pendingDeliveredValues.put(entry2, newPending);
                    }
                } else {
                    boolean isOrderOpen = this.actOrder.getEntries().stream().allMatch(e -> e.getState() == OrderEntryState.OPEN);
                    if (isOrderOpen) {
                        IStock stock = StockServiceHolder.get().getMandatorDefaultStock(((IMandator)ContextServiceHolder.get().getActiveMandator().get()).getId());
                        IOrderEntry newEntry = this.actOrder.addEntry(scannedArticle, stock, null, 1);
                        newEntry.setOrder(this.actOrder);
                        newEntry.setArticle(scannedArticle);
                        newEntry.setAmount(1);
                        newEntry.setState(OrderEntryState.OPEN);
                        this.actOrder.getEntries().add(newEntry);
                        CoreModelServiceHolder.get().save((Identifiable)newEntry);
                        this.orderService.getHistoryService().logEdit(this.actOrder, newEntry, 0, 1);
                    }
                }
                this.tableViewer.refresh();
                this.refresh();
                this.updateOrderStatus(this.actOrder);
            }
        }
    }

    @Optional
    @Inject
    void activeOrder(IOrder order) {
        if (order != null) {
            this.actOrder = order;
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.getSite().getPage().addPartListener((IPartListener2)this.focusListener);
        this.createHeaderUI(parent);
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTableUI((Composite)sashForm);
        this.createRightUI((Composite)sashForm);
        this.registerTableListeners(null);
        this.registerButtonListeners();
        this.registerMouseWheelListeners(null);
        this.loadOpenOrders();
        this.makeActions();
        this.actionFactory.createContextMenu(this.tableViewer, this.orderTable);
        this.loadCompletedOrders(this.completedContainer);
        this.updateUI();
        sashForm.setWeights(new int[]{2, 1});
    }

    public boolean isShowDeliveredColumn() {
        return this.showDeliveredColumn;
    }

    public void setShowDeliveredColumn(boolean showDeliveredColumn) {
        this.showDeliveredColumn = showDeliveredColumn;
    }

    private boolean isBarcodePortAvailable() {
        String port = LocalConfigService.get((String)BarcodeScanner_COMPORT, (String)"");
        if (StringUtils.isBlank((CharSequence)port)) {
            return false;
        }
        String[] available = Connection.getComPorts();
        return Arrays.asList(available).contains(port);
    }

    public void handleOrderButtonClick() {
        String buttonText;
        block10: {
            block11: {
                block9: {
                    boolean confirm;
                    buttonText = this.orderButton.getText();
                    if (!buttonText.equals(Messages.OrderManagement_Button_Order)) break block9;
                    if (buttonText.equals(Messages.OrderManagement_Button_Order) && (confirm = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)ch.elexis.core.ui.dialogs.Messages.OrderMethodDialog_Title, (String)ch.elexis.core.ui.dialogs.Messages.OrderMethodDialog_Message))) {
                        this.actionFactory.sendOrder();
                        this.loadOpenOrders();
                    }
                    this.refresh();
                    break block10;
                }
                if (!buttonText.equals(Messages.OrderManagement_Button_MissingSupplier)) break block11;
                IContact selectedProvider = ContactSelectionDialog.showInSync(IContact.class, Messages.OrderManagement_SelectSupplier_Title, Messages.OrderManagement_SelectSupplier_Message);
                if (selectedProvider == null) break block10;
                for (IOrderEntry entry : this.actOrder.getEntries()) {
                    if (entry.getProvider() != null) continue;
                    entry.setProvider(selectedProvider);
                    this.orderService.getHistoryService().logSupplierAdded(this.actOrder, entry, selectedProvider.getLabel());
                    CoreModelServiceHolder.get().save((Identifiable)entry);
                }
                this.refreshTables();
                break block10;
            }
            if (buttonText.equals(Messages.OrderManagement_Button_Book)) {
                if (this.isBarcodePortAvailable()) {
                    OrderManagementUtil.activateBarcodeScannerAndFocus();
                }
                this.setDeliveryEditMode(true);
                this.tableViewer.refresh();
                for (IOrderEntry entry : this.actOrder.getEntries()) {
                    if (entry.getState() != OrderEntryState.ORDERED && entry.getState() != OrderEntryState.PARTIAL_DELIVER) continue;
                    this.tableViewer.editElement((Object)entry, 3);
                    this.orderButton.setText(Messages.MedicationComposite_btnConfirm);
                    this.orderButton.setImage(Images.IMG_TICK.getImage());
                    break;
                }
            }
        }
        if (buttonText.equals(Messages.MedicationComposite_btnConfirm)) {
            for (Map.Entry<IOrderEntry, Integer> entry : this.pendingDeliveredValues.entrySet()) {
                boolean confirm;
                IOrderEntry orderEntry = entry.getKey();
                int currentDelivered = orderEntry.getDelivered();
                int ordered = orderEntry.getAmount();
                int part = entry.getValue();
                int newTotal = currentDelivered + part;
                if (newTotal > ordered && !(confirm = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.OrderManagement_Overdelivery_Title, (String)MessageFormat.format(Messages.OrderManagement_Overdelivery_Message, currentDelivered, part, newTotal, ordered)))) continue;
                if (newTotal < 0) {
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.Cst_Text_ungueltiger_Wert, (String)Messages.OrderManagement_Error_NegativeDeliveredAmount);
                    continue;
                }
                this.orderService.getHistoryService().logDelivery(orderEntry.getOrder(), orderEntry, part, ordered);
                OrderManagementUtil.saveSingleDelivery(orderEntry, part, this.orderService);
            }
            if (this.isBarcodePortAvailable()) {
                OrderManagementUtil.activateBarcodeScannerAndFocus();
                barcodeScannerActivated = false;
            }
            this.pendingDeliveredValues.clear();
            this.setDeliveryEditMode(false);
            this.tableViewer.refresh();
            this.refreshTables();
            return;
        }
    }

    public void refreshTables() {
        this.loadOpenOrders();
        this.loadCompletedOrders(this.completedContainer);
        this.refresh();
    }

    public int determineEditableColumn(IOrderEntry entry) {
        if (entry.getState() == OrderEntryState.OPEN) {
            return 1;
        }
        if (entry.getState() == OrderEntryState.ORDERED || entry.getState() == OrderEntryState.PARTIAL_DELIVER) {
            return 2;
        }
        return -1;
    }

    public void updateOrderEntry(IOrderEntry entry, int newValue) {
        if (entry.getState() == OrderEntryState.OPEN) {
            int oldValue = entry.getAmount();
            entry.setAmount(newValue);
            this.orderService.getHistoryService().logEdit(this.actOrder, entry, oldValue, newValue);
        } else {
            OrderManagementUtil.saveSingleDelivery(entry, newValue, this.orderService);
        }
        CoreModelServiceHolder.get().save((Identifiable)entry);
        this.tableViewer.refresh((Object)entry);
    }

    private void createHeaderUI(Composite parent) {
        this.topComposite = new Composite(parent, 2048);
        this.topComposite.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.topComposite.setLayout((Layout)new GridLayout(4, false));
        this.createImageComposite(this.topComposite);
        this.createLeftComposite(this.topComposite);
        this.createMiddleComposite(this.topComposite);
        this.createRightComposite(this.topComposite);
    }

    private void createImageComposite(Composite parent) {
        Composite imageComposite = new Composite(this.topComposite, 0);
        GridData imageCompositeData = new GridData(1, 4, false, true);
        imageComposite.setLayoutData((Object)imageCompositeData);
        imageComposite.setLayout((Layout)new GridLayout(1, false));
        this.cartIcon = new Label(imageComposite, 0);
        GridData cartIconData = new GridData(0x1000000, 0x1000000, true, true);
        this.cartIcon.setLayoutData((Object)cartIconData);
        this.cartIcon.setLayoutData((Object)new GridData(80, 70));
    }

    private void createLeftComposite(Composite parent) {
        this.leftComposite = new Composite(this.topComposite, 0);
        this.leftComposite.setLayoutData((Object)FILL_BOTH);
        GridLayout leftLayout = new GridLayout(1, false);
        leftLayout.marginHeight = 0;
        leftLayout.marginTop = 0;
        leftLayout.marginBottom = 0;
        leftLayout.verticalSpacing = -5;
        this.leftComposite.setLayout((Layout)leftLayout);
        Composite upperLeftComposite = new Composite(this.leftComposite, 0);
        upperLeftComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        upperLeftComposite.setLayout((Layout)new GridLayout(1, false));
        this.titleLabel = new Label(upperLeftComposite, 0);
        this.titleLabel.setLayoutData((Object)new GridData(180, 25));
        this.titleLabel.setText("");
        this.titleLabel.setFont(this.createBoldFont((Control)this.titleLabel));
        Composite lowerLeftComposite = new Composite(this.leftComposite, 0);
        lowerLeftComposite.setLayoutData((Object)FILL_BOTH);
        lowerLeftComposite.setLayout((Layout)new GridLayout(2, false));
        this.statusLabel = new Label(lowerLeftComposite, 0);
        this.statusLabel.setText(Messages.OrderManagement_StatusLabel);
        this.statusLabel.setLayoutData((Object)FIXED_WIDTH_50);
        this.statusValue = new Label(lowerLeftComposite, 0);
        this.statusValue.setText("");
        this.statusValue.setForeground(parent.getDisplay().getSystemColor(3));
        this.statusValue.setFont(this.createBoldFont((Control)this.statusValue));
        GridData statusValueData = new GridData(4, 0x1000000, true, false);
        this.statusValue.setLayoutData((Object)statusValueData);
    }

    private void createMiddleComposite(Composite parent) {
        this.middleComposite = new Composite(this.topComposite, 0);
        this.middleComposite.setLayoutData((Object)FILL_HORIZONTAL);
        GridLayout middleLayout = new GridLayout(1, false);
        middleLayout.marginHeight = 0;
        middleLayout.marginTop = 0;
        middleLayout.marginBottom = 0;
        middleLayout.verticalSpacing = -5;
        this.middleComposite.setLayout((Layout)middleLayout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.createdComposite = new Composite(this.middleComposite, 0);
        this.createdComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createdComposite.setLayout((Layout)new GridLayout(2, false));
        this.createdLabel = new Label(this.createdComposite, 0);
        this.createdLabel.setText(Messages.OrderManagement_CreatedLabel);
        this.createdLabel.setLayoutData((Object)FIXED_WIDTH_75);
        this.createdLabelState = new Label(this.createdComposite, 0);
        this.createdLabelState.setText("");
        this.createdLabelState.setLayoutData((Object)gridData);
        this.dispatchedComposite = new Composite(this.middleComposite, 0);
        this.dispatchedComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.dispatchedComposite.setLayout((Layout)new GridLayout(3, false));
        this.dispatchedLabelTitle = new Label(this.dispatchedComposite, 0);
        this.dispatchedLabelTitle.setText(Messages.OrderManagement_DispatchedLabel);
        this.dispatchedLabelTitle.setLayoutData((Object)FIXED_WIDTH_75);
        this.dispatchedLabelIcon = new Label(this.dispatchedComposite, 0);
        this.dispatchedLabelIcon.setLayoutData((Object)new GridData(20, 20));
        this.dispatchedLabelState = new Label(this.dispatchedComposite, 0);
        this.dispatchedLabelState.setText("");
        this.dispatchedLabelState.setLayoutData((Object)gridData);
        this.bookedComposite = new Composite(this.middleComposite, 0);
        this.bookedComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.bookedComposite.setLayout((Layout)new GridLayout(3, false));
        this.bookedLabelTitle = new Label(this.bookedComposite, 0);
        this.bookedLabelTitle.setText(Messages.OrderManagement_BookedLabel);
        this.bookedLabelTitle.setLayoutData((Object)FIXED_WIDTH_75);
        this.bookedLabelIcon = new Label(this.bookedComposite, 0);
        this.bookedLabelIcon.setLayoutData((Object)new GridData(20, 20));
        this.bookedLabelState = new Label(this.bookedComposite, 0);
        this.bookedLabelState.setText("");
        this.bookedLabelState.setLayoutData((Object)gridData);
    }

    private void createRightComposite(Composite parent) {
        Composite rightComposite = new Composite(this.topComposite, 0);
        rightComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        rightComposite.setLayout((Layout)new GridLayout());
        this.orderButton = new Button(rightComposite, 8);
        this.orderButton.setText(Messages.OrderManagement_Button_Order);
        this.orderButton.setLayoutData((Object)new GridData(140, 64));
        this.orderButton.setEnabled(false);
    }

    private void createTableUI(Composite parent) {
        Composite mainComposite = new Composite(parent, 2048);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TableViewer(mainComposite, 65536);
        Table tableControl = this.tableViewer.getTable();
        tableControl.setLayoutData((Object)new GridData(4, 4, true, true));
        tableControl.setHeaderVisible(true);
        tableControl.setLinesVisible(true);
        this.dropTarget = new GenericObjectDropTarget("ArtikelDropTarget", this.tableViewer.getControl(), new OrderDropReceiver(this, this.orderService));
        CodeSelectorHandler.getInstance().setCodeSelectorTarget(this.dropTarget);
        this.dropTarget.registered(false);
        String[] columnHeaders = new String[]{Messages.OrderManagement_Column_Status, Messages.OrderManagement_Column_Ordered, Messages.OrderManagement_Column_Delivered, Messages.Core_Add, Messages.OrderManagement_Column_Article, Messages.OrderManagement_Column_Supplier, Messages.OrderManagement_Column_Stock};
        int[] columnWidths = new int[]{80, 50, 60, 80, 190, 160, 50};
        if (this.isBarcodePortAvailable()) {
            OrderManagementUtil.activateBarcodeScannerAndFocus();
        }
        this.createTableColumns(this.tableViewer, columnHeaders, columnWidths, this.showDeliveredColumn);
    }

    private void createRightUI(Composite parent) {
        this.rightScrollComposite = new ScrolledComposite(parent, 768);
        this.rightScrollComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        this.rightScrollComposite.setExpandHorizontal(true);
        this.rightScrollComposite.setExpandVertical(true);
        this.rightListComposite = new Composite((Composite)this.rightScrollComposite, 0);
        this.rightListComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.rightListComposite.setLayout((Layout)new GridLayout(1, false));
        this.rightScrollComposite.setContent((Control)this.rightListComposite);
        Label rightTitle = new Label(this.rightListComposite, 0);
        rightTitle.setText(Messages.OrderManagement_RightTitle);
        this.orderTable = new TableViewer(this.rightListComposite, 68096);
        Table orderTableControl = this.orderTable.getTable();
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 200;
        orderTableControl.setLayoutData((Object)gridData);
        orderTableControl.setHeaderVisible(true);
        orderTableControl.setLinesVisible(true);
        orderTableControl.setHeaderBackground(Display.getDefault().getSystemColor(22));
        orderTableControl.setBackground(Display.getDefault().getSystemColor(22));
        String[] columnOrderHeaders = new String[]{"", Messages.Core_Date, Messages.Core_Title};
        int[] columnOrderWidths = new int[]{40, 90, 210};
        this.createTableColumns(this.orderTable, columnOrderHeaders, columnOrderWidths, this.showDeliveredColumn);
        this.orderTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.orderTable.setLabelProvider((IBaseLabelProvider)new OrderTableLabelProvider());
        Label completedTitle = new Label(this.rightListComposite, 0);
        completedTitle.setText(Messages.OrderManagement_CompletedTitle);
        this.scrolledComposite = new ScrolledComposite(this.rightListComposite, 768);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        Composite scrollContent = new Composite((Composite)this.scrolledComposite, 0);
        scrollContent.setLayout((Layout)new GridLayout(1, false));
        this.scrolledComposite.setContent((Control)scrollContent);
        this.completedContainer = scrollContent;
        this.completedContainer.setLayout((Layout)new GridLayout(1, false));
        this.completedContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        this.completedTable = new TableViewer(this.completedContainer, 66048);
        Table completedTableControl = this.completedTable.getTable();
        completedTableControl.setLayoutData((Object)new GridData(4, 4, true, true));
        completedTableControl.setHeaderVisible(true);
        completedTableControl.setLinesVisible(true);
        completedTableControl.setHeaderBackground(Display.getDefault().getSystemColor(22));
        completedTableControl.setBackground(Display.getDefault().getSystemColor(22));
        String[] completedHeaders = new String[]{Messages.Core_Date, Messages.Core_Title};
        this.createTableColumns(this.completedTable, completedHeaders, columnOrderWidths, this.showDeliveredColumn);
        this.completedTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
    }

    private Font createBoldFont(Control control) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = control.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setStyle(1);
            ++n2;
        }
        Font newFont = new Font((Device)control.getDisplay(), fontData);
        control.addDisposeListener(e -> newFont.dispose());
        return newFont;
    }

    private void createTableColumns(TableViewer viewer, String[] titles, int[] widths, boolean showDelivered) {
        this.mainColumns = new TableViewerColumn[titles.length];
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn col;
            this.mainColumns[i] = col = new TableViewerColumn(viewer, 0);
            TableColumn column = col.getColumn();
            column.setText(titles[i]);
            column.setWidth(widths[i]);
            column.setResizable(true);
            column.setMoveable(true);
            col.setLabelProvider((CellLabelProvider)new EntryTableLabelProvider(i, showDelivered, this));
            ++i;
        }
    }

    @Override
    public void refresh() {
        if (this.actOrder != null) {
            this.loadOrderDetails(this.actOrder);
            this.updateOrderDetails(this.actOrder);
        }
        this.updateTableBackground(this.actOrder);
        this.updateUI();
    }

    public void reload() {
        if (this.actOrder != null) {
            this.loadOpenOrders();
        }
        if (this.orderTable != null) {
            this.loadOpenOrders();
        }
        if (this.completedContainer != null) {
            this.loadCompletedOrders();
        }
    }

    public void setFocus() {
        Composite controlToFocus;
        Object object = controlToFocus = this.tableViewer != null ? this.tableViewer.getControl() : this.topComposite;
        if (controlToFocus != null && !controlToFocus.isDisposed()) {
            controlToFocus.setFocus();
        }
    }

    public void updateCheckIn() {
        if (this.checkInAction == null) {
            return;
        }
        if (this.actOrder == null) {
            this.checkInAction.setEnabled(false);
            this.checkInAction.setToolTipText(Messages.OrderManagement_CheckIn_NoOrder);
        } else if (this.actOrder.isDone()) {
            this.checkInAction.setEnabled(false);
            this.checkInAction.setToolTipText(Messages.OrderManagement_CheckIn_Done);
        } else {
            this.checkInAction.setEnabled(true);
            this.checkInAction.setToolTipText(Messages.OrderManagement_CheckIn_Confirm);
        }
    }

    private void registerTableListeners(List<TableViewer> tableViewers) {
        if (this.orderTable != null && !this.orderTable.getTable().isDisposed()) {
            this.orderTable.addSelectionChangedListener(event -> {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IOrder selectedOrder = (IOrder)selection.getFirstElement();
                if (selectedOrder != null) {
                    this.resetEditMode();
                    this.setActOrder(selectedOrder);
                    this.refresh();
                }
            });
        }
        if (this.completedTable != null && !this.completedTable.getTable().isDisposed()) {
            this.completedTable.addSelectionChangedListener(event -> {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IOrder selectedOrder = (IOrder)selection.getFirstElement();
                if (selectedOrder != null) {
                    this.actionFactory.handleCompletedOrderSelection(selectedOrder);
                }
            });
        }
        if (tableViewers != null) {
            for (TableViewer yearTableViewer : tableViewers) {
                yearTableViewer.addSelectionChangedListener(event -> {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    IOrder selectedOrder = (IOrder)selection.getFirstElement();
                    if (selectedOrder != null) {
                        this.actionFactory.handleCompletedOrderSelection(selectedOrder);
                    }
                });
            }
        }
    }

    private void registerButtonListeners() {
        this.orderButton.addListener(13, event -> this.handleOrderButtonClick());
    }

    private void registerMouseWheelListeners(Table tblYear) {
        this.completedContainer.addListener(37, event -> this.actionFactory.handleMouseWheelScroll(event, this.rightScrollComposite));
        if (this.orderTable != null && !this.orderTable.getTable().isDisposed()) {
            this.orderTable.getTable().addListener(37, event -> this.actionFactory.handleMouseWheelScroll(event, this.rightScrollComposite));
        }
        if (tblYear != null && !tblYear.isDisposed()) {
            tblYear.addListener(37, event -> this.actionFactory.handleMouseWheelScroll(event, this.rightScrollComposite));
        }
        this.scrolledComposite.addListener(37, event -> this.actionFactory.handleMouseWheelScroll(event, this.scrolledComposite));
    }

    private void loadOpenOrders() {
        List<IOrder> orders = OrderManagementUtil.getOpenOrders();
        this.orderTable.setInput(orders);
        this.registerMouseWheelListeners(null);
        this.refresh();
    }

    private void loadCompletedOrders() {
        this.loadCompletedOrders(this.completedContainer);
    }

    public void loadCompletedOrders(final Composite completedContainer) {
        Control child;
        Control[] controlArray = completedContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpandableComposite oldSection;
            Object yearObj;
            child = controlArray[n2];
            if (child instanceof ExpandableComposite && (yearObj = (oldSection = (ExpandableComposite)child).getData("year")) instanceof Integer) {
                Integer oldYear = (Integer)yearObj;
                this.expandedStates.put(oldYear, oldSection.isExpanded());
            }
            ++n2;
        }
        controlArray = completedContainer.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        List<IOrder> orders = OrderManagementUtil.getCompletedOrders(this.showAllYears);
        if (orders.isEmpty()) {
            return;
        }
        Map<Integer, List<IOrder>> ordersByYear = orders.stream().collect(Collectors.groupingBy(o -> o.getTimestamp().getYear()));
        List<Integer> sortedYears = new ArrayList<Integer>(ordersByYear.keySet());
        sortedYears.sort(Collections.reverseOrder());
        if (!this.showAllYears && sortedYears.size() > 2) {
            sortedYears = sortedYears.subList(0, 2);
        }
        for (final Integer year : sortedYears) {
            final ExpandableComposite completedSection = new ExpandableComposite(completedContainer, 0, 44);
            completedSection.setLayoutData((Object)new GridData(4, 128, true, false));
            completedSection.setFont(this.createBoldFont((Control)this.titleLabel));
            completedSection.setText(Messages.OrderManagement_YearSection + String.valueOf(year));
            completedSection.setData("year", (Object)year);
            completedSection.setExpanded(false);
            Composite client = new Composite((Composite)completedSection, 0);
            client.setLayout((Layout)new GridLayout(1, false));
            TableViewer completedTableViewer = new TableViewer(client, 67584);
            Table tableControl = completedTableViewer.getTable();
            tableControl.setLayoutData((Object)new GridData(4, 4, true, true));
            tableControl.setHeaderVisible(true);
            tableControl.setLinesVisible(true);
            tableControl.setHeaderBackground(Display.getDefault().getSystemColor(22));
            tableControl.setBackground(Display.getDefault().getSystemColor(22));
            this.createTableColumns(completedTableViewer, new String[]{Messages.Core_Date, Messages.Core_Title}, new int[]{90, 210}, this.showDeliveredColumn);
            completedTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            completedTableViewer.setLabelProvider((IBaseLabelProvider)new CompletedOrderTableLabelProvider());
            completedTableViewer.setInput(ordersByYear.get(year));
            completedTableViewer.addSelectionChangedListener(event -> {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IOrder selectedOrder = (IOrder)selection.getFirstElement();
                if (selectedOrder != null) {
                    this.actOrder = selectedOrder;
                    this.showDeliveredColumn = true;
                    this.refresh();
                }
            });
            completedSection.setClient((Control)client);
            Boolean wasExpanded = this.expandedStates.get(year);
            if (wasExpanded != null) {
                completedSection.setExpanded(wasExpanded.booleanValue());
            }
            completedSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    OrderManagementView.this.expandedStates.put(year, completedSection.isExpanded());
                    completedContainer.layout(true, true);
                    OrderManagementView.this.updateUI();
                }
            });
            this.registerMouseWheelListeners(tableControl);
            this.actionFactory.createOrderHistoryMenu(completedTableViewer);
        }
        if (ordersByYear.size() > 2) {
            Button toggleButton = new Button(completedContainer, 8);
            toggleButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            toggleButton.setText(this.showAllYears ? Messages.OrderManagement_Toggle_Less : Messages.OrderManagement_Toggle_More);
            toggleButton.addListener(13, e -> {
                this.showAllYears = !this.showAllYears;
                this.loadCompletedOrders(completedContainer);
                completedContainer.layout(true, true);
                this.scrolledComposite.setMinSize(completedContainer.computeSize(-1, -1));
            });
        }
        this.refresh();
    }

    private void loadOrderDetails(IOrder order) {
        if (order == null) {
            this.actOrder = null;
            this.tableViewer.setInput(Collections.emptyList());
            return;
        }
        boolean allOpen = order.getEntries().stream().allMatch(e -> e.getState() == OrderEntryState.OPEN);
        this.showDeliveredColumn = !allOpen;
        this.actOrder = order;
        List alleEintraege = order.getEntries();
        if (this.tableViewer.getTable().getColumnCount() == 0) {
            String[] columnHeaders = new String[]{Messages.OrderManagement_Column_Status, Messages.OrderManagement_Column_Ordered, Messages.OrderManagement_Column_Delivered, Messages.Core_Add, Messages.OrderManagement_Column_Article, Messages.OrderManagement_Column_Supplier, Messages.OrderManagement_Column_Stock};
            int[] columnWidths = new int[]{80, 50, 60, 80, 190, 160, 50};
            this.createTableColumns(this.tableViewer, columnHeaders, columnWidths, this.showDeliveredColumn);
        }
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setInput((Object)alleEintraege);
        this.addEditingSupportForSupplierColumn();
        this.addEditingSupportForAddColumn();
        this.addEditingSupportForDeliveredColumn();
        this.addEditingSupportForOrderColumn();
        this.updateTableBackground(order);
        this.tableViewer.refresh();
        this.tableViewer.getTable().layout();
    }

    private void updateTableBackground(IOrder order) {
        boolean isBestellt;
        Table tableControl = this.tableViewer.getTable();
        boolean bl = isBestellt = order != null && order.getEntries().stream().anyMatch(e -> e.getState() != OrderEntryState.OPEN);
        if (isBestellt) {
            tableControl.setHeaderBackground(Display.getDefault().getSystemColor(22));
            tableControl.setBackground(Display.getDefault().getSystemColor(22));
        } else {
            tableControl.setHeaderBackground(Display.getDefault().getSystemColor(1));
            tableControl.setBackground(Display.getDefault().getSystemColor(1));
        }
        this.tableViewer.getTable().layout();
    }

    private void addEditingSupportForSupplierColumn() {
        TableColumn existingSupplierColumn = this.tableViewer.getTable().getColumn(5);
        TableViewerColumn supplierColumn = new TableViewerColumn(this.tableViewer, existingSupplierColumn);
        supplierColumn.setLabelProvider((CellLabelProvider)new EntryTableLabelProvider(5, this.showDeliveredColumn, this));
        supplierColumn.setEditingSupport((EditingSupport)new GenericOrderEditingSupport(this, this.tableViewer, GenericOrderEditingSupport.EditingColumnType.SUPPLIER, this.actOrder, 5, this.orderService));
    }

    private void addEditingSupportForAddColumn() {
        TableColumn existingDeliveredColumn = this.tableViewer.getTable().getColumn(3);
        TableViewerColumn deliveredColumn = new TableViewerColumn(this.tableViewer, existingDeliveredColumn);
        deliveredColumn.setLabelProvider((CellLabelProvider)new EntryTableLabelProvider(3, this.showDeliveredColumn, this));
        deliveredColumn.setEditingSupport((EditingSupport)new GenericOrderEditingSupport(this, this.tableViewer, GenericOrderEditingSupport.EditingColumnType.DELIVERED, this.actOrder, 3, this.orderService));
    }

    private void addEditingSupportForDeliveredColumn() {
        TableColumn existingDeliveredColumn = this.tableViewer.getTable().getColumn(2);
        TableViewerColumn deliveredColumn = new TableViewerColumn(this.tableViewer, existingDeliveredColumn);
        deliveredColumn.setLabelProvider((CellLabelProvider)new EntryTableLabelProvider(2, this.showDeliveredColumn, this));
    }

    private void addEditingSupportForOrderColumn() {
        TableColumn existingOrderColumn = this.tableViewer.getTable().getColumn(1);
        TableViewerColumn orderColumn = new TableViewerColumn(this.tableViewer, existingOrderColumn);
        orderColumn.setLabelProvider((CellLabelProvider)new EntryTableLabelProvider(1, this.showDeliveredColumn, this));
        orderColumn.setEditingSupport((EditingSupport)new GenericOrderEditingSupport(this, this.tableViewer, GenericOrderEditingSupport.EditingColumnType.ORDERED, this.actOrder, 1, this.orderService));
    }

    public void updateOrderDetails(IOrder order) {
        if (order == null) {
            return;
        }
        String createdStr = OrderManagementUtil.formatDate(order.getTimestamp());
        IOutputLog usierID = OrderManagementUtil.getOrderLogEntry(order);
        Image statusImage = OrderManagementUtil.getStatusIcon(order, false);
        this.cartIcon.setImage(statusImage);
        this.titleLabel.setText(order.getName());
        String creatorId = usierID != null && usierID.getCreatorId() != null ? usierID.getCreatorId() : Messages.UNKNOWN;
        this.createdLabelState.setText(createdStr + ", (" + creatorId + ")");
        this.statusValue.setText(OrderManagementUtil.getStatusText(order));
        this.updateOrderStatus(order);
        this.actionFactory.setOrder(this.actOrder);
        this.updateUI();
    }

    private void updateOrderStatus(IOrder order) {
        OrderHistoryEntry[] historyEntries;
        if (order == null) {
            return;
        }
        IOutputLog logEntry = OrderManagementUtil.getOrderLogEntry(order);
        String jsonLog = logEntry != null ? logEntry.getOutputterStatus() : "[]";
        try {
            historyEntries = (OrderHistoryEntry[])new Gson().fromJson(jsonLog, OrderHistoryEntry[].class);
        }
        catch (Exception e2) {
            historyEntries = new OrderHistoryEntry[]{};
        }
        String orderedUser = null;
        String orderedDate = null;
        String completedUser = null;
        String completedDate = null;
        DateTimeFormatter dateOnlyFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        int i = historyEntries.length - 1;
        while (i >= 0) {
            OrderHistoryEntry entry = historyEntries[i];
            if (entry.getAction() == OrderHistoryAction.ORDERED && orderedUser == null) {
                orderedUser = StringUtils.isNotBlank((CharSequence)entry.getUserId()) ? entry.getUserId() : Messages.UNKNOWN;
                orderedDate = this.parseDate(entry.getTimestamp(), dateOnlyFormat);
            }
            if (entry.getAction() == OrderHistoryAction.COMPLETEDELIVERY && completedUser == null) {
                completedUser = StringUtils.isNotBlank((CharSequence)entry.getUserId()) ? entry.getUserId() : Messages.UNKNOWN;
                completedDate = this.parseDate(entry.getTimestamp(), dateOnlyFormat);
            }
            --i;
        }
        boolean hasEntries = !order.getEntries().isEmpty();
        boolean allDone = hasEntries && order.getEntries().stream().allMatch(e -> e.getState() == OrderEntryState.DONE);
        boolean anyOrdered = order.getEntries().stream().anyMatch(e -> e.getState() == OrderEntryState.ORDERED || e.getState() == OrderEntryState.PARTIAL_DELIVER);
        boolean allEntriesHaveSupplier = order.getEntries().stream().allMatch(e -> e.getProvider() != null);
        boolean hasOpenEntries = order.getEntries().stream().anyMatch(e -> e.getState() == OrderEntryState.OPEN);
        this.dispatchedLabelIcon.setImage(allDone || anyOrdered ? OrderConstants.OrderImages.TICK : OrderConstants.OrderImages.CLEAR);
        this.dispatchedLabelState.setText((String)(allDone || anyOrdered ? this.defaultString(orderedDate) + ", (" + this.defaultString(orderedUser) + ")" : Messages.Corr_No));
        this.bookedLabelIcon.setImage(allDone ? OrderConstants.OrderImages.TICK : OrderConstants.OrderImages.CLEAR);
        this.bookedLabelState.setText((String)(allDone ? this.defaultString(completedDate) + ", (" + this.defaultString(completedUser) + ")" : Messages.Corr_No));
        if (this.orderButtonCustomImage != null && !this.orderButtonCustomImage.isDisposed()) {
            this.orderButtonCustomImage.dispose();
            this.orderButtonCustomImage = null;
        }
        if (allDone || order.getEntries().isEmpty()) {
            this.orderButton.setText("");
            this.orderButton.setImage(OrderConstants.OrderImages.TICK);
            this.orderButton.setEnabled(false);
        } else {
            this.orderButton.setEnabled(true);
            if (!hasOpenEntries && anyOrdered) {
                this.orderButton.setText(Messages.OrderManagement_Button_Book);
                this.orderButton.setImage(OrderConstants.OrderImages.IMPORT);
            } else if (allEntriesHaveSupplier) {
                this.orderButton.setText(Messages.OrderManagement_Button_Order);
                this.orderButton.setImage(OrderConstants.OrderImages.DELIVERY_TRUCK_64x64);
            } else {
                this.orderButton.setText(Messages.OrderManagement_Button_MissingSupplier);
                this.orderButton.setImage(OrderConstants.OrderImages.WARNING);
            }
        }
        if (hasOpenEntries || !hasEntries) {
            this.actionFactory.createContextMenu(this.tableViewer, this.orderTable);
        } else {
            this.tableViewer.getControl().setMenu(null);
        }
        this.updateCheckIn();
        this.updateCheckIn();
        if (!this.pendingDeliveredValues.isEmpty()) {
            this.orderButton.setText(Messages.MedicationComposite_btnConfirm);
            this.orderButton.setImage(Images.IMG_TICK.getImage());
        }
    }

    private String parseDate(String isoDateString, DateTimeFormatter formatter) {
        try {
            LocalDateTime dateTime = LocalDateTime.parse(isoDateString);
            return dateTime.format(formatter);
        }
        catch (Exception e) {
            return Messages.UNKNOWN;
        }
    }

    private String defaultString(String str) {
        return StringUtils.isNotBlank((CharSequence)str) ? str : Messages.UNKNOWN;
    }

    private void updateUI() {
        this.isDeliveryEditMode = false;
        if (this.isUIUpdating) {
            return;
        }
        this.isUIUpdating = true;
        Display.getDefault().syncExec(() -> {
            this.dispatchedComposite.layout(true, true);
            this.topComposite.layout();
            this.middleComposite.layout();
            this.leftComposite.layout();
            this.completedContainer.layout(true, true);
            this.scrolledComposite.setMinSize(this.completedContainer.computeSize(-1, -1));
            this.rightListComposite.layout(true, true);
            this.rightScrollComposite.setMinSize(this.rightListComposite.computeSize(-1, -1));
            this.orderTable.getTable().layout(true, true);
            this.isUIUpdating = false;
        });
    }

    public IOrder getOrder() {
        return this.actOrder;
    }

    public void setActOrder(IOrder selectedOrder) {
        this.actOrder = selectedOrder;
    }

    public void resetEditMode() {
        this.setDeliveryEditMode(false);
        this.pendingDeliveredValues.clear();
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
        if (barcodeScannerActivated) {
            OrderManagementUtil.activateBarcodeScannerAndFocus();
            this.setFocus();
            barcodeScannerActivated = false;
        }
    }

    private void makeActions() {
        this.actionFactory = new OrderManagementActionFactory(this, this.actOrder, this.orderService);
        this.actionFactory.initActions();
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        if (tbm != null) {
            tbm.add((IAction)this.actionFactory.getNewAction());
            tbm.add((IAction)this.actionFactory.getDailyWizardAction());
            tbm.add((IAction)this.actionFactory.getWizardAction());
            tbm.add((IAction)this.actionFactory.getPrintAction());
            tbm.add((IAction)this.actionFactory.getExportClipboardAction());
            actionBars.updateActionBars();
        }
    }

    public OrderManagementActionFactory getActionFactory() {
        return this.actionFactory;
    }

    public void dispose() {
        if (this.orderButtonCustomImage != null && !this.orderButtonCustomImage.isDisposed()) {
            this.orderButtonCustomImage.dispose();
        }
        this.getSite().getPage().removePartListener((IPartListener2)this.focusListener);
        super.dispose();
    }

    public Map<IOrderEntry, Integer> getPendingDeliveredValues() {
        return this.pendingDeliveredValues;
    }
}

