/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISickCertificate;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.commands.AufByFallFilter;
import ch.elexis.core.ui.dialogs.EditAUFDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.views.BriefAuswahl;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.provider.Auf2LabelProvider;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.LoggerFactory;

public class AUF2
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.auf";
    TableViewer tv;
    private Action newAUF;
    private Action filterAUF;
    private Action printList;
    private Action delAUF;
    private Action modAUF;
    private Action printAUF;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);
    private AufByFallFilter aufFilter = new AufByFallFilter();
    private boolean isFilterActive = false;
    private String currentFallID = null;
    private List<ISickCertificate> selectedCertificates = new ArrayList<ISickCertificate>();

    @Inject
    void activeCertificate(@org.eclipse.e4.core.di.annotations.Optional ISickCertificate certificate) {
        CoreUiUtil.runAsyncIfActive(() -> {
            boolean bSelect = certificate != null;
            this.modAUF.setEnabled(bSelect);
            this.delAUF.setEnabled(bSelect);
            if (bSelect && this.tv != null && !Objects.equals(this.tv.getStructuredSelection(), new StructuredSelection((Object)certificate))) {
                this.tv.refresh(false);
                this.tv.setSelection((ISelection)new StructuredSelection((Object)certificate));
            }
        }, (Object)this.tv);
    }

    @Inject
    void activePatient(@org.eclipse.e4.core.di.annotations.Optional IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            if (patient != null) {
                this.tv.refresh();
                ContextServiceHolder.get().getRootContext().removeTyped(ISickCertificate.class);
                this.newAUF.setEnabled(true);
            } else {
                this.newAUF.setEnabled(false);
                this.modAUF.setEnabled(false);
                this.delAUF.setEnabled(false);
            }
        }, (Object)this.tv);
    }

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    void activeCoverage(ICoverage iCoverage) {
        String fallId = iCoverage.getId().toString();
        if (this.isFilterActive) {
            this.aufFilter.setFallID(fallId);
            this.tv.refresh();
        }
        this.currentFallID = fallId;
    }

    public AUF2() {
        this.setTitleImage(Images.IMG_VIEW_WORK_INCAPABLE.getImage());
    }

    public void createPartControl(Composite parent) {
        this.setPartName(Messages.AUF2_certificate);
        this.tv = new TableViewer(parent, 770);
        this.tv.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider());
        this.tv.setContentProvider((IContentProvider)new AUFContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new Auf2LabelProvider());
        this.makeActions();
        ViewMenus menus = new ViewMenus(this.getViewSite());
        menus.createMenu(new IAction[]{this.newAUF, this.filterAUF, this.printList, this.delAUF, this.modAUF, this.printAUF});
        menus.createToolbar(new IAction[]{this.newAUF, this.filterAUF, this.printList, this.delAUF, this.printAUF});
        this.tv.setUseHashlookup(true);
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getStructuredSelection().getFirstElement() instanceof ISickCertificate) {
                    ContextServiceHolder.get().getRootContext().setTyped(event.getStructuredSelection().getFirstElement());
                }
            }
        });
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AUF2.this.modAUF.run();
            }
        });
        this.tv.setInput((Object)this.getViewSite());
        Transfer[] dragTransferTypes = new Transfer[]{TextTransfer.getInstance()};
        this.tv.addDragSupport(1, dragTransferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)AUF2.this.tv.getSelection();
                StringBuilder sb = new StringBuilder();
                if (selection != null && !selection.isEmpty()) {
                    ISickCertificate auf = (ISickCertificate)selection.getFirstElement();
                    sb.append(StoreToStringServiceHolder.getStoreToString((Object)auf)).append(",");
                }
                event.data = sb.toString().replace(",$", "");
            }
        });
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AUF2.this.selectedCertificates.clear();
                IStructuredSelection selection = (IStructuredSelection)AUF2.this.tv.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof ISickCertificate) {
                        AUF2.this.selectedCertificates.add((ISickCertificate)obj);
                    }
                    ++n2;
                }
            }
        });
        this.tv.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (AUF2.this.tv.getTable().getItem(new Point(e.x, e.y)) == null) {
                    AUF2.this.tv.setSelection((ISelection)StructuredSelection.EMPTY);
                    AUF2.this.selectedCertificates.clear();
                }
            }
        });
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
    }

    public void setFocus() {
    }

    private void makeActions() {
        this.newAUF = new Action(Messages.Core_New_ellipsis){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.AUF2_createNewCert);
            }

            public void run() {
                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                try {
                    Object createdAuf = handlerService.executeCommand("ch.elexis.core.ui.commands.AufNew", null);
                    if (createdAuf instanceof ISickCertificate) {
                        ContextServiceHolder.get().getRootContext().setTyped(createdAuf);
                    }
                    AUF2.this.refresh();
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(BriefAuswahl.class).error("cannot execute cmd", (Throwable)e);
                }
            }
        };
        this.filterAUF = new Action(Messages.Feature_filter, 2){
            {
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
                this.setToolTipText(Messages.Feature_filter);
            }

            public void run() {
                AUF2.this.aufFilter.setFilterActive(!AUF2.this.isFilterActive);
                if (AUF2.this.isFilterActive) {
                    AUF2.this.aufFilter.resetFallID();
                    AUF2.this.tv.removeFilter((ViewerFilter)AUF2.this.aufFilter);
                } else {
                    if (AUF2.this.currentFallID != null) {
                        AUF2.this.aufFilter.setFallID(AUF2.this.currentFallID);
                    }
                    AUF2.this.tv.addFilter((ViewerFilter)AUF2.this.aufFilter);
                }
                AUF2.this.isFilterActive = !AUF2.this.isFilterActive;
                AUF2.this.tv.refresh();
            }
        };
        this.printList = new Action(Messages.Core_Print_List){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.AUF2_LIST_TOOLBAR);
            }

            public void run() {
                try {
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    handlerService.executeCommand("ch.elexis.core.ui.commands.AufPrintList", null);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(BriefAuswahl.class).error("cannot execute cmd", (Throwable)e);
                }
            }
        };
        this.delAUF = new Action(Messages.Core_Delete_ellipsis){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.AUF2_deleteCertificate);
            }

            public void run() {
                ISickCertificate sel = AUF2.this.getSelectedCertificate();
                if (sel != null && MessageDialog.openConfirm((Shell)AUF2.this.getViewSite().getShell(), (String)Messages.AUF2_deleteReally, (String)Messages.AUF2_doyoywantdeletereally)) {
                    CoreModelServiceHolder.get().delete((Deleteable)sel);
                    AUF2.this.tv.refresh(false);
                }
            }
        };
        this.modAUF = new Action(Messages.Core_DoChange_ellipsis){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.AUF2_editCertificate);
            }

            public void run() {
                ISickCertificate sel = AUF2.this.getSelectedCertificate();
                if (sel != null) {
                    new EditAUFDialog(AUF2.this.getViewSite().getShell(), sel, sel.getCoverage()).open();
                    AUF2.this.tv.refresh(true);
                }
            }
        };
        this.printAUF = new Action(Messages.Core_Print_ellipsis){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.AUF2_createPrint);
            }

            public void run() {
                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("ch.elexis.core.ui.commands.AufPrint", null);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(BriefAuswahl.class).error("cannot execute cmd", (Throwable)e);
                }
            }
        };
    }

    private ISickCertificate getSelectedCertificate() {
        IStructuredSelection sel = (IStructuredSelection)this.tv.getSelection();
        if (sel == null || sel.isEmpty()) {
            return null;
        }
        return (ISickCertificate)sel.getFirstElement();
    }

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    @Override
    public void refresh() {
        Display.getDefault().asyncExec(() -> this.tv.refresh());
    }

    public TableViewer getViewer() {
        return this.tv;
    }

    public boolean isFilterActive() {
        return this.isFilterActive;
    }

    public AufByFallFilter getFilter() {
        return this.aufFilter;
    }

    public List<ISickCertificate> getSelectedCertificates() {
        return this.selectedCertificates;
    }

    public class AUFContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            Optional patient = ContextServiceHolder.get().getActivePatient();
            if (patient.isPresent()) {
                INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(ISickCertificate.class, new String[]{"patient"});
                List list = query.executeWithParameters(query.getParameterMap(new Object[]{"patient", patient.get()}));
                return list.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

