/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.text;

import ch.elexis.core.ui.actions.ScannerEvents;
import ch.elexis.core.ui.util.IScannerListener;
import java.util.ArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ElexisText
implements IScannerListener,
DisposeListener {
    final ArrayList<IScannerListener> scannerListener;
    final Text text;

    public ElexisText(Text text) {
        this.text = text;
        this.scannerListener = new ArrayList();
        this.text.addDisposeListener((DisposeListener)this);
    }

    public Widget getWidget() {
        return this.text;
    }

    public void widgetDisposed(DisposeEvent e) {
        ScannerEvents.getInstance().removeScannerListener(this);
    }

    public ElexisText(Composite parent, int style) {
        this(new Text(parent, style));
    }

    public void addKeyListener(KeyListener listener) {
        this.text.addKeyListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.text.addModifyListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.text.addSelectionListener(listener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.text.addVerifyListener(listener);
    }

    public void addScannerListener(IScannerListener listener) {
        if (this.scannerListener.isEmpty()) {
            ScannerEvents.getInstance().addScannerListener(this);
        }
        this.scannerListener.add(listener);
    }

    public void removeScannerListener(IScannerListener listener) {
        this.scannerListener.remove(listener);
    }

    @Override
    public void scannerInput(Event e) {
        if (e.widget == this.text) {
            this.fireScannerEvent(e);
        }
    }

    public void fireScannerEvent(Event e) {
        for (IScannerListener listener : this.scannerListener) {
            listener.scannerInput(e);
        }
    }

    public void append(String string) {
        this.text.append(string);
    }

    public void clearSelection() {
        this.text.clearSelection();
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        return this.text.computeSize(hint, hint2, changed);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return this.text.computeTrim(x, y, width, height);
    }

    public void copy() {
        this.text.copy();
    }

    public void cut() {
        this.text.cut();
    }

    public int getBorderWidth() {
        return this.text.getBorderWidth();
    }

    public int getCaretLineNumber() {
        return this.text.getCaretLineNumber();
    }

    public Point getCaretLocation() {
        return this.text.getCaretLocation();
    }

    public int getCaretPosition() {
        return this.text.getCaretPosition();
    }

    public int getCharCount() {
        return this.text.getCharCount();
    }

    public boolean getDoubleClickEnabled() {
        return this.text.getDoubleClickEnabled();
    }

    public char getEchoChar() {
        return this.text.getEchoChar();
    }

    public boolean getEditable() {
        return this.text.getEditable();
    }

    public int getLineCount() {
        return this.text.getLineCount();
    }

    public String getLineDelimiter() {
        return this.text.getLineDelimiter();
    }

    public int getLineHeight() {
        return this.text.getLineHeight();
    }

    public String getMessage() {
        return this.text.getMessage();
    }

    public int getOrientation() {
        return this.text.getOrientation();
    }

    public Point getSelection() {
        return this.text.getSelection();
    }

    public int getSelectionCount() {
        return this.text.getSelectionCount();
    }

    public String getSelectionText() {
        return this.text.getSelectionText();
    }

    public int getTabs() {
        return this.text.getTabs();
    }

    public String getText() {
        return this.text.getText();
    }

    public String getText(int start, int end) {
        return this.text.getText(start, end);
    }

    public int getTextLimit() {
        return this.text.getTextLimit();
    }

    public int getTopIndex() {
        return this.text.getTopIndex();
    }

    public int getTopPixel() {
        return this.text.getTopPixel();
    }

    public void insert(String string) {
        this.text.insert(string);
    }

    public void paste() {
        this.text.paste();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.text.removeModifyListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.text.removeSelectionListener(listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.text.removeVerifyListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.text.removeKeyListener(listener);
    }

    public void selectAll() {
        this.text.selectAll();
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.text.setDoubleClickEnabled(doubleClick);
    }

    public void setEchoChar(char echo) {
        this.text.setEchoChar(echo);
    }

    public void setEditable(boolean editable) {
        this.text.setEditable(editable);
    }

    public void setFont(Font font) {
        this.text.setFont(font);
    }

    public void setMessage(String message) {
        this.text.setMessage(message);
    }

    public void setOrientation(int orientation) {
        this.text.setOrientation(orientation);
    }

    public void setRedraw(boolean redraw) {
        this.text.setRedraw(redraw);
    }

    public void setSelection(int start, int end) {
        this.text.setSelection(start, end);
    }

    public void setSelection(int start) {
        this.text.setSelection(start);
    }

    public void setSelection(Point selection) {
        this.text.setSelection(selection);
    }

    public void setTabs(int tabs) {
        this.text.setTabs(tabs);
    }

    public void setText(String string) {
        this.text.setText(string);
    }

    public void setTextLimit(int limit) {
        this.text.setTextLimit(limit);
    }

    public void setTopIndex(int index) {
        this.text.setTopIndex(index);
    }

    public void showSelection() {
        this.text.showSelection();
    }

    public boolean setFocus() {
        return this.text.setFocus();
    }

    public void setToolTipText(String string) {
        this.text.setToolTipText(string);
    }

    public void setLayoutData(Object layoutData) {
        this.text.setLayoutData(layoutData);
    }
}

