/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.text;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dialogs.ResultDialog;
import ch.elexis.core.ui.util.IKonsMakro;
import ch.elexis.data.Leistungsblock;
import ch.rgw.tools.Result;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BlockMakro
implements IKonsMakro {
    @Override
    public String executeMakro(String makro) {
        List macros;
        Optional actEncounter = ContextServiceHolder.get().getTyped(IEncounter.class);
        if (actEncounter.isPresent() && (macros = Leistungsblock.findMacrosValidForCurrentMandator((String)makro)) != null && !macros.isEmpty()) {
            Leistungsblock lb = (Leistungsblock)macros.get(0);
            this.addBlock((IEncounter)actEncounter.get(), CoreModelServiceHolder.get().load(lb.getId(), ICodeElementBlock.class).orElse(null));
            return "";
        }
        return null;
    }

    public void addBlock(IEncounter encounter, ICodeElementBlock elementBlock) {
        if (elementBlock != null && encounter != null) {
            List diff;
            List elements = elementBlock.getElements();
            StringJoiner notOkResults = new StringJoiner("\n");
            for (ICodeElement ice : elements) {
                if (ice instanceof IBillable) {
                    Result res = BillingServiceHolder.get().bill((IBillable)ice, encounter, 1.0);
                    if (res.isOK()) continue;
                    String message = ice.getCode() + " - " + ResultDialog.getResultMessage(res);
                    if (notOkResults.toString().contains(message)) continue;
                    notOkResults.add(message);
                    continue;
                }
                if (!(ice instanceof IDiagnosis)) continue;
                encounter.addDiagnosis((IDiagnosis)ice);
                CoreModelServiceHolder.get().save((Identifiable)encounter);
            }
            if (!notOkResults.toString().isEmpty()) {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Core_Warning, (String)notOkResults.toString());
            }
            if (!(diff = elementBlock.getDiffToReferences(elements)).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                diff.forEach(r -> {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(r);
                });
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Warnung", (String)("Warnung folgende Leistungen konnten im aktuellen Kontext (Fall, Konsultation, Gesetz) nicht verrechnet werden.\n" + sb.toString()));
            }
            ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)encounter);
        }
    }
}

