/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs.eedep;

import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.services.oauth2.AuthorizationCodeFlowWithPKCE;
import ch.elexis.core.status.ObjectStatus;
import ch.elexis.core.status.StatusUtil;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import com.equo.chromium.swt.Browser;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.workbench.swt.DisplayUISynchronize;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcBrowserLoginDialog
extends Dialog {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    Gson gson;
    UISynchronize uiSynchronizer;
    private String tokenEndpoint;
    private String authorizationEndpoint;
    private AuthorizationCodeFlowWithPKCE acfwpkce;
    private ObjectStatus<AccessToken> accessToken;
    private Browser browser;
    private Runnable handleFlowRunnable = () -> {
        String clientSecret = System.getProperty("ee.client-secret");
        try {
            URI initiateFlowGetBrowserUrl = this.acfwpkce.initiateFlowGetBrowserUrl(URI.create(this.authorizationEndpoint), clientSecret);
            this.uiSynchronizer.asyncExec(() -> {
                boolean bl = this.browser.setUrl(initiateFlowGetBrowserUrl.toString());
            });
            this.logger.debug("Initiated flow, waiting for authorization code ...");
            this.accessToken = this.acfwpkce.fetchAccessTokenAfterAuthorizationCode(this.gson, this.tokenEndpoint, clientSecret);
            StatusUtil.logStatus((String)"Terminating", (Logger)this.logger, this.accessToken, (boolean)true, (boolean)true);
            this.uiSynchronizer.asyncExec(() -> this.okPressed());
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            this.logger.warn("Aborting Authorization Flow", (Throwable)e);
            this.acfwpkce.abort();
            this.uiSynchronizer.asyncExec(() -> {
                boolean bl = this.browser.setText("<HTML>" + e.getMessage() + "</HTML>");
            });
        }
    };

    public OidcBrowserLoginDialog(Shell shell, String authorizationEndpoint, String tokenEndpoint) {
        super(shell);
        this.tokenEndpoint = tokenEndpoint;
        this.acfwpkce = new AuthorizationCodeFlowWithPKCE("elexis-rcp-openid");
        this.authorizationEndpoint = authorizationEndpoint;
        this.uiSynchronizer = new DisplayUISynchronize(shell.getDisplay());
        CoreUiUtil.injectServices((Object)((Object)this));
    }

    protected Control createDialogArea(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.browser.setText("<HTML>Initiating login ...</HTML>");
        new Thread(this.handleFlowRunnable).start();
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public AccessToken getAccessToken() {
        return (AccessToken)this.accessToken.get();
    }

    protected void cancelPressed() {
        this.acfwpkce.abort();
        super.cancelPressed();
    }

    protected Point getInitialSize() {
        return new Point(1024, 768);
    }
}

