/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.services.holder.LocalLockServiceHolder;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;

public class SelectOrCreateOpenKonsDialog
extends TitleAreaDialog {
    private IPatient patient;
    private ComboViewer fallCombo;
    private ComboViewer openKonsCombo;
    private IEncounter konsultation;
    private String title;

    public SelectOrCreateOpenKonsDialog(IPatient patient) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.patient = patient;
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
    }

    public SelectOrCreateOpenKonsDialog(IPatient patient, String title) {
        this(patient);
        this.title = title;
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
    }

    public void create() {
        super.create();
        this.getShell().setText("Konsultation ausw\u00e4hlen");
        this.setTitle(this.title);
        this.setMessage(String.format("Erstellen bzw. w\u00e4hlen Sie eine Konsultation f\u00fcr den Patienten %s aus\n", this.patient.getLabel()));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite areaComposite = new Composite(composite, 0);
        areaComposite.setLayoutData((Object)new GridData(1808));
        areaComposite.setLayout((Layout)new FormLayout());
        Label lbl = new Label(areaComposite, 0);
        lbl.setText("Konsultation erstellen");
        ToolBarManager tbManager = new ToolBarManager(8388928);
        tbManager.add((IAction)new RestrictedAction((EvaluatableACE)EvACE.of(IEncounter.class, (Right)Right.CREATE), Messages.Core_New_Consultation){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.Core_Create_new_consultation);
            }

            @Override
            public void doRun() {
                IEncounter kons = null;
                ICoverage fall = null;
                IStructuredSelection selection = SelectOrCreateOpenKonsDialog.this.fallCombo.getStructuredSelection();
                if (selection.isEmpty()) {
                    List<ICoverage> openFall = SelectOrCreateOpenKonsDialog.this.getOpenFall();
                    if (openFall.isEmpty()) {
                        fall = CoverageServiceHolder.get().createDefaultCoverage(SelectOrCreateOpenKonsDialog.this.patient);
                    }
                } else {
                    fall = (ICoverage)selection.getFirstElement();
                }
                if (fall != null) {
                    kons = (IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), fall, (IMandator)ContextServiceHolder.get().getActiveMandator().orElse(null)).buildAndSave();
                    EncounterServiceHolder.get().addDefaultDiagnosis(kons);
                }
                if (kons != null) {
                    LocalLockServiceHolder.get().acquireLock(kons);
                    LocalLockServiceHolder.get().releaseLock(kons);
                }
                SelectOrCreateOpenKonsDialog.this.fallCombo.setInput(SelectOrCreateOpenKonsDialog.this.getOpenFall());
                if (!selection.isEmpty()) {
                    SelectOrCreateOpenKonsDialog.this.fallCombo.setSelection((ISelection)selection);
                }
                SelectOrCreateOpenKonsDialog.this.openKonsCombo.setInput(SelectOrCreateOpenKonsDialog.this.getOpenKons());
            }
        });
        ToolBar toolbar = tbManager.createControl(areaComposite);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 5);
        lbl.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(30, 5);
        toolbar.setLayoutData((Object)fd);
        this.fallCombo = new ComboViewer(areaComposite);
        this.fallCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fallCombo.setInput(this.getOpenFall());
        this.fallCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ICoverage)element).getLabel();
            }
        });
        this.fallCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)SelectOrCreateOpenKonsDialog.this.fallCombo.getSelection();
                if (!selection.isEmpty()) {
                    ContextServiceHolder.get().setTyped(selection.getFirstElement());
                }
            }
        });
        ICoverage selectedFall = ContextServiceHolder.get().getTyped(ICoverage.class).orElse(null);
        if (selectedFall != null) {
            this.fallCombo.setSelection((ISelection)new StructuredSelection((Object)selectedFall));
        }
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment((Control)toolbar, 5);
        this.fallCombo.getControl().setLayoutData((Object)fd);
        lbl = new Label(areaComposite, 0);
        lbl.setText("Konsultation ausw\u00e4hlen");
        this.openKonsCombo = new ComboViewer(areaComposite);
        this.openKonsCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.openKonsCombo.setInput(this.getOpenKons());
        this.openKonsCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IEncounter)element).getLabel();
            }
        });
        fd = new FormData();
        fd.top = new FormAttachment((Control)toolbar, 5);
        fd.left = new FormAttachment(0, 5);
        lbl.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)toolbar, 5);
        fd.left = new FormAttachment(30, 5);
        fd.right = new FormAttachment(100, -5);
        this.openKonsCombo.getControl().setLayoutData((Object)fd);
        return areaComposite;
    }

    private List<ICoverage> getOpenFall() {
        ArrayList<ICoverage> ret = new ArrayList<ICoverage>();
        List faelle = this.patient.getCoverages();
        for (ICoverage f : faelle) {
            if (!f.isOpen()) continue;
            ret.add(f);
        }
        return ret;
    }

    protected List<IEncounter> getOpenKons() {
        ArrayList<IEncounter> ret = new ArrayList<IEncounter>();
        List faelle = this.patient.getCoverages();
        for (ICoverage f : faelle) {
            if (!f.isOpen()) continue;
            List consultations = f.getEncounters();
            for (IEncounter konsultation : consultations) {
                if (!EncounterServiceHolder.get().isEditable(konsultation)) continue;
                ret.add(konsultation);
            }
        }
        return ret;
    }

    public void okPressed() {
        Object obj = ((IStructuredSelection)this.openKonsCombo.getSelection()).getFirstElement();
        if (obj instanceof IEncounter) {
            this.konsultation = (IEncounter)obj;
            super.okPressed();
        }
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.setErrorMessage("Keine Konsultation ausgew\u00e4hlt.");
        }
    }

    public IEncounter getKonsultation() {
        return this.konsultation;
    }

    @Optional
    @Inject
    private void createCoverage(@UIEventTopic(value="info/elexis/model/create") ICoverage iCoverage) {
        CoreUiUtil.runAsyncIfActive(() -> {
            this.openKonsCombo.setInput(this.getOpenKons());
            this.openKonsCombo.refresh();
        }, (Object)this.openKonsCombo);
    }

    @Optional
    @Inject
    private void updateCoverage(@UIEventTopic(value="info/elexis/model/update") ICoverage iCoverage) {
        CoreUiUtil.runAsyncIfActive(() -> {
            this.openKonsCombo.setInput(this.getOpenKons());
            this.openKonsCombo.refresh();
        }, (Object)this.openKonsCombo);
    }
}

