/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOutputLog;
import ch.elexis.core.model.OrderHistoryAction;
import ch.elexis.core.model.OrderHistoryEntry;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.util.OrderManagementUtil;
import com.google.gson.Gson;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;

public class HistoryDialog
extends Dialog {
    private static final String BASE_HTML = "<html>\n  <head>\n    <meta charset=\"UTF-8\">\n    <style>\n      body {\n        font-family: Arial;\n        margin: 0;\n        padding: 0;\n      }\n      .header {\n        text-align: center;\n        margin-top: 10px;\n        font-size: 1.2em;\n        font-weight: bold;\n      }\n      .description {\n        text-align: center;\n        color: #555;\n        margin: 5px 0 10px 0;\n        font-size: 0.95em;\n      }\n\n      table {\n        border-collapse: collapse;\n        width: 100%;\n        font-family: Arial;\n        font-size: 14px;\n      }\n      th {\n        background-color: #9D9D9D;\n        color: white;\n      }\n    </style>\n  </head>\n  <body>\n  </body>\n</html>\n";
    private IOrder order;
    private String historyContent;

    public HistoryDialog(Shell parentShell, IOrder order) {
        super(parentShell);
        this.order = order;
        this.historyContent = this.generateHistoryContent(order);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.order.getLabel());
        newShell.setSize(1400, 600);
        newShell.setMinimumSize(800, 400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new FillLayout());
        Browser browser = new Browser(container, 0);
        browser.setLayoutData((Object)new GridData(4, 4, true, true));
        browser.setText(this.historyContent);
        return container;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    private String generateHistoryContent(IOrder order) {
        OrderHistoryEntry[] historyEntries;
        if (order == null) {
            return String.format("              <html><body style=\"font-family: Arial;\">\n   <p>%s</p>\n              </body></html>\n", Messages.HistoryDialog_NoHistoryAvailable);
        }
        IOutputLog logEntry = OrderManagementUtil.getOrderLogEntry(order);
        String jsonLog = logEntry != null ? logEntry.getOutputterStatus() : "[]";
        try {
            historyEntries = (OrderHistoryEntry[])new Gson().fromJson(jsonLog, OrderHistoryEntry[].class);
        }
        catch (Exception e) {
            historyEntries = new OrderHistoryEntry[]{};
        }
        if (historyEntries.length == 0) {
            return String.format("              <html><body style=\"font-family: Arial;\">\n   <p>%s</p>\n              </body></html>\n", Messages.HistoryDialog_NoHistoryAvailable);
        }
        Document doc = Jsoup.parse((String)BASE_HTML, (String)"", (Parser)Parser.htmlParser());
        doc.outputSettings().prettyPrint(false);
        Element body = doc.body();
        body.appendElement("div").addClass("header").text(Messages.HistoryDialog_Header);
        body.appendElement("div").addClass("description").text(Messages.HistoryDialog_Description);
        Element table = body.appendElement("table").attr("border", "1").attr("cellspacing", "0").attr("cellpadding", "5");
        Element headerRow = table.appendElement("tr");
        headerRow.appendElement("th").text(Messages.HistoryDialog_Action);
        headerRow.appendElement("th").text(Messages.HistoryDialog_Details);
        headerRow.appendElement("th").text(Messages.HistoryDialog_Date);
        headerRow.appendElement("th").text(Messages.HistoryDialog_User);
        this.fillTableRows(table, historyEntries);
        return doc.html();
    }

    private void fillTableRows(Element table, OrderHistoryEntry[] entries) {
        DateTimeFormatter displayFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
        int i = 0;
        while (i < entries.length) {
            OrderHistoryEntry entry = entries[i];
            String timestamp = LocalDateTime.parse(entry.getTimestamp()).format(displayFormat);
            String userId = entry.getUserId();
            OrderHistoryAction action = entry.getAction();
            String icon = "";
            String actionText = "";
            if (action != null) {
                icon = action.getIcon();
                actionText = action.getTranslation();
            } else {
                actionText = ch.elexis.core.l10n.Messages.UNKNOWN;
            }
            String details = entry.getDetails() != null ? entry.getDetails().replace("\n", " ") : "";
            String extraInfo = entry.getExtraInfo() != null ? entry.getExtraInfo().replace("\n", " ") : "";
            String rowColor = i % 2 == 0 ? "#f2f2f2" : "";
            Element row = table.appendElement("tr").attr("style", "background-color: " + rowColor + ";");
            row.appendElement("td").html(icon + " <b>" + actionText + "</b>");
            String detailsText = details + (String)(!extraInfo.isEmpty() ? " (" + extraInfo + ")" : "");
            row.appendElement("td").text(detailsText);
            row.appendElement("td").html("<b>" + timestamp + "</b>");
            row.appendElement("td").text(userId);
            ++i;
        }
    }
}

