/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.util.LocalLock;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.util.DocumentLetterUtil;
import ch.elexis.core.preferences.PreferencesUtil;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IConflictHandler;
import ch.elexis.core.services.IElexisServerService;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ElexisServerServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.commands.Messages;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.services.LocalDocumentServiceHolder;
import ch.elexis.data.Brief;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartEditLocalDocumentHandler
extends AbstractHandler
implements IHandler {
    public static final String CONVERT_DOCX_2_PDF = "ch.elexis.test.convertDocx2PDF";
    private static Logger logger = LoggerFactory.getLogger(StartEditLocalDocumentHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEclipseContext iEclipseContext = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        StructuredSelection selection = (StructuredSelection)iEclipseContext.get(event.getCommand().getId().concat(".selection"));
        iEclipseContext.remove(event.getCommand().getId().concat(".selection"));
        if (selection != null && !selection.isEmpty()) {
            List selected = selection.toList();
            final Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            for (Object object : selected) {
                Optional<ILocalDocumentService> localDocumentService = LocalDocumentServiceHolder.getService();
                if (!localDocumentService.isPresent()) continue;
                final ILocalDocumentService service = localDocumentService.get();
                if (ElexisServerServiceHolder.get().getConnectionStatus() == IElexisServerService.ConnectionStatus.REMOTE) {
                    Identifiable lockObject;
                    boolean isHandledExternalOpen;
                    if (object instanceof IPersistentObject) {
                        final IPersistentObject lockObject2 = (IPersistentObject)object;
                        boolean isHandledByExternalOpen = this.tryHandleExternalIfApplicable(lockObject2);
                        if (isHandledByExternalOpen) continue;
                        AcquireLockUi.aquireAndRun(lockObject2, new ILockHandler(){

                            @Override
                            public void lockFailed() {
                            }

                            @Override
                            public void lockAcquired() {
                                StartEditLocalDocumentHandler.this.startEditLocal(lockObject2, service, parentShell);
                            }
                        });
                        continue;
                    }
                    if (!(object instanceof Identifiable) || (isHandledExternalOpen = this.tryHandleExternalIfApplicable(lockObject = (Identifiable)object))) continue;
                    AcquireLockUi.aquireAndRun(lockObject, new ILockHandler(){

                        @Override
                        public void lockFailed() {
                        }

                        @Override
                        public void lockAcquired() {
                            StartEditLocalDocumentHandler.this.startEditLocal(lockObject, service, parentShell);
                        }
                    });
                    continue;
                }
                boolean isHandledExternalOpen = this.tryHandleExternalIfApplicable(object);
                if (isHandledExternalOpen) continue;
                LocalLock lock = new LocalLock(object);
                if (!lock.tryLock()) {
                    if (service.contains(object) && lock.hasLock(CoreHub.getLoggedInContact().getLabel()) || MessageDialog.openQuestion((Shell)parentShell, (String)Messages.Core_Warning, (String)(Messages.StartEditLocalDocumentHandler_alreadyOpenStart + lock.getLockMessage() + Messages.StartEditLocalDocumentHandler_alreadyOpenEnd))) {
                        lock.unlock();
                        if (!lock.tryLock()) {
                            MessageDialog.openError((Shell)parentShell, (String)Messages.Core_Error, (String)Messages.Core_Document_Not_Opened_Locally);
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                this.startEditLocal(object, service, parentShell);
            }
        }
        return null;
    }

    public static void convertDocx2Pdf(Optional<File> file) {
        for (String format : List.of("pdf", "txt")) {
            String filePath = file.get().getAbsolutePath();
            String storage = PreferencesUtil.getOsSpecificPreference((String)"briefe/Textmodul_Extern_File_Path", (IConfigService)ConfigServiceHolder.get());
            String fullCmd = String.format("libreoffice --headless --convert-to %s --outdir %s %s", format, storage, filePath);
            logger.info("Convert external file using");
            logger.info(fullCmd);
            try {
                Runtime run = Runtime.getRuntime();
                Process runner = run.exec(fullCmd);
                while (runner.isAlive()) {
                    Thread.sleep(200L);
                }
                logger.info(" created: " + storage + File.separator + file.get().getName().replace("docx", format));
            }
            catch (IOException | InterruptedException e) {
                logger.error("Unable to produce pdf. Error was {}", (Object)e.getMessage());
            }
        }
    }

    public static boolean isConvertDocx2Pdf(String extension) {
        String convert2pdf = System.getProperty(CONVERT_DOCX_2_PDF, "");
        return extension.equalsIgnoreCase("docx") && !convert2pdf.equals("");
    }

    private boolean tryHandleExternalIfApplicable(Object lockObject) {
        if (ConfigServiceHolder.getGlobal((String)"briefe/Textmodul_Extern_File", (boolean)false) && lockObject != null) {
            IDocument document = null;
            if (lockObject instanceof Brief) {
                document = ((Brief)lockObject).toIDocument();
            } else if (lockObject instanceof IDocumentLetter) {
                document = (IDocumentLetter)lockObject;
            } else {
                logger.error("Invalid argument [{}]", lockObject.getClass());
                return false;
            }
            IVirtualFilesystemService.IVirtualFilesystemHandle handle = DocumentLetterUtil.getExternalHandleIfApplicable((IDocument)document);
            Optional file = handle.toFile();
            if (file.isPresent()) {
                if (StartEditLocalDocumentHandler.isConvertDocx2Pdf(handle.getExtension())) {
                    StartEditLocalDocumentHandler.convertDocx2Pdf(file);
                } else {
                    logger.info("Open external file {}", (Object)((File)file.get()).getAbsolutePath());
                    Program.launch((String)((File)file.get()).getAbsolutePath());
                }
            } else {
                logger.warn("IVirtualFilesystemHandle [" + handle.getAbsolutePath() + "] can not be opened as file");
                MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)Messages.Core_Error, (String)Messages.Core_Document_Not_Opened_Locally);
            }
            return true;
        }
        return false;
    }

    private void startEditLocal(Object object, ILocalDocumentService service, final Shell parentShell) {
        Optional file = Optional.empty();
        if (object instanceof IDocumentLetter) {
            file = service.add(object, new IConflictHandler(){

                public IConflictHandler.Result getResult() {
                    if (MessageDialog.openQuestion((Shell)parentShell, (String)Messages.StartEditLocalDocumentHandler_conflicttitle, (String)Messages.StartEditLocalDocumentHandler_conflictmessage)) {
                        return IConflictHandler.Result.KEEP;
                    }
                    return IConflictHandler.Result.OVERWRITE;
                }
            });
        } else {
            LocalLock lock = new LocalLock(object);
            lock.unlock();
            file = service.getTempFile(object);
        }
        if (file.isPresent()) {
            Program.launch((String)((File)file.get()).getAbsolutePath());
        } else {
            MessageDialog.openError((Shell)parentShell, (String)Messages.Core_Error, (String)Messages.Core_Document_Not_Opened_Locally);
        }
    }
}

