/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

public class BinConverter {
    static final char[] HEXTAB = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final int byteArrayToInt(byte[] buf, int nOfs) {
        return buf[nOfs] << 24 | (buf[nOfs + 1] & 0xFF) << 16 | (buf[nOfs + 2] & 0xFF) << 8 | buf[nOfs + 3] & 0xFF;
    }

    public static final void intToByteArray(int nValue, byte[] buf, int nOfs) {
        buf[nOfs] = (byte)(nValue >>> 24 & 0xFF);
        buf[nOfs + 1] = (byte)(nValue >>> 16 & 0xFF);
        buf[nOfs + 2] = (byte)(nValue >>> 8 & 0xFF);
        buf[nOfs + 3] = (byte)nValue;
    }

    public static final long byteArrayToLong(byte[] buf, int nOfs) {
        return (long)(buf[nOfs] << 24 | (buf[nOfs + 1] & 0xFF) << 16 | (buf[nOfs + 2] & 0xFF) << 8 | buf[nOfs + 3] & 0xFF) << 32 | (long)(buf[nOfs + 4] << 24 | (buf[nOfs + 5] & 0xFF) << 16 | (buf[nOfs + 6] & 0xFF) << 8 | buf[nOfs + 7] & 0xFF) & 0xFFFFFFFFL;
    }

    public static final void longToByteArray(long lValue, byte[] buf, int nOfs) {
        int nTmp = (int)(lValue >>> 32);
        buf[nOfs] = (byte)(nTmp >>> 24);
        buf[nOfs + 1] = (byte)(nTmp >>> 16 & 0xFF);
        buf[nOfs + 2] = (byte)(nTmp >>> 8 & 0xFF);
        buf[nOfs + 3] = (byte)nTmp;
        nTmp = (int)lValue;
        buf[nOfs + 4] = (byte)(nTmp >>> 24);
        buf[nOfs + 5] = (byte)(nTmp >>> 16 & 0xFF);
        buf[nOfs + 6] = (byte)(nTmp >>> 8 & 0xFF);
        buf[nOfs + 7] = (byte)nTmp;
    }

    public static final long intArrayToLong(int[] buf, int nOfs) {
        return (long)buf[nOfs] << 32 | (long)buf[nOfs + 1] & 0xFFFFFFFFL;
    }

    public static final void longToIntArray(long lValue, int[] buf, int nOfs) {
        buf[nOfs] = (int)(lValue >>> 32);
        buf[nOfs + 1] = (int)lValue;
    }

    public static final long makeLong(int nLo, int nHi) {
        return (long)nHi << 32 | (long)nLo & 0xFFFFFFFFL;
    }

    public static final int longLo32(long lVal) {
        return (int)lVal;
    }

    public static final int longHi32(long lVal) {
        return (int)(lVal >>> 32);
    }

    public static final String bytesToHexStr(byte[] data) {
        return BinConverter.bytesToHexStr(data, 0, data.length);
    }

    public static final String bytesToHexStr(byte[] data, int nOfs, int nLen) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.setLength(nLen << 1);
        int nPos = 0;
        int nC = nOfs + nLen;
        while (nOfs < nC) {
            sbuf.setCharAt(nPos++, HEXTAB[data[nOfs] >> 4 & 0xF]);
            sbuf.setCharAt(nPos++, HEXTAB[data[nOfs++] & 0xF]);
        }
        return sbuf.toString();
    }

    public static final int hexStrToBytes(String sHex, byte[] data, int nSrcOfs, int nDstOfs, int nLen) {
        int nOutputCapacity;
        int nStrLen = sHex.length();
        int nAvailBytes = nStrLen - nSrcOfs >> 1;
        if (nAvailBytes < nLen) {
            nLen = nAvailBytes;
        }
        if (nLen > (nOutputCapacity = data.length - nDstOfs)) {
            nLen = nOutputCapacity;
        }
        int nDstOfsBak = nDstOfs;
        int nI = 0;
        while (nI < nLen) {
            int bActByte = 0;
            boolean blConvertOK = true;
            int nJ = 0;
            while (nJ < 2) {
                char cActChar;
                bActByte = (byte)(bActByte << 4);
                if ((cActChar = sHex.charAt(nSrcOfs++)) >= 'a' && cActChar <= 'f') {
                    bActByte = (byte)(bActByte | (byte)(cActChar - 97) + 10);
                } else if (cActChar >= '0' && cActChar <= '9') {
                    bActByte = (byte)(bActByte | (byte)(cActChar - 48));
                } else {
                    blConvertOK = false;
                }
                ++nJ;
            }
            if (blConvertOK) {
                data[nDstOfs++] = bActByte;
            }
            ++nI;
        }
        return nDstOfs - nDstOfsBak;
    }

    public static final String byteArrayToStr(byte[] data, int nOfs, int nLen) {
        int nAvailCapacity = data.length - nOfs;
        if (nAvailCapacity < (nLen &= 0xFFFFFFFE)) {
            nLen = nAvailCapacity;
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.setLength(nLen >> 1);
        int nSBufPos = 0;
        while (nLen > 0) {
            sbuf.setCharAt(nSBufPos++, (char)(data[nOfs] << 8 | data[nOfs + 1] & 0xFF));
            nOfs += 2;
            nLen -= 2;
        }
        return sbuf.toString();
    }
}

