/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.compress;

import ch.rgw.compress.GLZ;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class GLZOutputStream
extends OutputStream {
    private ByteArrayOutputStream intermediate;
    private OutputStream dest;

    public GLZOutputStream(OutputStream oo, int sizeHint) {
        this.intermediate = new ByteArrayOutputStream(sizeHint);
        this.dest = oo;
    }

    public GLZOutputStream(OutputStream oo) {
        this.intermediate = new ByteArrayOutputStream();
        this.dest = oo;
    }

    @Override
    public void write(byte[] arg0) throws IOException {
        this.intermediate.write(arg0);
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) throws IOException {
        this.intermediate.write(arg0, arg1, arg2);
    }

    @Override
    public void write(int arg0) throws IOException {
        this.intermediate.write(arg0);
    }

    @Override
    public void close() throws IOException {
        this.intermediate.close();
        byte[] d = this.intermediate.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(d);
        GLZ glz = new GLZ();
        glz.compress(bais, this.dest);
        this.dest.close();
    }
}

