/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.mediorder;

import ch.elexis.core.mediorder.MediorderEntryState;
import ch.elexis.core.mediorder.MediorderUtil;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.services.ICoverageService;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class MediorderCanExecuteUtil {
    public static boolean canExecute(List<IStockEntry> stockEntries, ICoverageService coverageService) {
        boolean hasInStock = stockEntries.stream().anyMatch(e -> MediorderUtil.determineState((IStockEntry)e).equals((Object)MediorderEntryState.IN_STOCK));
        if (!hasInStock) {
            return false;
        }
        Optional coverage = coverageService.getLatestOpenCoverage(stockEntries.get(0).getStock().getOwner().asIPatient());
        if (coverage.isEmpty()) {
            return false;
        }
        Optional encounter = coverageService.getLatestEncounter((ICoverage)coverage.get());
        if (encounter.isEmpty()) {
            return false;
        }
        Set billedIds = ((IEncounter)encounter.get()).getBilled().stream().map(billed -> billed.getBillable().getId()).collect(Collectors.toSet());
        return stockEntries.stream().allMatch(e -> billedIds.contains(e.getArticle().getId()));
    }
}

