/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.handlers;

import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.core.ui.util.CreatePrescriptionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class DispenseHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional patient = ContextServiceHolder.get().getActivePatient();
        if (!patient.isPresent()) {
            return null;
        }
        ArrayList<IPrescription> prescRecipes = new ArrayList<IPrescription>();
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (!selection.isEmpty()) {
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            List mtvItems = strucSelection.toList();
            for (MedicationTableViewerItem mtvItem : mtvItems) {
                IPrescription p = mtvItem.getPrescription();
                if (p == null) continue;
                prescRecipes.add(p);
            }
        }
        for (IPrescription prescription : prescRecipes) {
            CreatePrescriptionHelper prescriptionHelper = new CreatePrescriptionHelper(null, HandlerUtil.getActiveShell((ExecutionEvent)event));
            prescriptionHelper.selfDispense(prescription, true);
        }
        ContextServiceHolder.get().getTyped(IEncounter.class).ifPresent(enc -> ContextServiceHolder.get().postEvent("info/elexis/model/update", enc));
        return null;
    }
}

