/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.dialogs;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.ILabItem;
import ch.elexis.core.data.interfaces.ILabOrder;
import ch.elexis.core.model.IOutputLog;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.laboratory.controls.LabItemTreeSelectionComposite;
import ch.elexis.core.ui.laboratory.dialogs.Messages;
import ch.elexis.core.ui.laboratory.views.LabOrderView;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.data.Anwender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabOrder;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Reminder;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class LaborVerordnungDialog
extends TitleAreaDialog {
    private static final String LAST_SELECTED_USER = "laborlink/last_selected_user";
    private static final String PREV_PRINT_SETTING = "laborlink/prev_print_setting";
    public static final String OUTPUTLOG_EXTERNES_LABOR = "Externes Labor";
    private Patient patient = null;
    private TimeTool date = null;
    private LabItemTreeSelectionComposite selectionComposite;
    private ComboViewer userViewer = null;
    private DateTime observationTime;
    private DateTime observationDate;
    private Text orderId;
    private Button btnPrint;
    private Button btnExternLabor;

    public LaborVerordnungDialog(Shell parentShell, Patient patient, TimeTool date) {
        super(parentShell);
        this.patient = patient;
        this.date = date;
    }

    private void selectLastSelectedUser() {
        String id = ConfigServiceHolder.getUser((String)LAST_SELECTED_USER, (String)"");
        Anwender user = Anwender.load((String)id);
        if (user != null && user.exists()) {
            StructuredSelection newSelection = new StructuredSelection((Object)user);
            this.userViewer.setSelection((ISelection)newSelection);
        }
    }

    private void saveLastSelectedUser() {
        Anwender user = this.getSelectedUser();
        String id = "";
        if (user != null) {
            id = user.getId();
        }
        ConfigServiceHolder.setUser((String)LAST_SELECTED_USER, (String)id);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.selectionComposite = new LabItemTreeSelectionComposite(composite, (ILabelProvider)new LabItemsLabelProvider(), true, 0);
        this.selectionComposite.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LaborVerordnungDialog.this.updateSelectionMessage();
            }
        });
        this.selectionComposite.setLayoutData(new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(Messages.LaborVerordnungDialog_labelResponsible);
        this.userViewer = new ComboViewer(composite, 2828);
        this.userViewer.getControl().setLayoutData((Object)new GridData(768));
        this.userViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.userViewer.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider());
        Query query = new Query(Anwender.class);
        List users = query.execute();
        users.set(0, new NoAnwender());
        this.userViewer.setInput((Object)users);
        this.selectLastSelectedUser();
        this.btnExternLabor = new Button(composite, 32);
        this.btnExternLabor.setText(Messages.LaborVerordnungDialog_externesLaborCheckbox);
        this.btnExternLabor.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label = new Label(composite, 0);
        label.setText(Messages.LaborOrdersComposite_columnObservationTime);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        Composite dateComposite = new Composite(composite, 0);
        dateComposite.setLayout((Layout)new GridLayout(2, true));
        dateComposite.setLayoutData((Object)new GridData(768));
        this.observationTime = new DateTime(dateComposite, 128);
        this.observationTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.observationDate = new DateTime(dateComposite, 32);
        this.observationDate.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.observationTime.setTime(this.date.get(11), this.date.get(12), this.date.get(13));
        this.observationDate.setDate(this.date.get(1), this.date.get(2), this.date.get(5));
        label = new Label(composite, 0);
        label.setText(Messages.LaborVerordnungDialog_labelOrderNumber);
        this.orderId = new Text(composite, 128);
        this.orderId.setLayoutData((Object)new GridData(768));
        this.orderId.setText(LabOrder.getNextOrderId());
        this.orderId.setEnabled(false);
        Label lblSeparator = new Label(composite, 258);
        lblSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnPrint = new Button(composite, 32);
        this.btnPrint.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnPrint.setText(Messages.LaborVerordnungDialog_printOrders);
        this.btnPrint.setSelection(ConfigServiceHolder.getUser((String)PREV_PRINT_SETTING, (boolean)false));
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    private void updateSelectionMessage() {
        List<LabItemTreeSelectionComposite.GroupItem> selected = this.selectionComposite.getSelectedItems();
        StringBuilder sb = new StringBuilder();
        for (LabItemTreeSelectionComposite.GroupItem groupItem : selected) {
            sb.append(groupItem.getGroupname() + " - " + groupItem.getLabItem().getKuerzel());
            sb.append(", ");
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        this.setMessage(sb.toString(), 1);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(Messages.Core_prescribe_Laboratory);
        this.setMessage(Messages.LaborVerordnungDialog_message + " verantwortliche Person aus. (Der verantwortlichen Person wird eine Pendenz zugeordnet.)");
        this.getShell().setText(Messages.Core_prescribe_Laboratory);
        return contents;
    }

    private List<LabOrder> createLabOrders(List<LabItemTreeSelectionComposite.GroupItem> items) {
        ArrayList<LabOrder> ret = new ArrayList<LabOrder>();
        this.getTime(this.observationTime, this.date);
        this.getDate(this.observationDate, this.date);
        TimeTool now = new TimeTool();
        if (items != null) {
            for (LabItemTreeSelectionComposite.GroupItem groupItem : items) {
                LabOrder order = new LabOrder(CoreHub.getLoggedInContact().getId(), ContextServiceHolder.getActiveMandatorOrNull().getId(), this.patient.getId(), (ILabItem)groupItem.getLabItem(), null, this.orderId.getText(), groupItem.getGroupname(), now);
                order.setObservationTimeWithResults(this.date);
                ret.add(order);
            }
        }
        return ret;
    }

    private void getTime(DateTime widget, TimeTool time) {
        time.set(11, widget.getHours());
        time.set(12, widget.getMinutes());
        time.set(13, widget.getSeconds());
    }

    private void getDate(DateTime widget, TimeTool date) {
        date.set(1, widget.getYear());
        date.set(2, widget.getMonth());
        date.set(5, widget.getDay());
    }

    private void createReminder(Anwender user, List<LabOrder> orders) {
        StringBuilder message = new StringBuilder("Labor");
        StringBuilder params = new StringBuilder();
        if (orders != null && !orders.isEmpty()) {
            message.append(" ").append(ch.elexis.core.ui.laboratory.controls.Messages.Order_ID).append(": ").append(orders.get(0).get("orderid"));
            params.append("orderid=" + orders.get(0).get("orderid"));
        }
        Reminder reminder = new Reminder((Kontakt)this.patient, this.date.toString(6), Visibility.ALWAYS, params.toString(), message.toString());
        if (user != null) {
            reminder.set("Responsible", user.getId());
        }
    }

    private Anwender getSelectedUser() {
        Object sel = ((IStructuredSelection)this.userViewer.getSelection()).getFirstElement();
        if (sel instanceof Anwender && !(sel instanceof NoAnwender)) {
            return (Anwender)sel;
        }
        return null;
    }

    protected void okPressed() {
        List existing = LabOrder.getLabOrdersByOrderId((String)this.orderId.getText());
        if (existing != null) {
            String newOrderId = LabOrder.getNextOrderId();
            this.setErrorMessage(String.format(Messages.LaborVerordnungDialog_errorOrderNumber, this.orderId.getText(), newOrderId));
            this.orderId.setText(newOrderId);
            return;
        }
        final List<LabOrder> orders = this.createLabOrders(this.selectionComposite.getSelectedItems());
        ContextServiceHolder.get().postEvent("info/elexis/model/reload", ch.elexis.core.model.ILabOrder.class);
        if (this.getSelectedUser() != null) {
            this.createReminder(this.getSelectedUser(), orders);
        }
        for (ILabOrder iLabOrder : orders) {
            CoreModelServiceHolder.get().load(iLabOrder.getId(), ch.elexis.core.model.ILabOrder.class).ifPresent(laborder -> ContextServiceHolder.get().postEvent("info/elexis/model/update", laborder));
        }
        this.saveLastSelectedUser();
        boolean bl = this.btnPrint.getSelection();
        ConfigServiceHolder.setUser((String)PREV_PRINT_SETTING, (boolean)bl);
        if (this.btnExternLabor.getSelection()) {
            for (LabOrder order : orders) {
                this.logExternLaborToOutputLog(order);
            }
        }
        if (bl) {
            UiDesk.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Patient pat = ElexisEventDispatcher.getSelectedPatient();
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        LabOrderView labOrderView = (LabOrderView)page.showView("ch.elexis.core.ui.laboratory.LabOrderView");
                        labOrderView.createLabOrderPrint(pat, orders);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        super.okPressed();
    }

    private void logExternLaborToOutputLog(LabOrder order) {
        IOutputLog outputLog = (IOutputLog)CoreModelServiceHolder.get().create(IOutputLog.class);
        outputLog.setObjectId(order.getId());
        outputLog.setObjectType(order.getClass().getName());
        outputLog.setCreatorId(ContextServiceHolder.get().getActiveUser().map(user -> user.getId()).orElse("Unknown"));
        outputLog.setOutputter(((Object)((Object)this)).getClass().getName());
        outputLog.setDate(LocalDate.now());
        outputLog.setOutputterStatus(OUTPUTLOG_EXTERNES_LABOR);
        CoreModelServiceHolder.get().save((Identifiable)outputLog);
    }

    private class LabItemsLabelProvider
    extends LabelProvider {
        private HashMap<Object, String> cache = new HashMap();

        private LabItemsLabelProvider() {
        }

        public String getText(Object element) {
            Object label = this.cache.get(element);
            if (label == null) {
                if (element instanceof LabItemTreeSelectionComposite.Group) {
                    label = ((LabItemTreeSelectionComposite.Group)element).toString();
                    this.cache.put(element, (String)label);
                } else if (element instanceof LabItemTreeSelectionComposite.GroupItem) {
                    List orders = LabOrder.getLabOrders((Patient)LaborVerordnungDialog.this.patient, null, (ILabItem)((LabItemTreeSelectionComposite.GroupItem)element).getLabItem(), null, null, (TimeTool)LaborVerordnungDialog.this.date, null);
                    label = orders != null && !orders.isEmpty() ? Messages.LaborVerordnungDialog_alreadyOrdered + ((LabItemTreeSelectionComposite.GroupItem)element).getLabItem().getLabel() : ((LabItemTreeSelectionComposite.GroupItem)element).getLabItem().getLabel();
                    this.cache.put(element, (String)label);
                }
            }
            return label;
        }
    }

    private static class NoAnwender
    extends Anwender {
        private NoAnwender() {
        }

        public String getId() {
            return "";
        }

        public String getLabel() {
            return "";
        }

        public String getLabel(boolean shortLabel) {
            return this.getLabel();
        }
    }
}

