/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.ClassTypePair;
import org.glassfish.jersey.message.internal.HttpDateFormat;

@Singleton
public class ParamConverters {

    @Singleton
    public static class AggregatedProvider
    implements ParamConverterProvider {
        private final ParamConverterProvider[] providers;

        @Inject
        public AggregatedProvider(@Context InjectionManager manager, @Context Configuration configuration) {
            boolean canThrowNull = CommonProperties.getValue(configuration.getProperties(), "jersey.config.paramconverters.throw.iae", Boolean.FALSE) == false;
            this.providers = new ParamConverterProvider[]{new DateProvider(canThrowNull), new TypeFromStringEnum(canThrowNull), new TypeValueOf(canThrowNull), new CharacterProvider(canThrowNull), new InputStreamProvider(), new TypeFromString(canThrowNull), new StringConstructor(canThrowNull), new OptionalCustomProvider(manager, canThrowNull), new OptionalProvider()};
        }

        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            for (ParamConverterProvider p : this.providers) {
                ParamConverter reader = p.getConverter(rawType, genericType, annotations);
                if (reader == null) continue;
                return reader;
            }
            return null;
        }
    }

    @Singleton
    public static class OptionalProvider
    implements ParamConverterProvider {
        protected OptionalProvider() {
        }

        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            final Optionals optionals = Optionals.getOptional(rawType);
            return optionals == null ? null : new ParamConverter<T>(){

                public T fromString(String value) {
                    if (value == null || value.isEmpty()) {
                        return optionals.empty();
                    }
                    return optionals.of(value);
                }

                public String toString(T value) throws IllegalArgumentException {
                    return null;
                }
            };
        }

        private static enum Optionals {
            OPTIONAL_INT((Class)OptionalInt.class){

                @Override
                Object empty() {
                    return OptionalInt.empty();
                }

                @Override
                Object of(Object value) {
                    return OptionalInt.of(Integer.parseInt((String)value));
                }
            }
            ,
            OPTIONAL_DOUBLE((Class)OptionalDouble.class){

                @Override
                Object empty() {
                    return OptionalDouble.empty();
                }

                @Override
                Object of(Object value) {
                    return OptionalDouble.of(Double.parseDouble((String)value));
                }
            }
            ,
            OPTIONAL_LONG((Class)OptionalLong.class){

                @Override
                Object empty() {
                    return OptionalLong.empty();
                }

                @Override
                Object of(Object value) {
                    return OptionalLong.of(Long.parseLong((String)value));
                }
            };

            private final Class<?> clazz;

            private Optionals(Class<?> clazz) {
                this.clazz = clazz;
            }

            private static Optionals getOptional(Class<?> clazz) {
                for (Optionals optionals : Optionals.values()) {
                    if (optionals.clazz != clazz) continue;
                    return optionals;
                }
                return null;
            }

            abstract Object empty();

            abstract Object of(Object var1);
        }
    }

    @Singleton
    public static class OptionalCustomProvider
    extends ParamConverterCompliance
    implements ParamConverterProvider {
        private final InjectionManager manager;

        protected OptionalCustomProvider(InjectionManager manager, boolean canReturnNull) {
            super(canReturnNull);
            this.manager = manager;
        }

        public <T> ParamConverter<T> getConverter(Class<T> rawType, final Type genericType, final Annotation[] annotations) {
            return rawType != Optional.class ? null : new ParamConverter<T>(){
                final /* synthetic */ OptionalCustomProvider this$0;
                {
                    this.this$0 = this$0;
                }

                public T fromString(String value) {
                    if (value == null) {
                        return Optional.empty();
                    }
                    List<ClassTypePair> ctps = ReflectionHelper.getTypeArgumentAndClass(genericType);
                    ClassTypePair ctp = ctps.size() == 1 ? ctps.get(0) : null;
                    boolean empty = value.isEmpty();
                    for (ParamConverterProvider provider : Providers.getProviders(this.this$0.manager, ParamConverterProvider.class)) {
                        ParamConverter converter = provider.getConverter(ctp.rawClass(), ctp.type(), annotations);
                        if (converter == null) continue;
                        if (empty) {
                            return Optional.empty();
                        }
                        return Optional.of(value).map(s -> converter.fromString(value));
                    }
                    return this.this$0.nullOrThrow();
                }

                public String toString(T value) throws IllegalArgumentException {
                    return null;
                }
            };
        }
    }

    public static class InputStreamProvider
    implements ParamConverterProvider {
        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            return rawType != InputStream.class ? null : new ParamConverter<T>(){

                public T fromString(String value) {
                    if (value == null) {
                        throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
                    }
                    return rawType.cast(new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8)));
                }

                public String toString(T value) {
                    if (value == null) {
                        throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
                    }
                    try {
                        return new String(((InputStream)value).readAllBytes());
                    }
                    catch (IOException ioe) {
                        throw new ExtractorException(ioe);
                    }
                }
            };
        }
    }

    @Singleton
    public static class DateProvider
    extends ParamConverterCompliance
    implements ParamConverterProvider {
        protected DateProvider(boolean canReturnNull) {
            super(canReturnNull);
        }

        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            return rawType != Date.class ? null : new ParamConverter<T>(){
                final /* synthetic */ DateProvider this$0;
                {
                    this.this$0 = this$0;
                }

                public T fromString(String value) {
                    if (value == null) {
                        return this.this$0.nullOrThrow();
                    }
                    try {
                        return rawType.cast(HttpDateFormat.readDate(value));
                    }
                    catch (ParseException ex) {
                        throw new ExtractorException(ex);
                    }
                }

                public String toString(T value) throws IllegalArgumentException {
                    if (value == null) {
                        return (String)this.this$0.nullOrThrow();
                    }
                    return value.toString();
                }
            };
        }
    }

    @Singleton
    public static class CharacterProvider
    extends ParamConverterCompliance
    implements ParamConverterProvider {
        protected CharacterProvider(boolean canReturnNull) {
            super(canReturnNull);
        }

        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            if (rawType.equals(Character.class)) {
                return new ParamConverter<T>(){
                    final /* synthetic */ CharacterProvider this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public T fromString(String value) {
                        if (value == null || value.isEmpty()) {
                            return this.this$0.nullOrThrow();
                        }
                        if (value.length() == 1) {
                            return rawType.cast(Character.valueOf(value.charAt(0)));
                        }
                        throw new ExtractorException(LocalizationMessages.ERROR_PARAMETER_INVALID_CHAR_VALUE(value));
                    }

                    public String toString(T value) {
                        if (value == null) {
                            return (String)this.this$0.nullOrThrow();
                        }
                        return value.toString();
                    }
                };
            }
            return null;
        }
    }

    @Singleton
    public static class TypeFromStringEnum
    extends TypeFromString {
        protected TypeFromStringEnum(boolean canReturnNull) {
            super(canReturnNull);
        }

        @Override
        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            return !Enum.class.isAssignableFrom(rawType) ? null : super.getConverter(rawType, genericType, annotations);
        }
    }

    @Singleton
    public static class TypeFromString
    extends ParamConverterCompliance
    implements ParamConverterProvider {
        protected TypeFromString(boolean canReturnNull) {
            super(canReturnNull);
        }

        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            final Method fromStringMethod = AccessController.doPrivileged(ReflectionHelper.getFromStringStringMethodPA(rawType));
            return fromStringMethod == null ? null : new AbstractStringReader<T>(this, this.canReturnNull){

                @Override
                public T _fromString(String value) throws Exception {
                    return rawType.cast(fromStringMethod.invoke(null, value));
                }
            };
        }
    }

    @Singleton
    public static class TypeValueOf
    extends ParamConverterCompliance
    implements ParamConverterProvider {
        protected TypeValueOf(boolean canReturnNull) {
            super(canReturnNull);
        }

        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            final Method valueOf = AccessController.doPrivileged(ReflectionHelper.getValueOfStringMethodPA(rawType));
            return valueOf == null ? null : new AbstractStringReader<T>(this, this.canReturnNull){

                @Override
                public T _fromString(String value) throws Exception {
                    return rawType.cast(valueOf.invoke(null, value));
                }
            };
        }
    }

    @Singleton
    public static class StringConstructor
    extends ParamConverterCompliance
    implements ParamConverterProvider {
        protected StringConstructor(boolean canReturnNull) {
            super(canReturnNull);
        }

        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            final Constructor constructor = AccessController.doPrivileged(ReflectionHelper.getStringConstructorPA(rawType));
            return constructor == null ? null : new AbstractStringReader<T>(this, this.canReturnNull){

                @Override
                protected T _fromString(String value) throws Exception {
                    return rawType.cast(constructor.newInstance(value));
                }
            };
        }
    }

    private static abstract class AbstractStringReader<T>
    extends ParamConverterCompliance
    implements ParamConverter<T> {
        private AbstractStringReader(boolean canReturnNull) {
            super(canReturnNull);
        }

        public T fromString(String value) {
            if (value == null) {
                return this.nullOrThrow();
            }
            try {
                return this._fromString(value);
            }
            catch (InvocationTargetException ex) {
                if (value.isEmpty()) {
                    return null;
                }
                Throwable cause = ex.getCause();
                if (cause instanceof WebApplicationException) {
                    throw (WebApplicationException)cause;
                }
                throw new ExtractorException(cause);
            }
            catch (Exception ex) {
                throw new ProcessingException((Throwable)ex);
            }
        }

        protected abstract T _fromString(String var1) throws Exception;

        public String toString(T value) throws IllegalArgumentException {
            if (value == null) {
                return (String)this.nullOrThrow();
            }
            return value.toString();
        }
    }

    private static class ParamConverterCompliance {
        protected final boolean canReturnNull;

        private ParamConverterCompliance(boolean canReturnNull) {
            this.canReturnNull = canReturnNull;
        }

        protected <T> T nullOrThrow() {
            if (this.canReturnNull) {
                return null;
            }
            throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
        }
    }
}

