/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.data.Rechnung;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RnOutputDialog
extends TitleAreaDialog {
    private final Collection<Rechnung> rnn;
    private List<IRnOutputter> lo;
    private Combo cbLo;
    private Button bCopy;
    private final List<Control> ctls = new ArrayList<Control>();
    private final StackLayout stack = new StackLayout();
    private Composite additionalButtonParent;

    public RnOutputDialog(Shell shell, Collection<Rechnung> rnn) {
        super(shell);
        this.rnn = rnn;
    }

    protected Control createDialogArea(Composite parent) {
        this.lo = Extensions.getClasses((String)"ch.elexis.core.data.RechnungsManager", (String)"outputter");
        if (this.lo.isEmpty()) {
            String msg2 = "Elexis has no textplugin configured for outputting bills!";
            SWTHelper.alert(msg2, msg2);
            return null;
        }
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.cbLo = new Combo(ret, 12);
        this.cbLo.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.bCopy = new Button(ret, 32);
        this.bCopy.setText(Messages.RnOutputDialog_markAsCopy);
        this.bCopy.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        final Composite bottom = new Composite(ret, 0);
        bottom.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        bottom.setLayout((Layout)this.stack);
        for (IRnOutputter ro : this.lo) {
            this.cbLo.add(ro.getDescription());
            this.ctls.add((Control)ro.createSettingsControl((Object)bottom));
        }
        this.cbLo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = RnOutputDialog.this.cbLo.getSelectionIndex();
                if (idx != -1) {
                    RnOutputDialog.this.customizeDialog(RnOutputDialog.this.lo.get(idx));
                    RnOutputDialog.this.stack.topControl = RnOutputDialog.this.ctls.get(idx);
                    bottom.layout();
                    CoreHub.localCfg.set("rechnung/default_target", idx);
                }
            }
        });
        int lastSelected = CoreHub.localCfg.get("rechnung/default_target", 0);
        if (lastSelected < 0 || lastSelected >= this.cbLo.getItemCount()) {
            lastSelected = 0;
            CoreHub.localCfg.set("rechnung/default_target", 0);
        }
        this.cbLo.select(lastSelected);
        this.stack.topControl = this.ctls.get(this.cbLo.getSelectionIndex());
        bottom.layout();
        return ret;
    }

    protected Control createContents(Composite parent) {
        Control ret = super.createContents(parent);
        this.customizeDialog(this.lo.get(this.cbLo.getSelectionIndex()));
        return ret;
    }

    private void customizeDialog(IRnOutputter rnOutputter) {
        this.resetCustomButtons();
        this.resetDialog();
        rnOutputter.customizeDialog((Object)this);
    }

    private void resetDialog() {
        this.resetOkButtonText();
        this.resetCancelButtonText();
    }

    public void setOkButtonText(String text) {
        Button button = this.getButton(0);
        button.setText(text);
        button.getParent().layout();
    }

    public void resetOkButtonText() {
        this.setOkButtonText(IDialogConstants.OK_LABEL);
    }

    public void setCancelButtonText(String text) {
        Button button = this.getButton(1);
        button.setText(text);
        button.getParent().layout();
    }

    public void resetCancelButtonText() {
        this.setCancelButtonText(IDialogConstants.CANCEL_LABEL);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (parent.getLayout() instanceof GridLayout) {
            ++((GridLayout)parent.getLayout()).numColumns;
            this.additionalButtonParent = new Composite(parent, 0);
            this.additionalButtonParent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.additionalButtonParent.setLayout((Layout)new RowLayout());
        }
        super.createButtonsForButtonBar(parent);
    }

    public Button addCustomButton(String text) {
        Button ret = new Button(this.additionalButtonParent, 8);
        ret.setText(text);
        this.additionalButtonParent.getParent().requestLayout();
        return ret;
    }

    public void resetCustomButtons() {
        Control[] controlArray = this.additionalButtonParent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Button) {
                control.setVisible(false);
                control.dispose();
            }
            ++n2;
        }
        this.additionalButtonParent.getParent().requestLayout();
    }

    public void customButtonPressed(int buttonId) {
        this.buttonPressed(buttonId);
    }

    public void create() {
        super.create();
        int num = this.rnn.size();
        if (num > 1) {
            this.getShell().setText(Messages.RnOutputDialog_outputCaption);
            this.setTitle(String.valueOf(num) + Messages.RnOutputDialog_outputTitle);
            this.setMessage(MessageFormat.format(Messages.RnOutputDialog_outputMessage, num));
        } else {
            this.getShell().setText(Messages.RnOutputDialog_outputBillCaption);
            this.setTitle(Messages.RnOutputDialog_outputBillTitle);
            this.setMessage(Messages.RnOutputDialog_outputBillMessage);
        }
        this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
    }

    protected void okPressed() {
        int idx;
        boolean activated = ConfigServiceHolder.getUser((String)"reminder/showPatientChangeReminder", (boolean)false);
        if (activated) {
            ConfigServiceHolder.setUser((String)"reminder/showPatientChangeReminder", (boolean)false);
        }
        if ((idx = this.cbLo.getSelectionIndex()) != -1) {
            IRnOutputter rnOutputter = this.lo.get(idx);
            rnOutputter.saveComposite();
            Iterator<Rechnung> it = this.rnn.iterator();
            boolean bFlag = false;
            while (it.hasNext()) {
                Rechnung r = it.next();
                if (r.getStatus() != InvoiceState.CANCELLED.numericValue()) continue;
                it.remove();
                bFlag = true;
            }
            if (bFlag) {
                SWTHelper.alert("Stornierte Rechnungen in Liste", "Stornierte Rechnungen werden nicht ausgegeben.");
            }
            rnOutputter.doOutput(this.bCopy.getSelection() ? IRnOutputter.TYPE.COPY : IRnOutputter.TYPE.ORIG, this.rnn, new Properties());
        }
        if (activated) {
            ConfigServiceHolder.setUser((String)"reminder/showPatientChangeReminder", (boolean)true);
        }
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

