/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.controls;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.data.Interaction;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InteractionLink {
    private Link interactionLink = null;
    static Logger logger = LoggerFactory.getLogger(InteractionLink.class);
    private String destUrl = "";
    private static int lastUpTime;

    public InteractionLink(Composite parent, int style) {
        this.interactionLink = new Link(parent, style);
        if (ConfigServiceHolder.getUser((String)"anwender/suppressintractioncheck", (boolean)true)) {
            this.setSuppressed();
        } else {
            this.updateAtcs(new ArrayList<IArticle>());
        }
    }

    private void setSuppressed() {
        this.interactionLink.setText("");
        this.interactionLink.setToolTipText(Messages.SuppressInteractionCheckTooltip);
        this.interactionLink.setForeground(UiDesk.getColorRegistry().get("schwarz"));
    }

    public String updateAtcs(List<IArticle> gtins) {
        this.interactionLink.setText("");
        if (ConfigServiceHolder.getUser((String)"anwender/suppressintractioncheck", (boolean)true)) {
            this.setSuppressed();
            return "";
        }
        String severity = " ";
        Color color = UiDesk.getColor("weiss");
        String epha = Messages.VerrDetailDialog_InteractionEpha;
        String tooltip = "";
        StringBuilder buildUrl = new StringBuilder(Messages.VerrDetailDialog_InteractionBaseURL);
        ArrayList atcs = new ArrayList();
        gtins.forEach(art -> {
            String atc = art.getAtcCode();
            buildUrl.append(art.getGtin());
            buildUrl.append(",");
            if (atc != null && atc.length() >= 0) {
                atcs.add(art.getAtcCode());
            }
        });
        if (atcs.size() > 1) {
            this.destUrl = buildUrl.toString().replaceAll(",+$", "");
            logger.info("For {} ATCs {} set destUrl to {}", new Object[]{atcs.size(), atcs, this.destUrl});
        } else {
            this.destUrl = "";
        }
        this.interactionLink.setText(Messages.VerrDetailDialog_NoInteractionKnown);
        this.interactionLink.setBackground(color);
        this.interactionLink.setVisible(true);
        this.interactionLink.setEnabled(true);
        this.interactionLink.setToolTipText(tooltip);
        this.interactionLink.setTouchEnabled(true);
        this.interactionLink.setForeground(UiDesk.getColorRegistry().get("blau"));
        if (atcs.size() > 1) {
            int j = 0;
            while (j < atcs.size()) {
                int k = j + 1;
                while (k < atcs.size()) {
                    Interaction ia = Interaction.getByATC((String)atcs.get(j), (String)atcs.get(k));
                    if (ia == null) {
                        ia = Interaction.getByATC((String)atcs.get(k), (String)atcs.get(j));
                    }
                    if (ia != null) {
                        String rating = ia.get("SEVERITY");
                        logger.trace("Add: {} {} res {}", new Object[]{rating, severity, rating.compareTo(severity)});
                        if (severity.compareTo(rating) < 0) {
                            severity = rating;
                            String info = ia.get("INFO");
                            tooltip = String.format("%s\n%s\n%s\n%s", Interaction.Ratings.get(severity), info, this.destUrl, Messages.VerrDetailDialog_InteractionTooltip);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            this.interactionLink.setToolTipText(tooltip);
            this.interactionLink.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        if (event.time == lastUpTime) {
                            logger.info("{} Skipping: {}", (Object)event.toString(), (Object)InteractionLink.this.destUrl);
                            return;
                        }
                        lastUpTime = event.time;
                        logger.info("{} destURL for external browser is: {}", (Object)event.toString(), (Object)InteractionLink.this.destUrl);
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(InteractionLink.this.destUrl));
                    }
                    catch (MalformedURLException | PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
            if (!severity.contentEquals(" ")) {
                color = UiDesk.getColorFromRGB(Interaction.Colors.get(severity));
                this.interactionLink.setText(String.valueOf(epha) + ": " + Interaction.Ratings.get(severity));
                this.interactionLink.setBackground(color);
            }
        }
        return this.destUrl;
    }

    public void setLayoutData(GridData gridData) {
        this.interactionLink.setLayoutData((Object)gridData);
    }
}

