/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.LockRequestingAction;
import ch.elexis.core.ui.services.LocalDocumentServiceHolder;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.TextView;
import ch.elexis.data.Brief;
import ch.elexis.data.Patient;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.LoggerFactory;

public class BriefAuswahl
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.BriefAuswahlView";
    private final FormToolkit tk;
    private Form form;
    private Action briefNeuAction;
    private Action briefLadenAction;
    private Action editNameAction;
    private Action startLocalEditAction;
    private Action endLocalEditAction;
    private Action cancelLocalEditAction;
    private Action deleteAction;
    private ViewMenus menus;
    private ArrayList<sPage> pages = new ArrayList();
    CTabFolder ctab;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);

    @Inject
    void activePatient(@Optional IPatient patient) {
        ContextServiceHolder.get().getRootContext().removeTyped(IDocumentLetter.class);
        Display.getDefault().asyncExec(() -> {
            if (this.form != null && !this.form.isDisposed()) {
                if (patient == null) {
                    this.form.setText(Messages.BriefAuswahlNoPatientSelected);
                } else {
                    this.form.setText(patient.getLabel());
                }
            }
            this.refresh();
        });
    }

    @Inject
    @Optional
    public void reload(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (IDocumentLetter.class.equals(clazz)) {
            this.relabel();
        }
    }

    @Override
    public void refresh() {
        Display.getDefault().asyncExec(() -> this.refreshSelectedViewer());
    }

    public void refreshSelectedViewer() {
        CTabItem sel;
        if (CoreUiUtil.isActiveControl((Control)this.ctab) && (sel = this.ctab.getSelection()) != null) {
            CommonViewer cv = (CommonViewer)sel.getData();
            cv.notify(CommonViewer.Message.update);
        }
    }

    public void refreshCV(CommonViewer.Message updateKeeplabels) {
        CTabItem sel;
        if (this.ctab != null && CoreUiUtil.isActiveControl((Control)this.ctab) && (sel = this.ctab.getSelection()) != null) {
            CommonViewer cv = (CommonViewer)sel.getData();
            cv.notify(updateKeeplabels);
        }
    }

    public BriefAuswahl() {
        this.tk = UiDesk.getToolkit();
    }

    public void createPartControl(Composite parent) {
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.BriefAuswahlAllLetters).append("Allg.").append(",").append("AUF-Zeugnis").append(",").append("Rezept").append(",").append("Labor");
        String cats = ConfigServiceHolder.getGlobal((String)"dokumente/kategorien", (String)sb.toString());
        parent.setLayout((Layout)new GridLayout());
        this.form = this.tk.createForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.form.setBackground(parent.getBackground());
        GridLayout slimLayout = new GridLayout();
        slimLayout.marginHeight = 0;
        slimLayout.marginWidth = 0;
        Composite body = this.form.getBody();
        body.setLayout((Layout)slimLayout);
        body.setBackground(parent.getBackground());
        this.ctab = new CTabFolder(body, 1024);
        this.ctab.setLayout((Layout)slimLayout);
        this.ctab.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.ctab.setBackground(parent.getBackground());
        this.makeActions();
        this.menus = new ViewMenus(this.getViewSite());
        String[] stringArray = cats.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cat = stringArray[n2];
            CTabItem ct = new CTabItem(this.ctab, 0);
            ct.setText(cat);
            sPage page = new sPage((Composite)this.ctab, cat);
            this.pages.add(page);
            if (CoreHub.localCfg.get("briefe/Textmodul_Edit_Local", false)) {
                this.menus.createViewerContextMenu(page.cv.getViewerWidget(), new IAction[]{this.editNameAction, this.deleteAction, this.startLocalEditAction, this.endLocalEditAction, this.cancelLocalEditAction});
            } else {
                this.menus.createViewerContextMenu(page.cv.getViewerWidget(), new IAction[]{this.editNameAction, this.deleteAction});
            }
            ct.setData((Object)page.cv);
            ct.setControl((Control)page);
            page.cv.getViewerWidget().addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    BriefAuswahl.this.briefLadenAction.run();
                }
            });
            ++n2;
        }
        this.ctab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BriefAuswahl.this.relabel();
            }
        });
        this.menus.createMenu(new IAction[]{this.briefNeuAction, this.briefLadenAction, this.editNameAction, this.deleteAction});
        this.menus.createToolbar(new IAction[]{this.briefNeuAction, this.briefLadenAction, this.deleteAction});
        this.ctab.setSelection(0);
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        for (sPage page : this.pages) {
            page.getCommonViewer().getConfigurer().getContentProvider().stopListening();
        }
    }

    public void setFocus() {
    }

    public void relabel() {
        UiDesk.asyncExec(new Runnable(){

            @Override
            public void run() {
                Patient pat = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
                if (BriefAuswahl.this.form != null && !BriefAuswahl.this.form.isDisposed()) {
                    if (pat == null) {
                        BriefAuswahl.this.form.setText(Messages.BriefAuswahlNoPatientSelected);
                    } else {
                        BriefAuswahl.this.form.setText(pat.getLabel());
                        CTabItem sel = BriefAuswahl.this.ctab.getSelection();
                        if (sel != null) {
                            CommonViewer cv = (CommonViewer)sel.getData();
                            cv.notify(CommonViewer.Message.update);
                        }
                    }
                }
            }
        });
    }

    private void makeActions() {
        this.briefNeuAction = new Action(Messages.BriefAuswahlNewButtonText){

            public void run() {
                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("ch.elexis.core.ui.commands.BriefNew", null);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(BriefAuswahl.class).error("cannot execute cmd", (Throwable)e);
                }
            }
        };
        this.briefLadenAction = new Action(Messages.BriefAuswahlOpenButtonText){

            public void run() {
                try {
                    TextView tv;
                    Brief brief = BriefAuswahl.this.getSelectedBrief();
                    if (brief != null) {
                        if (CoreHub.localCfg.get("briefe/Textmodul_Edit_Local", false)) {
                            BriefAuswahl.this.startLocalEditAction.run();
                        } else {
                            tv = (TextView)BriefAuswahl.this.getViewSite().getPage().showView("ch.elexis.TextView");
                            if (brief.getMimeType().equalsIgnoreCase("pdf")) {
                                try {
                                    File temp = File.createTempFile("letter_", ".pdf");
                                    temp.deleteOnExit();
                                    Throwable throwable = null;
                                    Object var5_8 = null;
                                    try (FileOutputStream fos = new FileOutputStream(temp);){
                                        fos.write(brief.loadBinary());
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                    Program.launch((String)temp.getAbsolutePath());
                                }
                                catch (IOException e) {
                                    ExHandler.handle((Throwable)e);
                                    SWTHelper.alert(Messages.BriefAuswahlErrorHeading, Messages.BriefAuswahlCouldNotLoadText);
                                }
                            } else if (!tv.openDocument(brief)) {
                                SWTHelper.alert(Messages.BriefAuswahlErrorHeading, Messages.BriefAuswahlCouldNotLoadText);
                            }
                        }
                    } else {
                        tv = (TextView)BriefAuswahl.this.getViewSite().getPage().showView("ch.elexis.TextView");
                        tv.createDocument(null, null);
                    }
                    CommonViewer cv = (CommonViewer)BriefAuswahl.this.ctab.getSelection().getData();
                    cv.notify(CommonViewer.Message.update);
                }
                catch (PartInitException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        };
        this.deleteAction = new LockRequestingAction<Brief>(Messages.BriefAuswahlDeleteButtonText){

            @Override
            public void doRun(Brief brief) {
                if (brief != null && SWTHelper.askYesNo(Messages.BriefAuswahlDeleteConfirmHeading, Messages.BriefAuswahlDeleteConfirmText)) {
                    brief.delete();
                    CTabItem sel = BriefAuswahl.this.ctab.getSelection();
                    CommonViewer cv = (CommonViewer)sel.getData();
                    cv.notify(CommonViewer.Message.update);
                }
            }

            @Override
            public Brief getTargetedObject() {
                return BriefAuswahl.this.getSelectedBrief();
            }
        };
        this.editNameAction = new LockRequestingAction<Brief>(Messages.BriefAuswahlRenameButtonText){

            @Override
            public void doRun(Brief brief) {
                if (brief != null) {
                    InputDialog id = new InputDialog(BriefAuswahl.this.getViewSite().getShell(), Messages.BriefAuswahlNewSubjectHeading, Messages.BriefAuswahlNewSubjectText, brief.getBetreff(), null);
                    if (id.open() == 0) {
                        brief.setBetreff(id.getValue());
                        CoreModelServiceHolder.get().load(brief.getId(), IDocumentLetter.class, false, true);
                    }
                    CTabItem sel = BriefAuswahl.this.ctab.getSelection();
                    CommonViewer cv = (CommonViewer)sel.getData();
                    cv.notify(CommonViewer.Message.update);
                }
            }

            @Override
            public Brief getTargetedObject() {
                return BriefAuswahl.this.getSelectedBrief();
            }
        };
        this.startLocalEditAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_EDIT.getImageDescriptor();
            }

            public String getText() {
                return Messages.BriefAuswahl_actionlocaledittext;
            }

            public void run() {
                IDocumentLetter brief = BriefAuswahl.this.getSelected();
                if (brief != null) {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command command = commandService.getCommand("ch.elexis.core.ui.command.startEditLocalDocument");
                    ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).set(command.getId().concat(".selection"), (Object)new StructuredSelection((Object)brief));
                    try {
                        command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)this, null));
                    }
                    catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                        MessageDialog.openError((Shell)BriefAuswahl.this.getSite().getShell(), (String)Messages.BriefAuswahl_errorttile, (String)Messages.BriefAuswahl_erroreditmessage);
                    }
                    BriefAuswahl.this.refreshSelectedViewer();
                }
            }
        };
        this.endLocalEditAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_EDIT_DONE.getImageDescriptor();
            }

            public String getText() {
                return Messages.BriefAuswahl_actionlocaleditstopmessage;
            }

            public void run() {
                IDocumentLetter brief = BriefAuswahl.this.getSelected();
                if (brief != null) {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command command = commandService.getCommand("ch.elexis.core.ui.command.endLocalDocument");
                    ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).set(command.getId().concat(".selection"), (Object)new StructuredSelection((Object)brief));
                    try {
                        command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)this, null));
                    }
                    catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                        MessageDialog.openError((Shell)BriefAuswahl.this.getSite().getShell(), (String)Messages.BriefAuswahl_errortitle, (String)Messages.BriefAuswahl_errorlocaleditendmessage);
                    }
                }
                BriefAuswahl.this.refreshSelectedViewer();
            }
        };
        this.cancelLocalEditAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_EDIT_ABORT.getImageDescriptor();
            }

            public String getText() {
                return Messages.BriefAuswahl_actionlocaleditabortmessage;
            }

            public void run() {
                IDocumentLetter brief = BriefAuswahl.this.getSelected();
                if (brief != null) {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command command = commandService.getCommand("ch.elexis.core.ui.command.abortLocalDocument");
                    ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).set(command.getId().concat(".selection"), (Object)new StructuredSelection((Object)brief));
                    try {
                        command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)this, null));
                    }
                    catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                        MessageDialog.openError((Shell)BriefAuswahl.this.getSite().getShell(), (String)Messages.BriefAuswahl_errortitle, (String)Messages.BriefAuswahl_errorlocaleditabortmessage);
                    }
                }
                BriefAuswahl.this.refreshSelectedViewer();
            }
        };
        this.briefLadenAction.setImageDescriptor(Images.IMG_DOCUMENT_TEXT.getImageDescriptor());
        this.briefLadenAction.setToolTipText(Messages.BriefAuswahlOpenLetterForEdit);
        this.briefNeuAction.setImageDescriptor(Images.IMG_DOCUMENT_ADD.getImageDescriptor());
        this.briefNeuAction.setToolTipText(Messages.BriefAuswahlCreateNewDocument);
        this.editNameAction.setImageDescriptor(Images.IMG_DOCUMENT_WRITE.getImageDescriptor());
        this.editNameAction.setToolTipText(Messages.BriefAuswahlRenameDocument);
        this.deleteAction.setImageDescriptor(Images.IMG_DOCUMENT_REMOVE.getImageDescriptor());
        this.deleteAction.setToolTipText(Messages.BriefAuswahlDeleteDocument);
    }

    public IDocumentLetter getSelected() {
        CommonViewer cv;
        Object[] o;
        CTabItem sel = this.ctab.getSelection();
        if (sel != null && (o = (cv = (CommonViewer)sel.getData()).getSelection()) != null && o.length > 0 && o[0] instanceof IDocumentLetter) {
            return (IDocumentLetter)o[0];
        }
        return null;
    }

    public Brief getSelectedBrief() {
        CommonViewer cv;
        Object[] o;
        CTabItem sel = this.ctab.getSelection();
        if (sel != null && (o = (cv = (CommonViewer)sel.getData()).getSelection()) != null && o.length > 0 && o[0] instanceof IDocumentLetter) {
            return (Brief)NoPoUtil.loadAsPersistentObject((Identifiable)((Identifiable)o[0]));
        }
        return null;
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout(part, currentState);
    }

    class sPage
    extends Composite {
        private TableViewer tableViewer;
        private LetterViewerComparator comparator;
        private final CommonViewer cv;
        private final ViewerConfigurer vc;

        public CommonViewer getCommonViewer() {
            return this.cv;
        }

        sPage(Composite parent, final String cat) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout());
            this.cv = new CommonViewer();
            final DefaultControlFieldProvider controlFieldProvider = new DefaultControlFieldProvider(this.cv, new String[]{"subject=Titel"});
            CommonViewerContentProvider contentProvider = new CommonViewerContentProvider(this.cv){
                private static final int QUERY_LIMIT = 500;

                public Object[] getElements(Object inputElement) {
                    java.util.Optional actPat = ContextServiceHolder.get().getActivePatient();
                    if (actPat.isPresent()) {
                        IQuery<?> query = this.getBaseQuery();
                        query.and((EStructuralFeature)ModelPackage.Literals.IDOCUMENT__PATIENT, IQuery.COMPARATOR.EQUALS, actPat.get());
                        if (cat.equals(Messages.BriefAuswahlAllLetters2)) {
                            query.and((EStructuralFeature)ModelPackage.Literals.IDOCUMENT__CATEGORY, IQuery.COMPARATOR.NOT_EQUALS, (Object)"Vorlagen");
                        } else {
                            query.and((EStructuralFeature)ModelPackage.Literals.IDOCUMENT__CATEGORY, IQuery.COMPARATOR.EQUALS, (Object)cat);
                        }
                        controlFieldProvider.setQuery(query);
                        List elements = query.execute();
                        return elements.toArray(new Object[elements.size()]);
                    }
                    return new Object[0];
                }

                @Override
                protected IQuery<?> getBaseQuery() {
                    IQuery ret = CoreModelServiceHolder.get().getQuery(IDocumentLetter.class);
                    if (!this.ignoreLimit) {
                        ret.limit(500);
                    }
                    return ret;
                }
            };
            this.vc = new ViewerConfigurer(contentProvider, new DefaultLabelProvider(), controlFieldProvider, new ViewerConfigurer.DefaultButtonProvider(), new SimpleWidgetProvider(2, 66048, this.cv));
            this.vc.setContentType(ViewerConfigurer.ContentType.GENERICOBJECT);
            this.cv.create(this.vc, this, 0, BriefAuswahl.this.getViewSite());
            this.tableViewer = (TableViewer)this.cv.getViewerWidget();
            this.tableViewer.getTable().setHeaderVisible(true);
            this.createColumns();
            this.comparator = new LetterViewerComparator();
            this.tableViewer.setComparator((ViewerComparator)this.comparator);
            if (CoreHub.localCfg.get("briefe/rename_with_f2", false)) {
                this.tableViewer.getTable().addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                    }

                    public void keyReleased(KeyEvent e) {
                        if (e.keyCode == 0x100000B) {
                            ((sPage)sPage.this).BriefAuswahl.this.editNameAction.run();
                        }
                    }
                });
            }
            this.vc.getContentProvider().startListening();
            Button bLoad = BriefAuswahl.this.tk.createButton((Composite)this, Messages.BriefAuswahlLoadButtonText, 8);
            bLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((sPage)sPage.this).BriefAuswahl.this.briefLadenAction.run();
                }
            });
            bLoad.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        }

        private void createColumns() {
            TableViewerColumn col = new TableViewerColumn(this.tableViewer, 0);
            col.getColumn().setText(Messages.BriefAuswahlColumnDate);
            col.getColumn().setWidth(100);
            col.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(col.getColumn(), 0));
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
                private SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");

                public String getText(Object element) {
                    IDocumentLetter b = (IDocumentLetter)element;
                    return this.dateFormat.format(b.getCreated());
                }
            });
            col = new TableViewerColumn(this.tableViewer, 0);
            col.getColumn().setText(Messages.BriefAuswahlColumnTitle);
            col.getColumn().setWidth(300);
            col.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(col.getColumn(), 1));
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    IDocumentLetter b = (IDocumentLetter)element;
                    return b.getTitle();
                }

                public Image getImage(Object element) {
                    if (LocalDocumentServiceHolder.getService().isPresent() && LocalDocumentServiceHolder.getService().get().contains(element)) {
                        return Images.IMG_EDIT.getImage();
                    }
                    return super.getImage(element);
                }
            });
        }

        private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
            SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    sPage.this.comparator.setColumn(index);
                    sPage.this.tableViewer.getTable().setSortDirection(sPage.this.comparator.getDirection());
                    sPage.this.tableViewer.getTable().setSortColumn(column);
                    sPage.this.tableViewer.refresh();
                }
            };
            return selectionAdapter;
        }

        class LetterViewerComparator
        extends ViewerComparator {
            private int propertyIndex = 0;
            private boolean direction = true;

            public int getDirection() {
                return this.direction ? 1024 : 128;
            }

            public void setColumn(int column) {
                if (column == this.propertyIndex) {
                    this.direction = !this.direction;
                } else {
                    this.propertyIndex = column;
                    this.direction = true;
                }
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IDocumentLetter && e2 instanceof IDocumentLetter) {
                    IDocumentLetter b1 = (IDocumentLetter)e1;
                    IDocumentLetter b2 = (IDocumentLetter)e2;
                    int rc = 0;
                    switch (this.propertyIndex) {
                        case 0: {
                            rc = b1.getCreated().compareTo(b2.getCreated());
                            break;
                        }
                        case 1: {
                            rc = b1.getTitle().compareTo(b2.getTitle());
                            break;
                        }
                        default: {
                            rc = 0;
                        }
                    }
                    if (this.direction) {
                        rc = -rc;
                    }
                    return rc;
                }
                return 0;
            }
        }
    }
}

