/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.ui.exchange.Messages;
import ch.elexis.core.ui.exchange.elements.ContactsElement;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.core.ui.util.Log;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.XMLTool;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XChangeContainer {
    public static final String Version = "2.0.0";
    public static final String ATTR_LANGUAGE = "language";
    private static final String ATTR_PROTOCOL_VERSION = "protocolVersion";
    private static final String ATTR_CREATOR_VERSION = "creatorVersion";
    private static final String ATTR_CREATOR_ID = "creatorID";
    public static final String ATTR_CREATOR_NAME = "creatorName";
    public static final String ATTR_RESPONSIBLE = "responsible";
    public static final String ATTR_DESTINATION = "destination";
    public static final String ATTR_ORIGIN = "origin";
    private static final String XCHANGE_MAGIC = "xChange";
    private static final String ATTR_ID = "id";
    public static final String ATTR_TIMESTAMP = "timestamp";
    private static final String PLURAL = "s";
    public static final Namespace ns = Namespace.getNamespace((String)"xChange", (String)"http://informatics.sgam.ch/xChange");
    public static final Namespace nsxsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XML Schema-instance");
    public static final Namespace nsschema = Namespace.getNamespace((String)"schemaLocation", (String)"http://informatics.sgam.ch/xChange xchange.xsd");
    public static final String ROOT_ELEMENT = "xChange";
    public static final String ROOTPATH = "/xChange/";
    public static final String ENCLOSE_CONTACTS = "contacts";
    public static final String ENCLOSE_DOCUMENTS = "documents";
    public static final String ENCLOSE_RECORDS = "records";
    public static final String ENCLOSE_FINDINGS = "findings";
    public static final String ENCLOSE_MEDICATIONS = "medications";
    public static final String ENCLOSE_RISKS = "risks";
    public static final String ENCLOSE_EPISODES = "episodes";
    private Document doc;
    private final Element eHeader = new Element("header", ns);
    private Element eRoot;
    private boolean bValid = false;
    protected static Log log = Log.get("XChange");
    protected HashMap<String, byte[]> binFiles = new HashMap();
    protected HashMap<Element, UserChoice> choices = new HashMap();
    private final HashMap<XChangeElement, PersistentObject> mapElementToObject = new HashMap();
    private final HashMap<PersistentObject, XChangeElement> mapObjectToElement = new HashMap();
    private final List<IConfigurationElement> lex = Extensions.getExtensions((String)"ch.elexis.core.ui.xCHangeContribution");
    protected Properties props;

    public XChangeContainer() {
        this.doc = new Document();
        this.eRoot = new Element("xChange", ns);
        this.eRoot.addNamespaceDeclaration(nsxsi);
        this.eRoot.addNamespaceDeclaration(nsschema);
        this.eRoot.setAttribute(ATTR_TIMESTAMP, new TimeTool().toString(14));
        this.eRoot.setAttribute(ATTR_ID, XMLTool.idToXMLID((String)StringTool.unique((String)"xChange")));
        this.eRoot.setAttribute(ATTR_ORIGIN, XMLTool.idToXMLID((String)CoreHub.actMandant.getId()));
        this.eRoot.setAttribute(ATTR_DESTINATION, "undefined");
        this.eRoot.setAttribute(ATTR_RESPONSIBLE, XMLTool.idToXMLID((String)CoreHub.actMandant.getId()));
        this.doc.setRootElement(this.eRoot);
        this.eHeader.setAttribute(ATTR_CREATOR_NAME, "Elexis");
        this.eHeader.setAttribute(ATTR_CREATOR_ID, "ch.elexis");
        this.eHeader.setAttribute(ATTR_CREATOR_VERSION, CoreHub.Version);
        this.eHeader.setAttribute(ATTR_PROTOCOL_VERSION, Version);
        this.eHeader.setAttribute(ATTR_LANGUAGE, Locale.getDefault().toString());
        this.eRoot.addContent((Content)this.eHeader);
    }

    public void setDocument(Document doc) {
        this.doc = doc;
        this.eRoot = doc.getRootElement();
    }

    public String toString() {
        Format format = Format.getPrettyFormat();
        format.setEncoding("utf-8");
        XMLOutputter xmlo = new XMLOutputter(format);
        String xmlAspect = xmlo.outputString(this.doc);
        return xmlAspect;
    }

    public Document getDocument() {
        return this.doc;
    }

    public boolean isValid() {
        return this.bValid;
    }

    public void setValid(boolean bValid) {
        this.bValid = bValid;
    }

    public List<IConfigurationElement> getXChangeContributors() {
        return this.lex;
    }

    public void addMapping(XChangeElement element, PersistentObject obj) {
        this.mapElementToObject.put(element, obj);
        this.mapObjectToElement.put(obj, element);
    }

    public PersistentObject getMapping(XChangeElement element) {
        return this.mapElementToObject.get(element);
    }

    public XChangeElement getMapping(PersistentObject obj) {
        return this.mapObjectToElement.get(obj);
    }

    public UserChoice getChoice(XChangeElement key) {
        return this.choices.get(key.getElement());
    }

    public UserChoice getChoice(Element key) {
        return this.choices.get(key);
    }

    public void addChoice(Element key, String name) {
        this.choices.put(key, new UserChoice(true, name, key));
    }

    public void addChoice(XChangeElement key, String name) {
        this.choices.put(key.getElement(), new UserChoice(true, name, key));
    }

    public ContactsElement getContactsElement() {
        Element ec = this.eRoot.getChild(ENCLOSE_CONTACTS, ns);
        ContactsElement eContacts = new ContactsElement();
        if (ec == null) {
            this.eRoot.addContent((Content)eContacts.getElement());
            this.choices.put(eContacts.getElement(), new UserChoice(true, Messages.XChangeContainer_kontakte, eContacts));
        } else {
            eContacts.setElement(ec);
        }
        return eContacts;
    }

    public List<Element> getContactElements() {
        return this.getElements("/xChange/contacts/contact");
    }

    public byte[] getBinary(String id) {
        return this.binFiles.get(id);
    }

    public void addChoice(XChangeElement e, String name, Object o) {
        this.choices.put(e.getElement(), new UserChoice(true, name, o));
    }

    public void addChoice(Element e, String name, Object o) {
        this.choices.put(e, new UserChoice(true, name, o));
    }

    public Element getRoot() {
        return this.eRoot;
    }

    public List<Element> getElements(String path) {
        LinkedList<Element> ret = new LinkedList<Element>();
        String[] trace = path.split("/");
        Element runner = this.eRoot;
        int i = 2;
        while (i < trace.length - 1) {
            if ((runner = runner.getChild(trace[i], ns)) == null) {
                return ret;
            }
            ++i;
        }
        String name = trace[trace.length - 1];
        if (Objects.equals(name, "*")) {
            return runner.getChildren();
        }
        return runner.getChildren(name, ns);
    }

    public Namespace getNamespace() {
        return ns;
    }

    public Iterator<Map.Entry<String, byte[]>> getBinaries() {
        return this.binFiles.entrySet().iterator();
    }

    public void setConfiguration(Properties props) {
        this.props = props;
    }

    public void setProperty(String name, String value) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.setProperty(name, value);
    }

    public String getProperty(String name) {
        if (this.props == null) {
            this.props = new Properties();
        }
        return this.props.getProperty(name);
    }

    protected Properties getProperties() {
        return this.props;
    }

    public static class UserChoice {
        boolean bSelected;
        String title;
        Object object;

        public void select(boolean bSelection) {
            this.bSelected = bSelection;
        }

        public boolean isSelected() {
            return this.bSelected;
        }

        public String getTitle() {
            return this.title;
        }

        public Object getObject() {
            return this.object;
        }

        public UserChoice(boolean bSelected, String title, Object object) {
            this.bSelected = bSelected;
            this.title = title;
            this.object = object;
        }
    }
}

