/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange;

import ch.elexis.core.data.interfaces.IPatient;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.exchange.Messages;
import ch.elexis.data.Anschrift;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Organisation;
import ch.elexis.data.Patient;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.List;

public class KontaktMatcher {
    private static final String SEP = ", ";
    static final String resolve1 = String.valueOf(Messages.KontaktMatcher_noauto1) + Messages.KontaktMatcher_noauto2 + Messages.KontaktMatcher_noauto3 + Messages.KontaktMatcher_noauto4 + Messages.KontaktMatcher_noauto5;

    public static Kontakt findKontakt(String name, String strasse, String plz, String ort) {
        Organisation o = KontaktMatcher.findOrganisation(name, "", strasse, plz, ort, CreateMode.FAIL);
        if (o == null) {
            Person p = KontaktMatcher.findPerson(name, "", "", "", strasse, plz, ort, "", CreateMode.FAIL);
            return p;
        }
        return o;
    }

    public static Organisation findOrganisation(String name, String zusatz, String strasse, String plz, String ort, CreateMode createMode) {
        List found;
        String un;
        String[] hints = new String[12];
        hints[0] = name;
        hints[3] = strasse;
        hints[4] = plz;
        hints[5] = ort;
        Query qbe = new Query(Organisation.class);
        if (!StringTool.isNothing((Object)name)) {
            qbe.startGroup();
            qbe.add("Bezeichnung1", "LIKE", String.valueOf(name) + "%", true);
            un = StringTool.unambiguify((String)name);
            if (!un.equalsIgnoreCase(name)) {
                qbe.or();
                qbe.add("Bezeichnung1", "LIKE", String.valueOf(un) + "%", true);
            }
            qbe.endGroup();
            qbe.and();
        }
        if (!StringTool.isNothing((Object)zusatz)) {
            qbe.startGroup();
            qbe.add("Zusatz1", "LIKE", String.valueOf(zusatz) + "%", true);
            un = StringTool.unambiguify((String)zusatz);
            if (!un.equalsIgnoreCase(zusatz)) {
                qbe.or();
                qbe.add("Zusatz1", "LIKE", String.valueOf(un) + "%", true);
            }
            qbe.endGroup();
        }
        if ((found = qbe.execute()).size() == 0) {
            if (createMode == CreateMode.CREATE) {
                Organisation org = new Organisation(name, StringTool.unNull((String)zusatz));
                KontaktMatcher.addAddress((Kontakt)org, strasse, plz, ort);
                return org;
            }
            if (createMode == CreateMode.ASK) {
                return (Organisation)KontaktSelektor.showInSync(Organisation.class, Messages.KontaktMatcher_OrganizationNotFound, String.valueOf(name) + SEP + strasse + SEP + plz + " " + ort, resolve1, hints);
            }
            return null;
        }
        if (found.size() == 1) {
            return (Organisation)found.get(0);
        }
        if (createMode == CreateMode.ASK) {
            return (Organisation)KontaktSelektor.showInSync(Organisation.class, Messages.KontaktMatcher_OrganizationNotUnique, String.valueOf(name) + SEP + strasse + SEP + plz + " " + ort, resolve1, hints);
        }
        return (Organisation)KontaktMatcher.matchAddress(found.toArray(new Kontakt[0]), strasse, plz, ort, null);
    }

    public static Patient findPatient(String name, String vorname, String gebdat, String gender, String strasse, String plz, String ort, String natel, CreateMode createMode) {
        Person pat = KontaktMatcher.findPerson(name, vorname, gebdat, gender, strasse, plz, ort, natel, createMode, true);
        if (pat != null) {
            return Patient.load((String)pat.getId());
        }
        return null;
    }

    public static Person findPerson(String name, String vorname, String gebdat, String gender, String strasse, String plz, String ort, String natel, CreateMode createMode) {
        return KontaktMatcher.findPerson(name, vorname, gebdat, gender, strasse, plz, ort, natel, createMode, false);
    }

    public static Person findPerson(String name, String vorname, String gebdat, String gender, String strasse, String plz, String ort, String natel, CreateMode createMode, boolean isPatient) {
        String un;
        String[] hints = new String[12];
        hints[0] = name;
        hints[1] = vorname;
        hints[2] = gebdat;
        hints[10] = gender;
        hints[3] = strasse;
        hints[4] = plz;
        hints[5] = ort;
        if (isPatient) {
            hints[11] = "1";
        }
        boolean hasSignificantValue = false;
        Query qbe = new Query(Person.class);
        String sex = "";
        String birthdate = "";
        if (!StringTool.isNothing((Object)name)) {
            qbe.startGroup();
            qbe.add("Name", "LIKE", String.valueOf(name) + "%", true);
            un = StringTool.unambiguify((String)name);
            if (!un.equalsIgnoreCase(name)) {
                qbe.or();
                qbe.add("Name", "LIKE", String.valueOf(un) + "%", true);
            }
            qbe.endGroup();
            qbe.and();
            hasSignificantValue = true;
        }
        if (!StringTool.isNothing((Object)vorname)) {
            qbe.startGroup();
            qbe.add("Vorname", "LIKE", String.valueOf(vorname) + "%", true);
            un = StringTool.unambiguify((String)vorname);
            if (!un.equalsIgnoreCase(vorname)) {
                qbe.or();
                qbe.add("Vorname", "LIKE", String.valueOf(un) + "%", true);
            }
            qbe.endGroup();
            qbe.and();
            hasSignificantValue = true;
        }
        if (!StringTool.isNothing((Object)gebdat)) {
            TimeTool tt = new TimeTool();
            if (tt.set(gebdat)) {
                birthdate = tt.toString(4);
                qbe.add("Geburtsdatum", "=", tt.toString(9));
            }
            hasSignificantValue = true;
        }
        if (!StringTool.isNothing((Object)gender)) {
            String gl = gender.toLowerCase();
            sex = gl.startsWith("f") || gl.startsWith("w") ? "w" : (gl.startsWith("m") ? "m" : (StringTool.isNothing((Object)vorname) ? "?" : (StringTool.isFemale((String)vorname) ? "w" : "m")));
            qbe.add("Geschlecht", "=", sex);
        }
        if (!hasSignificantValue) {
            return null;
        }
        List found = qbe.execute();
        if (found.size() == 0) {
            if (createMode == CreateMode.CREATE) {
                Person ret = new Person(name, vorname, birthdate, sex);
                KontaktMatcher.addAddress((Kontakt)ret, strasse, plz, ort);
                return ret;
            }
            if (createMode == CreateMode.ASK) {
                return (Person)KontaktSelektor.showInSync(Person.class, Messages.KontaktMatcher_PersonNotFound, String.valueOf(name) + " " + vorname + (StringTool.isNothing((Object)gebdat) ? "" : SEP + gebdat) + SEP + strasse + SEP + plz + " " + ort, resolve1, hints);
            }
            return null;
        }
        if (found.size() == 1) {
            return (Person)found.get(0);
        }
        if (createMode == CreateMode.ASK) {
            return (Person)KontaktSelektor.showInSync(Person.class, Messages.KontaktMatcher_PersonNotUnique, String.valueOf(name) + " " + vorname + (StringTool.isNothing((Object)gebdat) ? "" : SEP + gebdat) + SEP + strasse + SEP + plz + " " + ort, resolve1, hints);
        }
        return (Person)KontaktMatcher.matchAddress(found.toArray(new Kontakt[0]), strasse, plz, ort, natel);
    }

    public static Kontakt matchAddress(Kontakt[] kk, String strasse, String plz, String ort, String natel) {
        int[] score = new int[kk.length];
        int i = 0;
        while (i < kk.length) {
            if (!StringTool.isNothing((Object)natel) && KontaktMatcher.normalizePhone(kk[i].get("NatelNr")).equals(KontaktMatcher.normalizePhone(natel))) {
                int n = i;
                score[n] = score[n] + 5;
            }
            if (!StringTool.isNothing((Object)strasse)) {
                if (KontaktMatcher.isSameStreet(kk[i].get("Strasse"), strasse)) {
                    int n = i;
                    score[n] = score[n] + 3;
                } else {
                    int n = i;
                    score[n] = score[n] - 2;
                }
            }
            if (!StringTool.isNothing((Object)plz)) {
                if (plz.equals(kk[i].get("Plz"))) {
                    int n = i;
                    score[n] = score[n] + 2;
                } else {
                    int n = i;
                    score[n] = score[n] - 1;
                }
            }
            if (!StringTool.isNothing((Object)ort)) {
                if (ort.equals(kk[i].get("Ort"))) {
                    int n = i;
                    score[n] = score[n] + 1;
                } else {
                    int n = i;
                    score[n] = score[n] - 1;
                }
            }
            ++i;
        }
        Kontakt found = kk[0];
        int scored = score[0];
        int i2 = 1;
        while (i2 < score.length) {
            if (score[i2] > scored) {
                found = kk[i2];
                scored = score[i2];
            }
            ++i2;
        }
        return found;
    }

    public static String[] normalizeAddress(String str) {
        String[] ret = str.split("\\s+", 2);
        if (ret.length < 2) {
            String[] rx = new String[]{"", ret[0]};
            return rx;
        }
        return ret;
    }

    public static String normalizePhone(String nr) {
        return nr.replaceAll("[\\s-:\\.]", "");
    }

    public static boolean isSameStreet(String s1, String s2) {
        String[] ns2;
        String[] ns1 = KontaktMatcher.normalizeStrasse(s1);
        if (!ns1[0].matches((ns2 = KontaktMatcher.normalizeStrasse(s2))[0])) {
            return false;
        }
        return ns1[1].matches(ns2[1]);
    }

    static String[] normalizeStrasse(String strasse) {
        String[] m1 = StringTool.normalizeCase((String)strasse).split("\\s");
        int m1l = m1.length;
        StringBuilder m2 = new StringBuilder();
        m2.append(m1[0]);
        String nr = "0";
        if (m1l > 1) {
            if (m1[m1l - 1].matches("[0-9]+[a-zA-Z]")) {
                nr = m1[m1l - 1];
                --m1l;
            }
            if (m1l > 1) {
                int i = 1;
                while (i < m1l) {
                    m2.append(" ").append(m1[i]);
                    ++i;
                }
            }
        }
        return new String[]{m2.toString(), nr};
    }

    public static void addAddress(Kontakt k, String str, String plzort) {
        String[] ort = plzort.split("[\\s+]");
        if (ort.length == 2) {
            KontaktMatcher.addAddress(k, str, ort[0], ort[1]);
        } else if (ort.length > 2) {
            StringBuilder plz = new StringBuilder();
            int i = 1;
            while (i < ort.length) {
                plz.append(ort[i]).append(" ");
                ++i;
            }
            KontaktMatcher.addAddress(k, str, ort[0], plz.toString());
        } else {
            KontaktMatcher.addAddress(k, str, ort[0], "");
        }
    }

    public static void addAddress(Kontakt k, String str, String plz, String ort) {
        Anschrift an = k.getAnschrift();
        if (!StringTool.isNothing((Object)str)) {
            an.setStrasse(str);
        }
        if (!StringTool.isNothing((Object)plz)) {
            String[] plzx;
            if (plz.matches("[A-Z]{1,3}[\\s\\-]+[A-Za-z0-9]+") && (plzx = plz.split("[\\s\\-]+", 1)).length > 1) {
                plz = plzx[1];
                an.setLand(plzx[0]);
            }
            an.setPlz(plz);
        }
        if (!StringTool.isNothing((Object)ort)) {
            an.setOrt(ort);
        }
        k.setAnschrift(an);
        k.createStdAnschrift();
    }

    public static boolean isSame(Person a, String nameB, String firstnameB, String gebDatB) {
        block4: {
            block5: {
                String vorname2;
                String vorname1;
                String name1 = StringTool.unambiguify((String)KontaktMatcher.simpleName(a.getName()));
                String name2 = StringTool.unambiguify((String)KontaktMatcher.simpleName(nameB));
                if (!name1.equals(name2) || !(vorname1 = StringTool.unambiguify((String)KontaktMatcher.simpleName(a.getVorname()))).equals(vorname2 = StringTool.unambiguify((String)KontaktMatcher.simpleName(firstnameB)))) break block4;
                if (!StringTool.isNothing((Object)a.getGeburtsdatum()) && !StringTool.isNothing((Object)gebDatB)) break block5;
                return true;
            }
            try {
                TimeTool gd1 = new TimeTool(a.getGeburtsdatum());
                TimeTool gd2 = new TimeTool(gebDatB);
                if (gd1.equals((Object)gd2)) {
                    return true;
                }
            }
            catch (Throwable t) {
                ExHandler.handle((Throwable)t);
            }
        }
        return false;
    }

    public static boolean isSame(IPatient a, String nameB, String firstnameB, String gebDatB) {
        block4: {
            block5: {
                String vorname2;
                String vorname1;
                String name1 = StringTool.unambiguify((String)KontaktMatcher.simpleName(a.getDescription1()));
                String name2 = StringTool.unambiguify((String)KontaktMatcher.simpleName(nameB));
                if (!name1.equals(name2) || !(vorname1 = StringTool.unambiguify((String)KontaktMatcher.simpleName(a.getDescription2()))).equals(vorname2 = StringTool.unambiguify((String)KontaktMatcher.simpleName(firstnameB)))) break block4;
                if (!StringTool.isNothing((Object)a.getDateOfBirth()) && !StringTool.isNothing((Object)gebDatB)) break block5;
                return true;
            }
            try {
                TimeTool gd1 = new TimeTool(a.getDateOfBirth());
                TimeTool gd2 = new TimeTool(gebDatB);
                if (gd1.equals((Object)gd2)) {
                    return true;
                }
            }
            catch (Throwable t) {
                ExHandler.handle((Throwable)t);
            }
        }
        return false;
    }

    static String simpleName(String name) {
        String[] ret = name.split("\\s*[- ]\\s*");
        return ret[0];
    }

    public static enum CreateMode {
        FAIL,
        CREATE,
        ASK;

    }
}

