/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.services.IQuery;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SelectBestellungDialog
extends SelectionDialog {
    private IStructuredContentProvider fContentProvider;
    private ILabelProvider fLabelProvider;
    private Object fInput;
    private TableViewer fTableViewer;
    private boolean fAddCancelButton = true;
    private int widthInChars = 55;
    private int heightInChars = 15;

    public SelectBestellungDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        this.createMessageArea(parent);
        this.fTableViewer = new TableViewer(parent, this.getTableStyle());
        this.fTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.addColumns();
        this.setComparator();
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (SelectBestellungDialog.this.fAddCancelButton) {
                    SelectBestellungDialog.this.okPressed();
                }
            }
        });
        List initialSelection = this.getInitialElementSelections();
        if (initialSelection != null) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(initialSelection));
        }
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(this.heightInChars);
        gd.widthHint = this.convertWidthInCharsToPixels(this.widthInChars);
        Table table = this.fTableViewer.getTable();
        table.setLayoutData((Object)gd);
        table.setFont(container.getFont());
        table.setHeaderVisible(true);
        IQuery query = CoreModelServiceHolder.get().getQuery(IOrder.class);
        this.fTableViewer.setInput((Object)query.execute());
        return parent;
    }

    private void setComparator() {
        this.fTableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object b1, Object b2) {
                TimeTool t1 = new TimeTool();
                TimeTool t2 = new TimeTool();
                this.setTimeTool((IOrder)b1, t1);
                this.setTimeTool((IOrder)b2, t2);
                if (t1.after((Object)t2)) {
                    return -1;
                }
                if (t2.after((Object)t1)) {
                    return 1;
                }
                return Long.valueOf(((IOrder)b1).getLastupdate()).compareTo((long)((IOrder)b2).getLastupdate());
            }

            private void setTimeTool(IOrder order, TimeTool timeTool) {
                try {
                    String[] i = order.getId().split(":");
                    timeTool.set(i[1]);
                }
                catch (Exception e) {
                    timeTool.set("1.1.1970");
                }
            }
        });
    }

    private void addColumns() {
        TableViewerColumn closed = new TableViewerColumn(this.fTableViewer, 0);
        closed.getColumn().setWidth(50);
        closed.getColumn().setText("Abg.");
        closed.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IOrder order = (IOrder)element;
                if (order.isDone()) {
                    return "*";
                }
                if (order.isPartialDone()) {
                    return "/";
                }
                return "";
            }
        });
        TableViewerColumn time = new TableViewerColumn(this.fTableViewer, 0);
        time.getColumn().setWidth(125);
        time.getColumn().setText("Datum");
        time.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            TimeTool date = new TimeTool();

            public String getText(Object element) {
                IOrder order = (IOrder)element;
                String[] i = order.getId().split(":");
                if (i.length > 1) {
                    this.date.set(i[1]);
                    return this.date.toString(0);
                }
                return "???";
            }
        });
        TableViewerColumn title = new TableViewerColumn(this.fTableViewer, 0);
        title.getColumn().setWidth(200);
        title.getColumn().setText("Titel");
        title.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IOrder order = (IOrder)element;
                String[] i = order.getId().split(":");
                if (i.length > 0) {
                    return i[0];
                }
                return "???";
            }
        });
    }

    protected int getTableStyle() {
        return 268503812;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        this.setResult(selection.toList());
        super.okPressed();
    }
}

