/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.util.DayDateCombo;
import ch.elexis.core.ui.util.MoneyInput;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.BillingSystem;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class KonsZumVerrechnenWizardDialog
extends TitleAreaDialog {
    private static final String CONFIG = "dialogs/konszumverrechnen/";
    private static final String ALLMARKED = Messages.KonsZumVerrechnenWizardDialog_selectCasesToCharge;
    private static final String TAGEN_BZW_DEM = Messages.KonsZumVerrechnenWizardDialog_daysOrDate;
    private static final String RECHNUNGEN_ERSTELLEN = Messages.KonsZumVerrechnenWizardDialog_createBills;
    private static final String BEHANDLUNGEN_ZUM_VERRECHNEN_AUTOMATISCH_AUSWAEHLEN = Messages.KonsZumVerrechnenWizardDialog_createProposal;
    private static final String RECHNUNGS_AUTOMATIK = Messages.KonsZumVerrechnenWizardDialog_billingAUtomation;
    private static final String TREATMENT_TRIMESTER = Messages.KonsZumVerrechnenWizardDialog_choseAllQuartal;
    private static final String TREATMENT_AMOUNTHIGHER = Messages.KonsZumVerrechnenWizardDialog_chooseFromAmount;
    private static final String TREATMENTENDBEFORE = Messages.KonsZumVerrechnenWizardDialog_choseEndeDate;
    private static final String TREATMENTBEGINBEFORE = Messages.KonsZumVerrechnenWizardDialog_chooseBeginningDate;
    private static final String TREATMENT_TIMESPAN = Messages.KonsZumVerrechnenWizardDialog_timespan;
    private static final String TREATMENT_TIMESPAN_TILL = Messages.KonsZumVerrechnenWizardDialog_timespanTill;
    private static final String TREATMENT_ACCOUNTING_SYS = Messages.KonsZumVerrechnenWizardDialog_chooseAccountingSystem;
    private static final String SKIPSELECTION = Messages.KonsZumVerrechnenWizardDialog_skipProposal;
    private static final String CFG_SKIP = "dialogs/konszumverrechnen/skipselection";
    Button cbMarked;
    Button cbBefore;
    Button cbAmount;
    Button cbTime;
    Button cbQuartal;
    Button cbSkip;
    Button cbTimespan;
    Button cbAccountingSys;
    MoneyInput mi1;
    DayDateCombo ddc1;
    DayDateCombo ddc2;
    ComboViewer cAccountingSys;
    public String accountSys;
    public TimeTool ttFirstBefore;
    public TimeTool ttLastBefore;
    public TimeTool ttFrom;
    public TimeTool ttTo;
    public Money mAmount;
    public boolean bQuartal;
    public boolean bMarked;
    public boolean bSkip;
    private DateTime timespanFrom;
    private DateTime timespanTo;

    public KonsZumVerrechnenWizardDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        ret.setLayout((Layout)new GridLayout(4, false));
        this.cbMarked = new Button(ret, 32);
        this.cbMarked.setText(ALLMARKED);
        this.cbMarked.setLayoutData((Object)SWTHelper.getFillGridData(4, true, 1, false));
        this.cbBefore = new Button(ret, 32);
        this.cbBefore.setText(TREATMENTBEGINBEFORE);
        this.ddc1 = new DayDateCombo(ret, "", TAGEN_BZW_DEM);
        this.ddc1.spinDaysBack();
        this.cbTime = new Button(ret, 32);
        this.cbTime.setText(TREATMENTENDBEFORE);
        this.ddc2 = new DayDateCombo(ret, "", TAGEN_BZW_DEM);
        this.ddc2.spinDaysBack();
        int prev = CoreHub.localCfg.get("dialogs/konszumverrechnen/beginBefore", 30) * -1;
        TimeTool ttNow = new TimeTool();
        ttNow.addDays(prev);
        this.ddc1.setDays(prev);
        prev = CoreHub.localCfg.get("dialogs/konszumverrechnen/endBefore", 20) * -1;
        this.ddc2.setDays(prev);
        this.ddc1.setLayoutData(SWTHelper.getFillGridData(3, true, 1, false));
        this.ddc2.setLayoutData(SWTHelper.getFillGridData(3, true, 1, false));
        this.cbAmount = new Button(ret, 32);
        this.cbAmount.setText(TREATMENT_AMOUNTHIGHER);
        this.mi1 = new MoneyInput(ret);
        this.mi1.setLayoutData(new GridData(16384, 0x1000000, false, false, 3, 1));
        this.mi1.setLayoutData(SWTHelper.getFillGridData(3, true, 1, false));
        this.cbQuartal = new Button(ret, 32);
        this.cbQuartal.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.cbQuartal.setText(TREATMENT_TRIMESTER);
        this.cbTimespan = new Button(ret, 32);
        this.cbTimespan.setText(TREATMENT_TIMESPAN);
        this.timespanFrom = new DateTime(ret, 0);
        Label lblTill = new Label(ret, 0);
        lblTill.setText(TREATMENT_TIMESPAN_TILL);
        this.timespanTo = new DateTime(ret, 0);
        this.cbTimespan.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KonsZumVerrechnenWizardDialog.this.timespanFrom.setEnabled(KonsZumVerrechnenWizardDialog.this.cbTimespan.getSelection());
                KonsZumVerrechnenWizardDialog.this.timespanTo.setEnabled(KonsZumVerrechnenWizardDialog.this.cbTimespan.getSelection());
            }
        });
        this.cbAccountingSys = new Button(ret, 32);
        this.cbAccountingSys.setText(TREATMENT_ACCOUNTING_SYS);
        this.cbAccountingSys.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KonsZumVerrechnenWizardDialog.this.cAccountingSys.getCombo().setEnabled(KonsZumVerrechnenWizardDialog.this.cbAccountingSys.getSelection());
            }
        });
        this.cAccountingSys = new ComboViewer(ret, 0);
        Combo combo = this.cAccountingSys.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.cAccountingSys.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cAccountingSys.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        String[] accSystems = BillingSystem.getAbrechnungsSysteme();
        this.cAccountingSys.setInput((Object)accSystems);
        this.cAccountingSys.setSelection((ISelection)new StructuredSelection((Object)accSystems[0]));
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 258).setLayoutData((Object)SWTHelper.getFillGridData(4, true, 1, false));
        this.cbSkip = new Button(ret, 32);
        this.cbSkip.setText(SKIPSELECTION);
        this.cbSkip.setSelection(ConfigServiceHolder.getGlobal((String)CFG_SKIP, (boolean)false));
        this.cbBefore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KonsZumVerrechnenWizardDialog.this.ddc1.setEnabled(KonsZumVerrechnenWizardDialog.this.cbBefore.getSelection());
            }
        });
        this.cbTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KonsZumVerrechnenWizardDialog.this.ddc2.setEnabled(KonsZumVerrechnenWizardDialog.this.cbTime.getSelection());
            }
        });
        this.cAccountingSys.getCombo().setEnabled(false);
        this.timespanFrom.setEnabled(false);
        this.timespanTo.setEnabled(false);
        this.ddc1.setEnabled(false);
        this.ddc2.setEnabled(false);
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(RECHNUNGS_AUTOMATIK);
        this.setMessage(BEHANDLUNGEN_ZUM_VERRECHNEN_AUTOMATISCH_AUSWAEHLEN);
        this.getShell().setText(RECHNUNGEN_ERSTELLEN);
    }

    protected void okPressed() {
        if (this.cbBefore.getSelection()) {
            this.ttFirstBefore = this.ddc1.getDate();
        }
        if (this.cbTime.getSelection()) {
            this.ttLastBefore = this.ddc2.getDate();
        }
        if (this.cbAmount.getSelection()) {
            this.mAmount = this.mi1.getMoney(false);
        }
        if (this.cbTimespan.getSelection()) {
            this.ttFrom = this.getDate(this.timespanFrom, 0, 0, 0);
            this.ttTo = this.getDate(this.timespanTo, 23, 59, 59);
        }
        if (this.cbAccountingSys.getSelection()) {
            IStructuredSelection sel = (IStructuredSelection)this.cAccountingSys.getSelection();
            this.accountSys = (String)sel.getFirstElement();
        }
        this.bQuartal = this.cbQuartal.getSelection();
        this.bMarked = this.cbMarked.getSelection();
        this.bSkip = this.cbSkip.getSelection();
        ConfigServiceHolder.setGlobal((String)CFG_SKIP, (boolean)this.bSkip);
        super.okPressed();
    }

    private TimeTool getDate(DateTime selDate, int hour, int minute, int second) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.set(5, selDate.getDay());
        cal.set(2, selDate.getMonth());
        cal.set(1, selDate.getYear());
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        TimeTool date = new TimeTool(cal.getTime());
        return date;
    }

    protected boolean isResizable() {
        return true;
    }
}

