/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.v2x;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.AD;
import ca.uhn.hl7v2.model.v21.datatype.CE;
import ca.uhn.hl7v2.model.v21.datatype.CN;
import ca.uhn.hl7v2.model.v21.datatype.FT;
import ca.uhn.hl7v2.model.v21.datatype.NM;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TX;
import ca.uhn.hl7v2.model.v21.group.ORU_R01_OBSERVATION;
import ca.uhn.hl7v2.model.v21.group.ORU_R01_ORDER_OBSERVATION;
import ca.uhn.hl7v2.model.v21.group.ORU_R01_PATIENT;
import ca.uhn.hl7v2.model.v21.group.ORU_R01_PATIENT_RESULT;
import ca.uhn.hl7v2.model.v21.message.ORU_R01;
import ca.uhn.hl7v2.model.v21.segment.MSH;
import ca.uhn.hl7v2.model.v21.segment.NTE;
import ca.uhn.hl7v2.model.v21.segment.OBR;
import ca.uhn.hl7v2.model.v21.segment.OBX;
import ca.uhn.hl7v2.model.v21.segment.ORC;
import ca.uhn.hl7v2.model.v21.segment.PID;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.types.Country;
import ch.elexis.core.types.Gender;
import ch.elexis.hl7.HL7PatientResolver;
import ch.elexis.hl7.HL7Reader;
import ch.elexis.hl7.model.LabResultData;
import ch.elexis.hl7.model.ObservationMessage;
import ch.elexis.hl7.model.OrcMessage;
import ch.elexis.hl7.model.TextData;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7ReaderV21
extends HL7Reader {
    static Logger logger = LoggerFactory.getLogger(HL7ReaderV21.class);

    public HL7ReaderV21(Message message) {
        super(message);
    }

    @Override
    public String getSender() throws ElexisException {
        String sender;
        try {
            MSH msh = (MSH)this.message.get("MSH");
            sender = msh.getMsh4_SENDINGFACILITY().getValue();
            if (sender == null) {
                sender = "";
            }
        }
        catch (HL7Exception e) {
            throw new ElexisException(e.getMessage(), (Throwable)e);
        }
        return sender;
    }

    @Override
    public ObservationMessage readObservation(HL7PatientResolver patientResolver, boolean createIfNotFound) throws ElexisException {
        this.observation = null;
        ORU_R01 oru = (ORU_R01)this.message;
        try {
            this.patientResolver = patientResolver;
            this.setPatient(oru, createIfNotFound);
            int obsCount = oru.getPATIENT_RESULT().getORDER_OBSERVATIONReps();
            int idx = 0;
            while (idx < obsCount) {
                OBR obr = oru.getPATIENT_RESULT().getORDER_OBSERVATION(idx).getOBR();
                String obrObservationDateTime = obr.getObr7_OBSERVATIONDATETIME().getValue();
                this.setOrderComment(oru, idx, obrObservationDateTime);
                int i = 0;
                while (i < oru.getPATIENT_RESULT().getORDER_OBSERVATION(idx).getOBSERVATIONReps()) {
                    ORU_R01_ORDER_OBSERVATION obs = oru.getPATIENT_RESULT().getORDER_OBSERVATION(idx);
                    String commentNTE = this.getComments(obs, i);
                    String group = "";
                    String sequence = "";
                    int k = 0;
                    while (k < 2) {
                        CE ce = obr.getObr4_UNIVERSALSERVICEIDENT();
                        if (ce != null) {
                            String code = "";
                            if (ce.getCe3_NameOfCodingSystem() != null) {
                                code = ce.getCe3_NameOfCodingSystem().getValue();
                            }
                            group = this.getGroup(code, ce);
                            sequence = this.getSequence(code, ce);
                        }
                        ++k;
                    }
                    this.readOBXResults(obs.getOBSERVATION(i), commentNTE, group, sequence, obrObservationDateTime);
                    ++i;
                }
                ++idx;
            }
        }
        catch (HL7Exception | ParseException e) {
            throw new ElexisException(e.getMessage(), e);
        }
        return this.observation;
    }

    private String getGroup(String code, CE ce) {
        if ("99DGC".equalsIgnoreCase(code) && ce.getCe2_Text() != null) {
            return ce.getCe2_Text().getValue();
        }
        return "";
    }

    private String getSequence(String code, CE ce) {
        if ("99DGP".equalsIgnoreCase(code) && ce.getCe1_Identifier() != null) {
            return ce.getCe1_Identifier().getValue();
        }
        return "";
    }

    private void setPatient(ORU_R01 oru, boolean createIfNotFound) throws ParseException, HL7Exception {
        List<Object> list = new ArrayList();
        String lastName = "";
        String firstName = "";
        String birthDate = "";
        String sex = Gender.FEMALE.value();
        this.pat = null;
        if (this.pat == null) {
            String sendingApplication = oru.getMSH().getMsh3_SENDINGAPPLICATION().getValue();
            String sendingFacility = oru.getMSH().getMsh4_SENDINGFACILITY().getValue();
            String dateTimeOfMessage = oru.getMSH().getMsh7_DATETIMEOFMESSAGE().getValue();
            PID pid = oru.getPATIENT_RESULT().getPATIENT().getPID();
            String patid = pid.getPid3_PATIENTIDINTERNALINTERNALID().getCk1_IDNumber().getValue();
            String patid_alternative = pid.getPid4_ALTERNATEPATIENTID().getValue();
            if (StringTool.isNothing((Object)patid) && StringTool.isNothing((Object)(patid = pid.getPid2_PATIENTIDEXTERNALEXTERNALID().getCk1_IDNumber().getValue())) && (patid = patid_alternative) == null) {
                patid = "";
            }
            if (patid != null) {
                list = this.patientResolver.getPatientById(patid);
            }
            String orderNumber = oru.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getOrc2_PLACERORDER().getComponent(0).toString();
            if (pid.getPid5_PATIENTNAME().getPn1_FamilyName().getValue() != null) {
                lastName = pid.getPid5_PATIENTNAME().getPn1_FamilyName().getValue();
            }
            if (pid.getPid5_PATIENTNAME().getPn2_GivenName().getValue() != null) {
                firstName = pid.getPid5_PATIENTNAME().getGivenName().getValue();
            }
            String patientName = String.valueOf(firstName) + " " + lastName;
            String patientNotesAndComments = this.readPatientNotesAndComments(oru.getPATIENT_RESULT().getPATIENT());
            this.observation = new ObservationMessage(sendingApplication, sendingFacility, dateTimeOfMessage, patid, patientName, patientNotesAndComments, patid_alternative, orderNumber);
            birthDate = pid.getPid7_DATEOFBIRTH().getValue();
            sex = pid.getPid8_SEX().getValue();
            if (patid == null || list.size() != 1) {
                list = this.patientResolver.findPatientByNameAndBirthdate(StringTool.normalizeCase((String)lastName), StringTool.normalizeCase((String)firstName), new TimeTool(birthDate).toString(9));
                if (list != null && list.size() == 1) {
                    this.pat = (IPatient)list.get(0);
                } else if (createIfNotFound) {
                    String phone = "";
                    AD adr = pid.getPid11_PATIENTADDRESS();
                    phone = pid.getPid13_PHONENUMBERHOME(0).getValue();
                    this.pat = this.patientResolver.createPatient(lastName, firstName, birthDate, sex);
                    this.pat.setPatientNr(patid);
                    if (adr.getAd1_StreetAddress().getValue() != null) {
                        this.pat.setStreet(adr.getAd1_StreetAddress().getValue());
                    }
                    if (adr.getAd5_Zip().getValue() != null) {
                        this.pat.setZip(adr.getAd5_Zip().getValue());
                    }
                    if (adr.getAd3_City().getValue() != null) {
                        this.pat.setCity(adr.getAd3_City().getValue());
                    }
                    if (adr.getAd6_Country().getValue() != null) {
                        Country country = Country.fromValue((String)adr.getAd6_Country().getValue());
                        this.pat.setCountry(Country.valueOf((String)country.name()));
                    }
                    this.pat.setPhone1(phone);
                } else {
                    this.resolvePatient(firstName, lastName, birthDate);
                }
            } else {
                this.pat = (IPatient)list.get(0);
                if (lastName.length() != 0 && firstName.length() != 0) {
                    this.checkConflict(firstName, lastName, birthDate, sex);
                }
            }
        }
    }

    private String readPatientNotesAndComments(ORU_R01_PATIENT oru_R01_PATIENT) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < oru_R01_PATIENT.getNTEReps()) {
            TX comment = oru_R01_PATIENT.getNTE(i).getCOMMENT(0);
            sb.append(comment.toString());
            if (oru_R01_PATIENT.getNTEReps() > i) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    private void setOrderComment(ORU_R01 oru, int idx, String obsDate) throws ParseException {
        String orderCommentNTE = this.getComments(oru.getPATIENT_RESULT().getORDER_OBSERVATION(idx), -1);
        if (orderCommentNTE != null) {
            this.observation.add(new TextData("Kommentar", orderCommentNTE, obsDate, "00 Kommentar", null));
        }
    }

    private String getComments(ORU_R01_ORDER_OBSERVATION oobs, int i) {
        String commentNTE = null;
        int size = oobs.getNTEReps();
        if (i > -1) {
            size = oobs.getOBSERVATION(i).getNTEReps();
        }
        int n = 0;
        while (n < size) {
            TX comment;
            NTE nte = oobs.getNTE(n);
            if (i > -1) {
                nte = oobs.getOBSERVATION(i).getNTE(n);
            }
            if ((comment = nte.getNte3_COMMENT(0)) != null) {
                commentNTE = commentNTE != null ? String.valueOf(commentNTE) + "\n" : "";
                if (comment.getValue() != null) {
                    commentNTE = String.valueOf(commentNTE) + comment.getValue();
                }
            }
            ++n;
        }
        return commentNTE;
    }

    private void readOBXResults(ORU_R01_OBSERVATION obs, String commentNTE, String group, String sequence, String defaultDateTime) throws ParseException {
        OBX obx = obs.getOBX();
        String valueType = obx.getObx2_VALUETYPE().getValue();
        String name = "";
        String itemCode = "";
        String unit = "";
        String range = "";
        String observationTime = "";
        String status = "";
        if (this.isTextOrNumeric(valueType)) {
            name = obx.getObx4_OBSERVATIONSUBID().getValue();
            if (name == null && (name = obx.getObx3_OBSERVATIONIDENTIFIER().getCe2_Text().getValue()) == null) {
                name = obx.getObx3_OBSERVATIONIDENTIFIER().getCe1_Identifier().getValue();
            }
            String value = "";
            Type tmp = obx.getObx5_OBSERVATIONRESULTS().getData();
            if (tmp instanceof ST) {
                value = ((ST)tmp).getValue();
            } else if (tmp instanceof TX) {
                value = ((TX)tmp).getValue();
                if (value.contains("\\.br")) {
                    value = this.parseTextValue(value);
                }
            } else if (tmp instanceof FT) {
                value = this.parseFormattedTextValue(((FT)tmp).getValue());
            } else if (tmp instanceof NM) {
                value = ((NM)tmp).getValue();
            } else if (tmp instanceof CE) {
                value = ((CE)tmp).getCe2_Text().getValue();
            }
            itemCode = obx.getObx3_OBSERVATIONIDENTIFIER().getCe1_Identifier().getValue();
            unit = obx.getObx6_UNITS().getValue();
            range = obx.getObx7_REFERENCESRANGE().getValue();
            String rawAbnormalFlag = obx.getObx8_ABNORMALFLAGS(0).getValue();
            Boolean flag = this.isPathologic(obx.getObx8_ABNORMALFLAGS(0).getValue());
            observationTime = defaultDateTime;
            status = obx.getObx11_OBSERVRESULTSTATUS().getValue();
            LabResultData lrd = new LabResultData(itemCode, name, unit, value, range, flag, rawAbnormalFlag, defaultDateTime, observationTime, commentNTE, group, sequence, status, this.extractName((Primitive)obx.getObx4_OBSERVATIONSUBID()));
            if (valueType.equals("NM")) {
                lrd.setIsNumeric(true);
            } else if (valueType.equals("TX")) {
                lrd.setIsPlainText(true);
            } else if (valueType.equals("FT")) {
                lrd.setIsFormatedText(true);
            }
            this.observation.add(lrd);
        } else {
            logger.error(MessageFormat.format("Value type {0} is not implemented!", valueType));
        }
    }

    @Override
    public OrcMessage getOrcMessage() {
        try {
            ORU_R01_ORDER_OBSERVATION oo;
            ORU_R01_PATIENT_RESULT pr;
            ORU_R01 oru = (ORU_R01)this.message;
            if (oru != null && (pr = oru.getPATIENT_RESULT()) != null && (oo = pr.getORDER_OBSERVATION()) != null) {
                return this.extractOrc(oo.getORC());
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(HL7Reader.class).warn("orc parsing failed", (Throwable)e);
        }
        return null;
    }

    private OrcMessage extractOrc(ORC orc) throws HL7Exception {
        if (orc != null) {
            OrcMessage orcMessage = new OrcMessage();
            CN ops = orc.getORDERINGPROVIDER();
            this.addNameValuesToOrcMessage((Primitive)ops.getFamilyName(), (Primitive)ops.getGivenName(), orcMessage);
            return orcMessage;
        }
        return null;
    }
}

