/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.IContactHelper;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.services.IXidService;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class OrganizationKontaktTransformer
implements IFhirTransformer<Organization, IOrganization> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IXidService xidService;
    @Reference
    private IUserService userService;
    private IContactHelper contactHelper;

    @Activate
    public void activate() {
        this.contactHelper = new IContactHelper(this.modelService, this.xidService, this.userService);
    }

    @Override
    public Optional<Organization> getFhirObject(IOrganization localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Organization organization = new Organization();
        organization.setId((IIdType)new IdDt("Organization", localObject.getId()));
        List<Identifier> identifiers = this.contactHelper.getIdentifiers((IContact)localObject);
        identifiers.add(this.getElexisObjectIdentifier((Identifiable)localObject));
        organization.setIdentifier(identifiers);
        organization.setName(this.contactHelper.getOrganizationName(localObject));
        List<Address> addresses = this.contactHelper.getAddresses((IContact)localObject);
        for (Address address : addresses) {
            organization.addAddress(address);
        }
        List<ContactPoint> contactPoints = this.contactHelper.getContactPoints((IContact)localObject);
        for (ContactPoint contactPoint : contactPoints) {
            organization.addTelecom(contactPoint);
        }
        return Optional.of(organization);
    }

    @Override
    public Optional<IOrganization> getLocalObject(Organization fhirObject) {
        return null;
    }

    @Override
    public Optional<IOrganization> updateLocalObject(Organization fhirObject, IOrganization localObject) {
        return null;
    }

    @Override
    public Optional<IOrganization> createLocalObject(Organization fhirObject) {
        return null;
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Organization.class.equals(fhirClazz) && IOrganization.class.equals(localClazz);
    }
}

