/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLTool {
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public static List<String> validateSchema(String schemaUrl, Source source) {
        MyErrorHandler errorHandler = new MyErrorHandler();
        try {
            SchemaFactory factory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
            Schema schema = factory.newSchema();
            if (schemaUrl != null) {
                File schemaLocation = new File(schemaUrl);
                schema = factory.newSchema(schemaLocation);
            }
            Validator validator = schema.newValidator();
            validator.setErrorHandler(errorHandler);
            validator.validate(source);
        }
        catch (Exception ex) {
            errorHandler.exception(ex);
        }
        return errorHandler.getMessageList();
    }

    public static String moneyToXmlDouble(Money money) {
        int cents = money.getCents();
        int absCents = Math.abs(cents);
        int signum = Integer.signum(cents);
        int abs = absCents / 100;
        int frac = absCents % 100;
        String xmlDouble = String.format("%d.%02d", signum * abs, frac);
        return xmlDouble;
    }

    public static Money xmlDoubleToMoney(String xmlDouble) throws NumberFormatException {
        if (xmlDouble == null) {
            throw new NumberFormatException("xmlDouble must not be null");
        }
        Double d = Double.parseDouble(xmlDouble);
        return new Money(d);
    }

    public static String doubleToXmlDouble(double value, int factionalDigits) {
        long cents = Math.round(value * 100.0);
        int absCents = Math.abs((int)cents);
        int signum = Integer.signum((int)cents);
        int abs = absCents / 100;
        int frac = absCents % 100;
        String dec = "%d.%0" + Integer.toString(factionalDigits) + "d";
        if (abs == 0 && signum < 0) {
            dec = "-" + dec;
        }
        String xmlDouble = String.format(dec, signum * abs, frac);
        return xmlDouble;
    }

    public static String XMLTableToCSVTable(Element table, String separator) {
        List rows = table.getChildren();
        StringBuilder ret = new StringBuilder();
        for (Element row : rows) {
            List cols = row.getChildren();
            for (Element col : cols) {
                ret.append(col.getText()).append(separator);
            }
            ret.replace(ret.length() - separator.length(), ret.length(), "\n");
        }
        return ret.toString();
    }

    public static String XMLTableToHTMLTable(Element table) {
        List rows = table.getChildren();
        StringBuilder ret = new StringBuilder();
        ret.append("<table>");
        for (Element row : rows) {
            ret.append("<tr>");
            List cols = row.getChildren();
            for (Element col : cols) {
                ret.append("<td>").append(col.getText()).append("</td>");
            }
            ret.append("</tr>");
        }
        ret.append("</table>");
        return ret.toString();
    }

    public static String idToXMLID(String id) {
        if (id != null && id.matches("[0-9].+")) {
            return "x" + id;
        }
        return id;
    }

    public static String xmlIDtoID(String xmlid) {
        if (xmlid != null && xmlid.startsWith("x")) {
            return xmlid.substring(1);
        }
        return xmlid;
    }

    public static String dateTimeToXmlDateTime(String dateTime) {
        TimeTool tt = new TimeTool(dateTime);
        return tt.toString(14);
    }

    public static String dateToXmlDate(String date) {
        return new TimeTool(date).toString(6);
    }

    public static HashMap<String, Object> XMLToHashMap(Element elem) {
        HashMap ret = new HashMap();
        List vars = elem.getChildren();
        for (Element var : vars) {
            String string = var.getName();
        }
        return null;
    }

    public static boolean writeXMLDocument(Document doc, String dest) {
        try {
            FileOutputStream fout = new FileOutputStream(dest);
            OutputStreamWriter cout = new OutputStreamWriter((OutputStream)fout, "UTF-8");
            XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
            xout.output(doc, (Writer)cout);
            cout.close();
            fout.close();
            return true;
        }
        catch (Exception e) {
            ExHandler.handle(e);
            return false;
        }
    }

    public static String getValidXMLString(String source) {
        StringBuilder ret = new StringBuilder();
        int i = 0;
        int len = source.length();
        while (i < len) {
            if (Verifier.isXMLCharacter((int)source.charAt(i))) {
                ret.append(source.charAt(i));
            }
            ++i;
        }
        return ret.toString();
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        public List<Exception> exceptions = new Vector<Exception>();

        private MyErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.exceptions.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.exceptions.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        public void exception(Exception exception) {
        }

        public List<String> getMessageList() {
            Vector<String> messageList = new Vector<String>();
            for (Exception ex : this.exceptions) {
                String msg2 = ex.getMessage();
                if (msg2 == null || msg2.length() == 0) {
                    msg2 = ex.toString();
                }
                messageList.add(msg2);
            }
            return messageList;
        }
    }
}

