/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.composites;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.ui.composites.CodingListComposite;
import ch.elexis.core.findings.ui.composites.NoteListComposite;
import ch.elexis.core.findings.ui.model.ConditionBeanAdapter;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.ui.util.FilterNonPrintableModifyListener;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class ConditionComposite
extends Composite {
    private ICondition.ConditionCategory category;
    private Optional<ICondition> condition;
    private WritableValue<ConditionBeanAdapter> conditionValue;
    private ComboViewer statusViewer;
    private TabFolder textOrCodingFolder;
    private Text startTxt;
    private Text endTxt;
    private Text textTxt;
    private CodingListComposite codingComposite;
    private NoteListComposite notesComposite;

    public ConditionComposite(ICondition.ConditionCategory category, Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.category = category;
        this.condition = Optional.empty();
        this.statusViewer = new ComboViewer((Composite)this);
        this.statusViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.statusViewer.setInput((Object)ICondition.ConditionStatus.values());
        this.statusViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICondition.ConditionStatus) {
                    return ((ICondition.ConditionStatus)element).getLocalized();
                }
                return super.getText(element);
            }
        });
        this.startTxt = new Text((Composite)this, 2048);
        this.startTxt.setLayoutData((Object)new GridData(768));
        this.startTxt.setMessage("Beginn Datum oder Beschreibung");
        this.endTxt = new Text((Composite)this, 2048);
        this.endTxt.setLayoutData((Object)new GridData(768));
        this.endTxt.setMessage("Ende Datum oder Beschreibung");
        this.textOrCodingFolder = new TabFolder((Composite)this, 0);
        TabItem textItem = new TabItem(this.textOrCodingFolder, 0, 0);
        textItem.setText("Text");
        this.textTxt = new Text((Composite)this.textOrCodingFolder, 2626);
        textItem.setControl((Control)this.textTxt);
        FilterNonPrintableModifyListener.addTo((Text)this.textTxt);
        TabItem codingItem = new TabItem(this.textOrCodingFolder, 0, 1);
        codingItem.setText("Kodierung");
        this.codingComposite = new CodingListComposite((Composite)this.textOrCodingFolder, 0);
        this.codingComposite.setLayoutData(new GridData(768));
        codingItem.setControl((Control)this.codingComposite);
        GridData folderGd = new GridData(1808);
        this.textOrCodingFolder.setLayoutData((Object)folderGd);
        this.notesComposite = new NoteListComposite(this, 0);
        this.notesComposite.showTitle(true);
        this.notesComposite.setLayoutData(new GridData(768));
        this.initDataBinding();
    }

    private void initDataBinding() {
        this.conditionValue = new WritableValue();
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue targetObservable = ViewersObservables.observeSingleSelection((Viewer)this.statusViewer);
        IObservableValue modelObservable = PojoObservables.observeDetailValue(this.conditionValue, (String)"status", ICondition.ConditionStatus.class);
        bindingContext.bindValue((IObservableValue)targetObservable, modelObservable);
        targetObservable = SWTObservables.observeText((Control)this.startTxt, (int)24);
        modelObservable = PojoObservables.observeDetailValue(this.conditionValue, (String)"start", String.class);
        bindingContext.bindValue((IObservableValue)targetObservable, modelObservable);
        targetObservable = SWTObservables.observeText((Control)this.endTxt, (int)24);
        modelObservable = PojoObservables.observeDetailValue(this.conditionValue, (String)"end", String.class);
        bindingContext.bindValue((IObservableValue)targetObservable, modelObservable);
        targetObservable = SWTObservables.observeText((Control)this.textTxt, (int)24);
        modelObservable = PojoObservables.observeDetailValue(this.conditionValue, (String)"text", String.class);
        bindingContext.bindValue((IObservableValue)targetObservable, modelObservable);
        this.setCondition(null);
    }

    public Optional<ICondition> getCondition() {
        return this.condition;
    }

    public void setCondition(ICondition condition) {
        this.condition = Optional.ofNullable(condition);
        if (this.condition.isPresent()) {
            condition.setCategory(this.category);
            this.conditionValue.setValue((Object)new ConditionBeanAdapter(condition));
            List coding = this.condition.get().getCoding();
            if (coding != null && !coding.isEmpty()) {
                this.textOrCodingFolder.setSelection(1);
            }
        } else {
            ICondition emptyCondition = (ICondition)FindingsServiceComponent.getService().create(ICondition.class);
            emptyCondition.setStatus(ICondition.ConditionStatus.ACTIVE);
            emptyCondition.setDateRecorded(LocalDate.now());
            emptyCondition.setCategory(this.category);
            this.conditionValue.setValue((Object)new ConditionBeanAdapter(emptyCondition));
            this.condition = Optional.of(emptyCondition);
        }
        this.notesComposite.setInput(new NoteListComposite.NotesAdapter(){

            @Override
            public void removeNote(String note) {
                if (ConditionComposite.this.conditionValue.getValue() != null) {
                    ((ConditionBeanAdapter)ConditionComposite.this.conditionValue.getValue()).removeNote(note);
                }
            }

            @Override
            public List<String> getNotes() {
                if (ConditionComposite.this.conditionValue.getValue() != null) {
                    return ((ConditionBeanAdapter)ConditionComposite.this.conditionValue.getValue()).getNotes();
                }
                return Collections.emptyList();
            }

            @Override
            public void addNote(String note) {
                if (ConditionComposite.this.conditionValue.getValue() != null) {
                    ((ConditionBeanAdapter)ConditionComposite.this.conditionValue.getValue()).addNote(note);
                }
            }
        });
        this.codingComposite.setInput(new CodingListComposite.CodingAdapter(){

            @Override
            public List<ICoding> getCoding() {
                if (ConditionComposite.this.conditionValue.getValue() != null) {
                    return ((ConditionBeanAdapter)ConditionComposite.this.conditionValue.getValue()).getCoding();
                }
                return Collections.emptyList();
            }

            @Override
            public void setCoding(List<ICoding> coding) {
                if (ConditionComposite.this.conditionValue.getValue() != null) {
                    ((ConditionBeanAdapter)ConditionComposite.this.conditionValue.getValue()).setCoding(coding);
                }
            }
        });
    }
}

