/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.Diagnosis;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IDiagnosisReference;
import ch.elexis.core.model.IdentifiableWithXid;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DiagnosisReference
extends AbstractIdDeleteModelAdapter<Diagnosis>
implements IdentifiableWithXid,
IDiagnosisReference {
    private static Map<String, String> codeSystemClassMap = new HashMap<String, String>();

    public DiagnosisReference(Diagnosis entity) {
        super((EntityWithId)entity);
        codeSystemClassMap.put("ch.elexis.data.TICode", "TI-Code");
        codeSystemClassMap.put("ch.elexis.icpc.IcpcCode", "ICPC");
        codeSystemClassMap.put("ch.elexis.data.ICD10", "ICD-10");
        codeSystemClassMap.put("ch.elexis.data.FreeTextDiagnose", "freetext");
    }

    public String getCode() {
        return ((Diagnosis)this.getEntity()).getCode();
    }

    public void setCode(String value) {
        ((Diagnosis)this.getEntityMarkDirty()).setCode(value);
    }

    public String getText() {
        return ((Diagnosis)this.getEntity()).getText();
    }

    public void setText(String value) {
        ((Diagnosis)this.getEntityMarkDirty()).setText(value);
    }

    public String getDescription() {
        return "";
    }

    public void setDescription(String value) {
    }

    public String getReferredClass() {
        return ((Diagnosis)this.getEntity()).getDiagnosisClass();
    }

    public void setReferredClass(String value) {
        ((Diagnosis)this.getEntityMarkDirty()).setDiagnosisClass(value);
    }

    public String getCodeSystemName() {
        String referredClass = this.getReferredClass();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referredClass})) {
            String codeSystem = codeSystemClassMap.get(referredClass);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{codeSystem})) {
                return codeSystem;
            }
        }
        return null;
    }

    public String getLabel() {
        return String.valueOf(this.getCode()) + " " + this.getText();
    }
}

