/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.cef.CefClient;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserSwing;
import org.cef.browser.CefBrowserWindow;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefRequestContext;
import org.cef.handler.CefWindowHandler;
import org.cef.handler.CefWindowHandlerAdapter;
import org.cef.misc.Point;
import org.cef.misc.Rectangle;

class CefBrowserWr
extends CefBrowserSwing {
    private Canvas canvas_ = null;
    private Component component_ = null;
    private java.awt.Rectangle content_rect_ = new java.awt.Rectangle(0, 0, 0, 0);
    private long window_handle_ = 0L;
    private boolean justCreated_ = false;
    private double scaleFactor_ = 1.0;
    private Timer delayedUpdate_ = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CefBrowserWr.this.isClosed()) {
                        return;
                    }
                    boolean hasCreatedUI = CefBrowserWr.this.createBrowserIfRequired(true);
                    if (hasCreatedUI) {
                        CefBrowserWr.this.delayedUpdate_.restart();
                    } else if (OS.isMacintosh() || OS.isLinux()) {
                        CefBrowserWr.this.doUpdate();
                    }
                }
            });
        }
    });
    private CefWindowHandlerAdapter win_handler_ = new CefWindowHandlerAdapter(){
        private Point lastPos = new Point(-1, -1);
        private long[] nextClick = new long[MouseInfo.getNumberOfButtons()];
        private int[] clickCnt = new int[MouseInfo.getNumberOfButtons()];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Rectangle getRect(CefBrowser browser) {
            java.awt.Rectangle rectangle = CefBrowserWr.this.content_rect_;
            synchronized (rectangle) {
                return new Rectangle(CefBrowserWr.this.content_rect_);
            }
        }

        @Override
        public void onMouseEvent(CefBrowser browser, int event, final int screenX, final int screenY, final int modifier, final int button) {
            final Point pt = new Point(screenX, screenY);
            if (event == 503) {
                if (pt.equals(this.lastPos)) {
                    return;
                }
                this.lastPos = pt;
                if ((modifier & 0x400) != 0) {
                    event = 506;
                }
            }
            final int finalEvent = event;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Component parent = SwingUtilities.getRoot(CefBrowserWr.this.component_);
                    if (parent == null) {
                        return;
                    }
                    SwingUtilities.convertPointFromScreen(new java.awt.Point(pt.x, pt.y), parent);
                    int clickCnt = 0;
                    long now = new Date().getTime();
                    if (finalEvent == 507) {
                        int scrollType = 0;
                        int rotation = button > 0 ? 1 : -1;
                        CefBrowserWr.this.component_.dispatchEvent(new MouseWheelEvent(parent, finalEvent, now, modifier, pt.x, pt.y, 0, false, scrollType, 3, rotation));
                    } else {
                        clickCnt = this.getClickCount(finalEvent, button);
                        CefBrowserWr.this.component_.dispatchEvent(new MouseEvent(parent, finalEvent, now, modifier, pt.x, pt.y, screenX, screenY, clickCnt, false, button));
                    }
                    if (finalEvent == 502) {
                        CefBrowserWr.this.component_.dispatchEvent(new MouseEvent(parent, 500, now, modifier, pt.x, pt.y, screenX, screenY, clickCnt, false, button));
                    }
                }
            });
        }

        public int getClickCount(int event, int button) {
            int idx = button % this.nextClick.length;
            switch (event) {
                case 501: {
                    long currTime = new Date().getTime();
                    if (currTime > this.nextClick[idx]) {
                        this.nextClick[idx] = currTime + (long)((Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval")).intValue();
                        this.clickCnt[idx] = 1;
                    } else {
                        int n = idx;
                        this.clickCnt[n] = this.clickCnt[n] + 1;
                    }
                }
                case 502: {
                    return this.clickCnt[idx];
                }
            }
            return 0;
        }
    };

    CefBrowserWr(CefClient client, String url, CefRequestContext context) {
        this(client, url, context, null, null);
    }

    private CefBrowserWr(CefClient client, String url, CefRequestContext context, CefBrowserWr parent, Point inspectAt) {
        super(client, url, context, parent, inspectAt);
        this.delayedUpdate_.setRepeats(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.component_ = new JPanel(new BorderLayout()){
            private boolean removed_;
            {
                this.removed_ = true;
            }

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                CefBrowserWr.this.wasResized((int)((double)width * CefBrowserWr.this.scaleFactor_), (int)((double)height * CefBrowserWr.this.scaleFactor_));
            }

            @Override
            public void setBounds(java.awt.Rectangle r) {
                this.setBounds(r.x, r.y, r.width, r.height);
            }

            @Override
            public void setSize(int width, int height) {
                super.setSize(width, height);
                CefBrowserWr.this.wasResized((int)((double)width * CefBrowserWr.this.scaleFactor_), (int)((double)height * CefBrowserWr.this.scaleFactor_));
            }

            @Override
            public void setSize(Dimension d) {
                this.setSize(d.width, d.height);
            }

            @Override
            public void paint(Graphics g) {
                if (g instanceof Graphics2D) {
                    CefBrowserWr.this.scaleFactor_ = ((Graphics2D)g).getTransform().getScaleX();
                }
                CefBrowserWr.this.doUpdate();
                CefBrowserWr.this.delayedUpdate_.restart();
            }

            @Override
            public void addNotify() {
                super.addNotify();
                if (this.removed_) {
                    CefBrowserWr.this.setParent(CefBrowserWr.getWindowHandle(this), CefBrowserWr.this.canvas_);
                    this.removed_ = false;
                }
            }

            @Override
            public void removeNotify() {
                if (!this.removed_) {
                    if (!CefBrowserWr.this.isClosed()) {
                        CefBrowserWr.this.setParent(0L, null);
                    }
                    this.removed_ = true;
                }
                super.removeNotify();
            }
        };
        if (OS.isWindows() || OS.isLinux()) {
            this.canvas_ = new Canvas();
            ((JPanel)this.component_).add((Component)this.canvas_, "Center");
        }
        this.component_.setMinimumSize(new Dimension(0, 0));
        this.component_.setFocusable(true);
        this.component_.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                CefBrowserWr.this.setFocus(false);
            }

            @Override
            public void focusGained(FocusEvent e) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                CefBrowserWr.this.setFocus(true);
            }
        });
        this.component_.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorResized(HierarchyEvent e) {
                CefBrowserWr.this.doUpdate();
            }

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                CefBrowserWr.this.doUpdate();
                CefBrowserWr.this.notifyMoveOrResizeStarted();
            }
        });
        this.component_.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    CefBrowserWr.this.setWindowVisibility(e.getChanged().isVisible());
                }
            }
        });
    }

    @Override
    public void createImmediately() {
        this.justCreated_ = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefBrowserWr.this.createBrowserIfRequired(false);
            }
        });
    }

    public Component getUIComponent() {
        return this.component_;
    }

    @Override
    public CefWindowHandler getWindowHandler() {
        return this.win_handler_;
    }

    @Override
    protected CefBrowser_N createDevToolsBrowser(CefClient client, String url, CefRequestContext context, CefBrowser_N parent, Point inspectAt) {
        return new CefBrowserWr(client, url, context, this, inspectAt);
    }

    private synchronized long getWindowHandle() {
        if (this.window_handle_ == 0L && OS.isMacintosh()) {
            this.window_handle_ = CefBrowserWr.getWindowHandle(this.component_);
        }
        return this.window_handle_;
    }

    private static long getWindowHandle(Component component) {
        if (OS.isMacintosh()) {
            try {
                Class<?> cls = Class.forName("org.cef.browser.mac.CefBrowserWindowMac");
                CefBrowserWindow browserWindow = (CefBrowserWindow)cls.newInstance();
                if (browserWindow != null) {
                    return browserWindow.getWindowHandle(component);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate() {
        if (this.isClosed()) {
            return;
        }
        java.awt.Rectangle vr = ((JPanel)this.component_).getVisibleRect();
        java.awt.Rectangle clipping = new java.awt.Rectangle((int)(vr.getX() * this.scaleFactor_), (int)(vr.getY() * this.scaleFactor_), (int)(vr.getWidth() * this.scaleFactor_), (int)(vr.getHeight() * this.scaleFactor_));
        if (OS.isMacintosh()) {
            Container parent = this.component_.getParent();
            java.awt.Point contentPos = this.component_.getLocation();
            while (parent != null) {
                Container next = parent.getParent();
                if (next != null && next instanceof Window) break;
                java.awt.Point parentPos = parent.getLocation();
                contentPos.translate(parentPos.x, parentPos.y);
                parent = next;
            }
            contentPos.translate(clipping.x, clipping.y);
            java.awt.Point browserPos = clipping.getLocation();
            browserPos.x *= -1;
            browserPos.y *= -1;
            java.awt.Rectangle rectangle = this.content_rect_;
            synchronized (rectangle) {
                this.content_rect_ = new java.awt.Rectangle(contentPos, clipping.getSize());
                java.awt.Rectangle browserRect = new java.awt.Rectangle(browserPos, this.component_.getSize());
                this.updateUI(new Rectangle(this.content_rect_), new Rectangle(browserRect));
            }
        }
        java.awt.Rectangle rectangle = this.content_rect_;
        synchronized (rectangle) {
            java.awt.Rectangle bounds = this.component_.getBounds();
            this.content_rect_ = new java.awt.Rectangle((int)(bounds.getX() * this.scaleFactor_), (int)(bounds.getY() * this.scaleFactor_), (int)(bounds.getWidth() * this.scaleFactor_), (int)(bounds.getHeight() * this.scaleFactor_));
            this.updateUI(new Rectangle(clipping), new Rectangle(this.content_rect_));
        }
    }

    private boolean createBrowserIfRequired(boolean hasParent) {
        if (this.isClosed()) {
            return false;
        }
        long windowHandle = 0L;
        Component canvas = null;
        if (hasParent) {
            windowHandle = this.getWindowHandle();
            Component component = canvas = OS.isWindows() || OS.isLinux() ? this.canvas_ : this.component_;
        }
        if (this.getNativeRef("CefBrowser") == 0L) {
            if (this.getParentBrowser() != null) {
                this.createDevTools(this.getParentBrowser(), this.getClient(), windowHandle, false, false, canvas, this.getInspectAt());
                return true;
            }
            this.createBrowser(this.getClient(), windowHandle, this.getUrl(), false, false, canvas, this.getRequestContext());
            return true;
        }
        if (hasParent && this.justCreated_) {
            this.setParent(windowHandle, canvas);
            this.setFocus(true);
            this.justCreated_ = false;
        }
        return false;
    }

    @Override
    public CompletableFuture<Object> createScreenshot(boolean nativeResolution) {
        throw new UnsupportedOperationException("Unsupported for windowed rendering");
    }
}

