/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class MimeTypeLinux {
    public static String[] getExtensions(Vector<String> mimeTypes) {
        Map<String, Map<String, List<String>>> mimeTable = MimeTypeLinux.getMimeTypesFromSystem();
        ArrayList<String> extensionsArray = new ArrayList<String>();
        Iterator<String> iterator = mimeTypes.iterator();
        while (iterator.hasNext()) {
            String mimeType;
            String fullMimeType;
            String af = fullMimeType = iterator.next();
            if (fullMimeType.startsWith(".")) {
                af = fullMimeType.replaceFirst(".", "*.");
                extensionsArray.add(af);
                continue;
            }
            if (mimeTable.isEmpty() || !mimeTable.containsKey(mimeType = fullMimeType.split("/")[0])) continue;
            Map<String, List<String>> mimeFound = mimeTable.get(mimeType);
            if (fullMimeType.contains("/*")) {
                for (List<String> mimeList : mimeFound.values()) {
                    extensionsArray.addAll(mimeList);
                }
                continue;
            }
            String subMimeType = fullMimeType.split("/")[1];
            if (!mimeFound.containsKey(subMimeType)) continue;
            extensionsArray.addAll((Collection)mimeFound.get(subMimeType));
        }
        extensionsArray.sort(null);
        return extensionsArray.toArray(new String[0]);
    }

    private static Map<String, Map<String, List<String>>> getMimeTypesFromSystem() {
        HashMap<String, Map<String, List<String>>> mimeTable = new HashMap<String, Map<String, List<String>>>();
        try {
            Path path = Paths.get("/usr/share/mime/globs", new String[0]);
            for (String line : Files.readAllLines(path)) {
                String[] lineSplit = line.split(":");
                if (lineSplit.length <= 1) continue;
                String fullMimeType = line.split(":")[0];
                String mimeType = fullMimeType.split("/")[0];
                String subMimeType = fullMimeType.split("/")[1];
                String extension = line.split(":")[1];
                Map mimeAdd = mimeTable.computeIfAbsent(mimeType, m -> new HashMap());
                List extensionAdd = mimeAdd.computeIfAbsent(subMimeType, m -> new ArrayList());
                extensionAdd.add(extension);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mimeTable;
    }
}

