/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Artikel;
import ch.elexis.data.Query;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class FixPharmacodeLessSeven
extends ExternalMaintenance {
    public static final String PHARMACODE_EXTINFO_ID = "Pharmacode";

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringBuilder output = new StringBuilder();
        pm.beginTask("\u00dcberpr\u00fcfe Pharmacode L\u00e4nge", 2);
        pm.subTask("Lese Artikel ein...");
        Query qbe = new Query(Artikel.class);
        qbe.or();
        qbe.add("deleted", "=", "1");
        List qre = qbe.execute();
        pm.worked(1);
        pm.subTask("Korrigiere Eintr\u00e4ge...");
        for (Artikel artikel : qre) {
            String subId = artikel.get("SubID");
            Map articleExtInfo = artikel.getMap("ExtInfo");
            String subIdExtInfo = (String)articleExtInfo.get(PHARMACODE_EXTINFO_ID);
            int subIdLength = subId.length();
            if (subIdLength >= 7 && subIdExtInfo == null || subIdLength >= 7 && subIdExtInfo != null && subIdExtInfo.length() >= 7) continue;
            if (subIdLength == 0) {
                artikel.set("SubID", "0000000");
                output.append("Korrigiere " + artikel.getName() + " von keine subId vorhanden auf 0000000\n");
                articleExtInfo.put(PHARMACODE_EXTINFO_ID, "0000000");
                artikel.setMap("ExtInfo", articleExtInfo);
                continue;
            }
            try {
                int pharmaCode = Integer.parseInt(subId);
                StringBuilder sb = new StringBuilder();
                int missingZeros = 7 - subIdLength;
                while (missingZeros != 0) {
                    sb.append("0");
                    --missingZeros;
                }
                sb.append(subId);
                output.append("Korrigiere " + artikel.getName() + " von " + subId + " auf " + sb.toString() + "\n");
                artikel.set("SubID", sb.toString());
                articleExtInfo.put(PHARMACODE_EXTINFO_ID, sb.toString());
                artikel.setMap("ExtInfo", articleExtInfo);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        output.append(String.valueOf(qre.size()) + " Artikel \u00fcberpr\u00fcft.\n");
        pm.worked(1);
        pm.done();
        return output.toString();
    }

    @Override
    public String getMaintenanceDescription() {
        return "Artikel (auch gel\u00f6schte) mit Pharmacode <7 Zeichen reparieren";
    }
}

