/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck;

import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.JdbcLinkSyntaxException;
import java.sql.Connection;

public abstract class CheckExec {
    public static String MYSQL_DB = "com.mysql.cj.jdbc.Driver";
    public static String POSTG_DB = "org.postgresql.Driver";
    protected static Connection conn;
    protected static JdbcLink j;
    protected static String sqlDriver;
    protected static String sqlConnection;

    public static String getDBInformation() {
        return String.valueOf(sqlDriver) + "@" + sqlConnection;
    }

    public static String checkDBVersionConsistence() {
        String version = CheckExec.getDBVersion();
        if ("3.7.0".equalsIgnoreCase(version)) {
            return version;
        }
        return "Verlangte DB: 3.7.0 Gefundene DB: " + version + "; Teste auf Version " + version;
    }

    public static String getDBVersion() {
        String version = "";
        if (sqlDriver.equalsIgnoreCase(MYSQL_DB)) {
            try {
                version = j.queryString("SELECT wert FROM config WHERE param=\"dbversion\"");
            }
            catch (JdbcLinkSyntaxException e) {
                version = j.queryString("SELECT wert FROM CONFIG WHERE param=\"dbversion\"");
            }
        }
        if (sqlDriver.equalsIgnoreCase(POSTG_DB)) {
            version = j.queryString("SELECT wert FROM CONFIG WHERE param LIKE 'dbversion'");
        }
        return version;
    }

    public static void setJDBCLink(JdbcLink link) {
        j = link;
        sqlDriver = j.getDriverName();
        sqlConnection = j.getConnectString();
    }

    public static void finishJDBCLink() {
        j.disconnect();
    }
}

