/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.handler;

import ch.elexis.core.documents.FilterCategory;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.documents.dialogs.DocumentsSelectionDialog;
import ch.elexis.core.ui.documents.views.DocumentsTreeContentProvider;
import ch.elexis.core.ui.icons.Images;
import ch.rgw.tools.TimeTool;
import java.util.Arrays;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenSelectionHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        DocumentsSelectionDialog dialog = new DocumentsSelectionDialog(activeShell, (ILabelProvider)new SelectionDialogLabelProvider(), new DocumentsTreeContentProvider(null).selectFilterCategory((ISelection)new StructuredSelection((Object)new FilterCategory(null, ""))), 0);
        dialog.setInput(ContextServiceHolder.get().getActivePatient().orElse(null));
        dialog.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ICategory && e2 instanceof ICategory) {
                    String cat1 = ((ICategory)e1).getName();
                    String cat2 = ((ICategory)e2).getName();
                    return cat1.compareToIgnoreCase(cat2);
                }
                IDocument dh1 = (IDocument)e1;
                IDocument dh2 = (IDocument)e2;
                return dh2.getLastchanged().compareTo(dh1.getLastchanged());
            }
        });
        if (dialog.open() == 0) {
            return Arrays.asList(dialog.getResult());
        }
        return null;
    }

    private class SelectionDialogLabelProvider
    extends LabelProvider {
        private SelectionDialogLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ICategory) {
                return Images.IMG_FOLDER.getImage();
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ICategory) {
                return ((ICategory)element).getName();
            }
            if (element instanceof IDocument) {
                IDocument document = (IDocument)element;
                return String.valueOf(new TimeTool(document.getLastchanged()).toString(0)) + ", " + document.getTitle();
            }
            return super.getText(element);
        }
    }
}

