/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class TimeSpan
implements Comparable<TimeSpan> {
    public TimeTool from;
    public TimeTool until;
    public static final int IS_BEFORE_OTHER = 1;
    public static final int IS_AFTER_OTHER = 2;
    public static final int IS_INSIDE_OTHER = 3;
    public static final int IS_AT_BEGIN_OF_OTHER = 4;
    public static final int IS_AT_END_OF_OTHER = 5;
    public static final int IS_OVER_OTHER = 6;
    public static final int IS_ZERO_LENGTH = 7;

    public static String Version() {
        return "1.6.3";
    }

    public TimeSpan(TimeTool v, TimeTool b) {
        this.from = v;
        this.until = b;
    }

    public TimeSpan(TimeTool v, int d) {
        this.from = v;
        this.until = new TimeTool(v);
        this.until.addUnits(d);
    }

    public TimeSpan() {
        this.from = new TimeTool();
        this.until = new TimeTool();
    }

    public TimeSpan(TimeSpan o) {
        this.from = new TimeTool(o.from);
        this.until = new TimeTool(o.until);
    }

    public TimeSpan(String ti) {
        this.set(ti);
    }

    public boolean contains(TimeTool t) {
        if (t.isBefore(this.from)) {
            return false;
        }
        return !t.isAfter(this.until);
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof TimeSpan) {
            TimeSpan o = (TimeSpan)arg0;
            if (this.from.isEqual(o.from) && this.until.isEqual(o.until)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return TimeTool.getTimeInSeconds() - TimeTool.getTimeInSeconds();
    }

    @Override
    public int compareTo(TimeSpan other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.from.isEqual(other.from)) {
            if (this.until.isBefore(other.until)) {
                return -1;
            }
            return 1;
        }
        if (this.from.isBefore(other.from)) {
            return -1;
        }
        return 1;
    }

    public int getSeconds() {
        return this.from.secondsTo(this.until);
    }

    public TimeSpan overlap(TimeSpan other) {
        if (this.getSeconds() == 0 || other.getSeconds() == 0) {
            return null;
        }
        if (other.until.isBeforeOrEqual(this.from)) {
            return null;
        }
        if (other.from.isAfterOrEqual(this.until)) {
            return null;
        }
        if (other.from.isBeforeOrEqual(this.from)) {
            if (other.until.isAfterOrEqual(this.until)) {
                return new TimeSpan(this.from, this.until);
            }
            return new TimeSpan(this.from, other.until);
        }
        if (other.until.isBeforeOrEqual(this.until)) {
            return new TimeSpan(other.from, other.until);
        }
        return new TimeSpan(other.from, this.until);
    }

    public int positionTo(TimeSpan other) {
        if (this.getSeconds() == 0 || other.getSeconds() == 0) {
            return 7;
        }
        if (this.from.isBeforeOrEqual(other.from)) {
            if (this.until.isBeforeOrEqual(other.from)) {
                return 1;
            }
            if (this.until.isAfterOrEqual(other.until)) {
                return 6;
            }
            return 4;
        }
        if (this.until.isBeforeOrEqual(other.until)) {
            return 3;
        }
        if (this.from.isAfterOrEqual(other.until)) {
            return 2;
        }
        return 5;
    }

    public boolean set(String ti) {
        String[] vb = ti.split("-");
        if (vb.length == 2) {
            this.from = new TimeTool(vb[0]);
            this.until = new TimeTool(vb[1]);
            return true;
        }
        if (vb[0].length() == 8) {
            this.from = new TimeTool(vb[0].substring(0, 4));
            this.until = new TimeTool(vb[0].substring(4));
            return true;
        }
        if (vb[0].length() == 20) {
            try {
                this.from = new TimeTool(Long.parseLong(vb[0].substring(0, 10), 16));
                this.until = new TimeTool(Long.parseLong(vb[0].substring(10), 16));
            }
            catch (Exception ex) {
                ExHandler.handle(ex);
                return false;
            }
            return true;
        }
        return false;
    }

    public String dump() {
        StringBuilder s = new StringBuilder(10);
        s.append(this.from.dump()).append(" - ").append(this.until.dump());
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer(10);
        s.append(this.from.toString());
        s.append(this.until.toString());
        return s.toString();
    }

    public static String toString(Iterator<TimeTool> it) {
        StringBuffer ret = new StringBuffer(200);
        while (it.hasNext()) {
            TimeTool tt = it.next();
            ret.append(tt.toString());
        }
        return ret.toString();
    }

    public static int create(Collection c, String s) {
        int k = 0;
        int i = 0;
        while (i < s.length()) {
            TimeTool tt = new TimeTool(s.substring(i, i + 16));
            c.add(tt);
            ++k;
            i += 16;
        }
        return k;
    }

    public static class TSComparator
    implements Comparator<TimeSpan> {
        @Override
        public int compare(TimeSpan ts1, TimeSpan ts2) {
            return ts1.compareTo(ts2);
        }
    }
}

