/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.tools.JdbcLinkConcurrencyException;
import ch.rgw.tools.JdbcLinkException;
import ch.rgw.tools.JdbcLinkResourceException;
import ch.rgw.tools.JdbcLinkSyntaxException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class JdbcLinkExceptionTranslation {
    private static final Set<String> BAD_SQL_GRAMMAR_CODES = new HashSet<String>(8);
    private static final Set<String> DATA_INTEGRITY_VIOLATION_CODES = new HashSet<String>(8);
    private static final Set<String> DATA_ACCESS_RESOURCE_FAILURE_CODES = new HashSet<String>(8);
    private static final Set<String> TRANSIENT_DATA_ACCESS_RESOURCE_CODES = new HashSet<String>(8);
    private static final Set<String> CONCURRENCY_FAILURE_CODES = new HashSet<String>(4);

    static {
        BAD_SQL_GRAMMAR_CODES.add("07");
        BAD_SQL_GRAMMAR_CODES.add("21");
        BAD_SQL_GRAMMAR_CODES.add("2A");
        BAD_SQL_GRAMMAR_CODES.add("37");
        BAD_SQL_GRAMMAR_CODES.add("42");
        BAD_SQL_GRAMMAR_CODES.add("65");
        BAD_SQL_GRAMMAR_CODES.add("S0");
        DATA_INTEGRITY_VIOLATION_CODES.add("01");
        DATA_INTEGRITY_VIOLATION_CODES.add("02");
        DATA_INTEGRITY_VIOLATION_CODES.add("22");
        DATA_INTEGRITY_VIOLATION_CODES.add("23");
        DATA_INTEGRITY_VIOLATION_CODES.add("27");
        DATA_INTEGRITY_VIOLATION_CODES.add("44");
        DATA_ACCESS_RESOURCE_FAILURE_CODES.add("08");
        DATA_ACCESS_RESOURCE_FAILURE_CODES.add("53");
        DATA_ACCESS_RESOURCE_FAILURE_CODES.add("54");
        DATA_ACCESS_RESOURCE_FAILURE_CODES.add("57");
        DATA_ACCESS_RESOURCE_FAILURE_CODES.add("58");
        TRANSIENT_DATA_ACCESS_RESOURCE_CODES.add("JW");
        TRANSIENT_DATA_ACCESS_RESOURCE_CODES.add("JZ");
        TRANSIENT_DATA_ACCESS_RESOURCE_CODES.add("S1");
        CONCURRENCY_FAILURE_CODES.add("40");
        CONCURRENCY_FAILURE_CODES.add("61");
    }

    public static JdbcLinkException translateException(Exception ex) {
        if (ex instanceof SQLException) {
            return JdbcLinkExceptionTranslation.translateSQLException(null, (SQLException)ex);
        }
        return new JdbcLinkException(null, ex);
    }

    public static JdbcLinkException translateException(String message, Exception ex) {
        if (ex instanceof SQLException) {
            return JdbcLinkExceptionTranslation.translateSQLException(message, (SQLException)ex);
        }
        return new JdbcLinkException(message, ex);
    }

    private static JdbcLinkException translateSQLException(String message, SQLException sql) {
        String state = sql.getSQLState();
        if (state != null && state.length() >= 2) {
            String stateClass = state.substring(0, 2);
            if (BAD_SQL_GRAMMAR_CODES.contains(stateClass)) {
                return new JdbcLinkSyntaxException(String.valueOf(message) + " (SQLState: " + state + ")", sql);
            }
            if (DATA_ACCESS_RESOURCE_FAILURE_CODES.contains(stateClass)) {
                return new JdbcLinkResourceException(String.valueOf(message) + " (SQLState: " + state + ")", sql);
            }
            if (CONCURRENCY_FAILURE_CODES.contains(stateClass)) {
                return new JdbcLinkConcurrencyException(String.valueOf(message) + " (SQLState: " + state + ")", sql);
            }
        }
        return new JdbcLinkException(String.valueOf(message) + " (SQLState: " + state + ")", sql);
    }
}

