/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class LargeFileLookup {
    RandomAccessFile raf;
    long len;

    public LargeFileLookup(File file) throws FileNotFoundException {
        this.len = file.length();
        this.raf = new RandomAccessFile(file, "r");
    }

    public List<String> binarySearch(String search) throws IOException {
        String line;
        String string = search.toLowerCase();
        ArrayList<String> result = new ArrayList<String>();
        long low = 0L;
        long high = this.len;
        long p = -1L;
        while (low < high) {
            String line2;
            long mid;
            p = mid = (low + high) / 2L;
            while (p >= 0L) {
                this.raf.seek(p);
                char c = (char)this.raf.readByte();
                if (c == '\n') break;
                --p;
            }
            if (p < 0L) {
                this.raf.seek(0L);
            }
            if ((line2 = this.raf.readLine()).toLowerCase().compareTo(string) < 0) {
                low = mid + 1L;
                continue;
            }
            high = mid;
        }
        p = low;
        while (p >= 0L) {
            this.raf.seek(p);
            if ((char)this.raf.readByte() == '\n') break;
            --p;
        }
        if (p < 0L) {
            this.raf.seek(0L);
        }
        while ((line = this.raf.readLine()) != null && line.toLowerCase().startsWith(string)) {
            result.add(line);
        }
        return result;
    }
}

