/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.Behandlung;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithExtInfo;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.id.ElexisIdGenerator;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="faelle")
@Cache(expiry=15000)
@EntityListeners(value={EntityWithIdListener.class})
@NamedQuery(name="Fall.patient", query="SELECT f FROM Fall f WHERE f.deleted = false AND f.patientKontakt = :patient")
public class Fall
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
EntityWithExtInfo,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @GeneratedValue(generator="system-uuid")
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @Lob
    protected byte[] extInfo;
    @Column(length=25)
    private String betriebsNummer;
    @Column(length=80)
    private String bezeichnung;
    @Column(length=8)
    private LocalDate datumBis;
    @Column(length=8)
    private LocalDate datumVon;
    @Column(length=80)
    private String diagnosen;
    @Column(length=25)
    private String fallNummer;
    @OneToOne
    @JoinColumn(name="garantID")
    private Kontakt garantKontakt;
    @Column(length=20)
    private String gesetz;
    @Column(length=80)
    private String grund;
    @OneToOne
    @JoinColumn(name="kostentrID")
    private Kontakt kostentrKontakt;
    @ManyToOne
    @JoinColumn(name="patientID")
    private Kontakt patientKontakt;
    @Column(length=80)
    private String status;
    @Column(length=25)
    private String versNummer;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="fall", cascade={CascadeType.REFRESH})
    protected List<Behandlung> consultations;
    static final long serialVersionUID = -2807274251136635033L;

    public Fall() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
    }

    public String getBetriebsNummer() {
        return this._persistence_get_betriebsNummer();
    }

    public void setBetriebsNummer(String betriebsNummer) {
        this._persistence_set_betriebsNummer(betriebsNummer);
    }

    public String getBezeichnung() {
        return this._persistence_get_bezeichnung();
    }

    public void setBezeichnung(String bezeichnung) {
        this._persistence_set_bezeichnung(bezeichnung);
    }

    public LocalDate getDatumBis() {
        return this._persistence_get_datumBis();
    }

    public void setDatumBis(LocalDate datumBis) {
        this._persistence_set_datumBis(datumBis);
    }

    public LocalDate getDatumVon() {
        return this._persistence_get_datumVon();
    }

    public void setDatumVon(LocalDate datumVon) {
        this._persistence_set_datumVon(datumVon);
    }

    public Kontakt getGarantKontakt() {
        return this._persistence_get_garantKontakt();
    }

    public void setGarantKontakt(Kontakt garantKontakt) {
        this._persistence_set_garantKontakt(garantKontakt);
    }

    public Kontakt getKostentrKontakt() {
        return this._persistence_get_kostentrKontakt();
    }

    public void setKostentrKontakt(Kontakt kostentrKontakt) {
        this._persistence_set_kostentrKontakt(kostentrKontakt);
    }

    public Kontakt getPatient() {
        return this._persistence_get_patientKontakt();
    }

    public void setPatient(Kontakt patientKontakt) {
        this._persistence_set_patientKontakt(patientKontakt);
    }

    public String getDiagnosen() {
        return this._persistence_get_diagnosen();
    }

    public void setDiagnosen(String diagnosen) {
        this._persistence_set_diagnosen(diagnosen);
    }

    public String getFallNummer() {
        return this._persistence_get_fallNummer();
    }

    public void setFallNummer(String fallNummer) {
        this._persistence_set_fallNummer(fallNummer);
    }

    public String getGesetz() {
        return this._persistence_get_gesetz();
    }

    public void setGesetz(String gesetz) {
        this._persistence_set_gesetz(gesetz);
    }

    public String getGrund() {
        return this._persistence_get_grund();
    }

    public void setGrund(String grund) {
        this._persistence_set_grund(grund);
    }

    public String getStatus() {
        return this._persistence_get_status();
    }

    public void setStatus(String status) {
        this._persistence_set_status(status);
    }

    public String getVersNummer() {
        return this._persistence_get_versNummer();
    }

    public void setVersNummer(String versNummer) {
        this._persistence_set_versNummer(versNummer);
    }

    public List<Behandlung> getConsultations() {
        return this._persistence_get_consultations();
    }

    public void setConsultations(List<Behandlung> consultations) {
        this._persistence_set_consultations(consultations);
    }

    @Override
    public byte[] getExtInfo() {
        return this._persistence_get_extInfo();
    }

    @Override
    public void setExtInfo(byte[] extInfo) {
        this._persistence_set_extInfo(extInfo);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Fall(persistenceObject);
    }

    public Fall(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "datumVon") {
            return this.datumVon;
        }
        if (string == "fallNummer") {
            return this.fallNummer;
        }
        if (string == "grund") {
            return this.grund;
        }
        if (string == "bezeichnung") {
            return this.bezeichnung;
        }
        if (string == "diagnosen") {
            return this.diagnosen;
        }
        if (string == "consultations") {
            return this.consultations;
        }
        if (string == "betriebsNummer") {
            return this.betriebsNummer;
        }
        if (string == "versNummer") {
            return this.versNummer;
        }
        if (string == "extInfo") {
            return this.extInfo;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "garantKontakt") {
            return this.garantKontakt;
        }
        if (string == "kostentrKontakt") {
            return this.kostentrKontakt;
        }
        if (string == "datumBis") {
            return this.datumBis;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "gesetz") {
            return this.gesetz;
        }
        if (string == "patientKontakt") {
            return this.patientKontakt;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "datumVon") {
            this.datumVon = (LocalDate)object;
            return;
        }
        if (string == "fallNummer") {
            this.fallNummer = (String)object;
            return;
        }
        if (string == "grund") {
            this.grund = (String)object;
            return;
        }
        if (string == "bezeichnung") {
            this.bezeichnung = (String)object;
            return;
        }
        if (string == "diagnosen") {
            this.diagnosen = (String)object;
            return;
        }
        if (string == "consultations") {
            this.consultations = (List)object;
            return;
        }
        if (string == "betriebsNummer") {
            this.betriebsNummer = (String)object;
            return;
        }
        if (string == "versNummer") {
            this.versNummer = (String)object;
            return;
        }
        if (string == "extInfo") {
            this.extInfo = (byte[])object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "garantKontakt") {
            this.garantKontakt = (Kontakt)object;
            return;
        }
        if (string == "kostentrKontakt") {
            this.kostentrKontakt = (Kontakt)object;
            return;
        }
        if (string == "datumBis") {
            this.datumBis = (LocalDate)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "gesetz") {
            this.gesetz = (String)object;
            return;
        }
        if (string == "patientKontakt") {
            this.patientKontakt = (Kontakt)object;
            return;
        }
        if (string == "status") {
            this.status = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LocalDate _persistence_get_datumVon() {
        this._persistence_checkFetched("datumVon");
        return this.datumVon;
    }

    public void _persistence_set_datumVon(LocalDate localDate) {
        this._persistence_checkFetchedForSet("datumVon");
        this._persistence_propertyChange("datumVon", this.datumVon, localDate);
        this.datumVon = localDate;
    }

    public String _persistence_get_fallNummer() {
        this._persistence_checkFetched("fallNummer");
        return this.fallNummer;
    }

    public void _persistence_set_fallNummer(String string) {
        this._persistence_checkFetchedForSet("fallNummer");
        this._persistence_propertyChange("fallNummer", this.fallNummer, string);
        this.fallNummer = string;
    }

    public String _persistence_get_grund() {
        this._persistence_checkFetched("grund");
        return this.grund;
    }

    public void _persistence_set_grund(String string) {
        this._persistence_checkFetchedForSet("grund");
        this._persistence_propertyChange("grund", this.grund, string);
        this.grund = string;
    }

    public String _persistence_get_bezeichnung() {
        this._persistence_checkFetched("bezeichnung");
        return this.bezeichnung;
    }

    public void _persistence_set_bezeichnung(String string) {
        this._persistence_checkFetchedForSet("bezeichnung");
        this._persistence_propertyChange("bezeichnung", this.bezeichnung, string);
        this.bezeichnung = string;
    }

    public String _persistence_get_diagnosen() {
        this._persistence_checkFetched("diagnosen");
        return this.diagnosen;
    }

    public void _persistence_set_diagnosen(String string) {
        this._persistence_checkFetchedForSet("diagnosen");
        this._persistence_propertyChange("diagnosen", this.diagnosen, string);
        this.diagnosen = string;
    }

    public List _persistence_get_consultations() {
        this._persistence_checkFetched("consultations");
        return this.consultations;
    }

    public void _persistence_set_consultations(List list) {
        this._persistence_checkFetchedForSet("consultations");
        this._persistence_propertyChange("consultations", this.consultations, list);
        this.consultations = list;
    }

    public String _persistence_get_betriebsNummer() {
        this._persistence_checkFetched("betriebsNummer");
        return this.betriebsNummer;
    }

    public void _persistence_set_betriebsNummer(String string) {
        this._persistence_checkFetchedForSet("betriebsNummer");
        this._persistence_propertyChange("betriebsNummer", this.betriebsNummer, string);
        this.betriebsNummer = string;
    }

    public String _persistence_get_versNummer() {
        this._persistence_checkFetched("versNummer");
        return this.versNummer;
    }

    public void _persistence_set_versNummer(String string) {
        this._persistence_checkFetchedForSet("versNummer");
        this._persistence_propertyChange("versNummer", this.versNummer, string);
        this.versNummer = string;
    }

    public byte[] _persistence_get_extInfo() {
        this._persistence_checkFetched("extInfo");
        return this.extInfo;
    }

    public void _persistence_set_extInfo(byte[] byArray) {
        this._persistence_checkFetchedForSet("extInfo");
        this._persistence_propertyChange("extInfo", this.extInfo, byArray);
        this.extInfo = byArray;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public Kontakt _persistence_get_garantKontakt() {
        this._persistence_checkFetched("garantKontakt");
        return this.garantKontakt;
    }

    public void _persistence_set_garantKontakt(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("garantKontakt");
        this._persistence_propertyChange("garantKontakt", this.garantKontakt, kontakt);
        this.garantKontakt = kontakt;
    }

    public Kontakt _persistence_get_kostentrKontakt() {
        this._persistence_checkFetched("kostentrKontakt");
        return this.kostentrKontakt;
    }

    public void _persistence_set_kostentrKontakt(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("kostentrKontakt");
        this._persistence_propertyChange("kostentrKontakt", this.kostentrKontakt, kontakt);
        this.kostentrKontakt = kontakt;
    }

    public LocalDate _persistence_get_datumBis() {
        this._persistence_checkFetched("datumBis");
        return this.datumBis;
    }

    public void _persistence_set_datumBis(LocalDate localDate) {
        this._persistence_checkFetchedForSet("datumBis");
        this._persistence_propertyChange("datumBis", this.datumBis, localDate);
        this.datumBis = localDate;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public String _persistence_get_gesetz() {
        this._persistence_checkFetched("gesetz");
        return this.gesetz;
    }

    public void _persistence_set_gesetz(String string) {
        this._persistence_checkFetchedForSet("gesetz");
        this._persistence_propertyChange("gesetz", this.gesetz, string);
        this.gesetz = string;
    }

    public Kontakt _persistence_get_patientKontakt() {
        this._persistence_checkFetched("patientKontakt");
        return this.patientKontakt;
    }

    public void _persistence_set_patientKontakt(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("patientKontakt");
        this._persistence_propertyChange("patientKontakt", this.patientKontakt, kontakt);
        this.patientKontakt = kontakt;
    }

    public String _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(String string) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, string);
        this.status = string;
    }
}

