/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.text;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.services.IContext;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.text.PlaceholderAttribute;
import ch.rgw.tools.TimeTool;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;

@Component
public class TerminTextPlaceholderResolver
implements ITextPlaceholderResolver {
    public String getSupportedType() {
        return "Termin";
    }

    public List<PlaceholderAttribute> getSupportedAttributes() {
        return Arrays.asList(TerminAttribute.values()).stream().map(m -> new PlaceholderAttribute(this.getSupportedType(), m.name(), m.getLocaleText())).collect(Collectors.toList());
    }

    public Optional<String> replaceByTypeAndAttribute(IContext context, String attribute) {
        IAppointment appointment = context.getTyped(IAppointment.class).orElse(null);
        if (appointment != null) {
            return Optional.ofNullable(this.replace(appointment, attribute.toLowerCase()));
        }
        return Optional.empty();
    }

    private String replace(IAppointment appointment, String lcAttribute) {
        TerminAttribute attribute = (TerminAttribute)this.searchEnum(TerminAttribute.class, lcAttribute);
        switch (attribute) {
            case Tag: {
                LocalDateTime value = appointment.getStartTime();
                return new TimeTool(value).toString(4);
            }
            case Bereich: {
                return appointment.getSchedule();
            }
            case Zeit: {
                LocalDateTime value = appointment.getStartTime();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
                return formatter.format(value);
            }
        }
        return null;
    }

    private static enum TerminAttribute implements ILocalizedEnum
    {
        Tag("Tag des Termins im Format dd.MM.yyyy"),
        Bereich("Zugeh\u00f6riger Bereich"),
        Zeit("Startzeitpunkt im Format hh:mm");

        final String description;

        private TerminAttribute(String description) {
            this.description = description;
        }

        public String getLocaleText() {
            return this.description;
        }
    }
}

