/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal;

import ch.elexis.core.ac.ACE;
import ch.elexis.core.ac.AbstractAccessControl;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IRight;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleBasedAccessControl
extends AbstractAccessControl {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String QUERY_RIGHT_FOR_USER = "SELECT COUNT(*) FROM RIGHTS_PER_USER WHERE USER_ID LIKE '%s' AND (";
    public static final String QUERY_RIGHT_FOR_ROLE = "SELECT COUNT(*) FROM RIGHTS_PER_ROLE WHERE ROLE_ID LIKE '%s' AND (";
    private IModelService modelService;
    private static final String INSERT_ROLE_RIGHT_JOINT = "INSERT INTO ROLE_RIGHT_JOINT (ID, ROLE_ID) VALUES ('%s', '%s')";
    private static final String DELETE_ROLE_RIGHT_JOINT = "DELETE FROM ROLE_RIGHT_JOINT WHERE (ID='%s') AND (ROLE_ID='%s')";

    public RoleBasedAccessControl(IModelService modelService) {
        this.modelService = modelService;
    }

    protected boolean queryRightForUser(@NonNull IUser u, @NonNull ACE ace) {
        return this.queryRight(QUERY_RIGHT_FOR_USER, u.getId(), ace);
    }

    protected boolean queryRightForRole(IRole r, ACE ace) {
        return this.queryRight(QUERY_RIGHT_FOR_ROLE, r.getId(), ace);
    }

    private boolean queryRight(String qs, String objId, ACE ace) {
        String queryString = String.format(qs, objId);
        StringBuilder sb = new StringBuilder(queryString);
        List parentACEs = ace.getParentChainIncludingSelf();
        int i = 0;
        while (i < parentACEs.size()) {
            ACE a = (ACE)parentACEs.get(i);
            if (i > 0) {
                sb.append(" OR ");
            }
            sb.append(" RIGHT_ID = '" + a.getUniqueHash() + "'");
            ++i;
        }
        sb.append(");");
        boolean ret = false;
        try {
            List result = this.modelService.executeNativeQuery(sb.toString()).collect(Collectors.toList());
            long counts = (Long)result.get(0);
            ret = counts > 0L;
        }
        catch (NumberFormatException e) {
            this.log.error("Error querying access right ", (Throwable)e);
        }
        return ret;
    }

    public boolean request(@Nullable ACE ace) {
        return this.request((IUser)null, ace);
    }

    public boolean request(@Nullable IUser user, @Nullable ACE ace) {
        if (ace == null) {
            return false;
        }
        if (user == null) {
            Optional _user = ContextServiceHolder.get().getActiveUser();
            if (!_user.isPresent()) {
                return false;
            }
            user = (IUser)_user.get();
        }
        if (user.isAdministrator()) {
            return true;
        }
        return this.queryRightForUser(user, ace);
    }

    public boolean request(@NonNull IRole r, @Nullable ACE ace) {
        if (ace == null) {
            return false;
        }
        return this.queryRightForRole(r, ace);
    }

    public void grant(IRole r, ACE ace) {
        IRight right = this.getOrCreateRightByACE(ace);
        if (r.getAssignedRights().contains(right)) {
            return;
        }
        String sqlString = String.format(INSERT_ROLE_RIGHT_JOINT, ace.getUniqueHash(), r.getId());
        int result = this.modelService.executeNativeUpdate(sqlString);
        if (result != 1) {
            this.log.warn("Error in [{}] result size is [{}]", (Object)sqlString, (Object)result);
        }
    }

    public void revoke(IRole r, ACE ace) {
        String sqlString = String.format(DELETE_ROLE_RIGHT_JOINT, ace.getUniqueHash(), r.getId());
        int result = this.modelService.executeNativeUpdate(sqlString);
        if (result != 1) {
            this.log.warn("Error in [{}] result size is [{}]", (Object)sqlString, (Object)result);
        }
    }

    private IRight getOrCreateRightByACE(ACE ace) {
        Optional right = this.modelService.load(ace.getUniqueHash(), IRight.class);
        if (right.isPresent()) {
            return (IRight)right.get();
        }
        IRight _right = (IRight)this.modelService.create(IRight.class);
        _right.setId(ace.getUniqueHash());
        _right.setName(ace.getName());
        _right.setLocalizedName(ace.getLocalizedName());
        IRight _parentRight = this.getOrCreateRightByACE(ace.getParent());
        _right.setParent(_parentRight);
        this.modelService.save((Identifiable)_right);
        return _right;
    }
}

