/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.eenv;

import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.model.message.TransientMessage;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IMessageTransporter;
import ch.elexis.core.services.eenv.RocketchatMessage;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class RocketchatMessageTransporter
implements IMessageTransporter {
    public static final String CFG_ROCKETCHAT_STATION_INTEGRATION_TOKEN = "rocketchat-station-integration-token";
    @Reference
    private IElexisEnvironmentService elexisEnvironmentService;
    @Reference
    private IConfigService configService;

    public String getUriScheme() {
        return "rocketchat";
    }

    public boolean isExternal() {
        return false;
    }

    public IStatus send(TransientMessage message) {
        return this.sendFromStationSender(message);
    }

    private IStatus sendFromStationSender(TransientMessage message) {
        String integrationToken = this.configService.getLocal(CFG_ROCKETCHAT_STATION_INTEGRATION_TOKEN, null);
        if (integrationToken != null) {
            try {
                URL integrationUrl = new URL(String.valueOf(this.elexisEnvironmentService.getRocketchatIntegrationBaseUrl()) + integrationToken);
                String jsonMessage = this.prepareRocketchatMessage(message);
                return this.send(integrationUrl, jsonMessage.getBytes());
            }
            catch (IOException e) {
                return new Status(4, "ch.elexis.core.services", e.getMessage());
            }
        }
        return new Status(4, "ch.elexis.core.services", "No webhook integration token [rocketchat-station-integration-token] found in local config or malformed url.");
    }

    protected String prepareRocketchatMessage(TransientMessage message) {
        String severity = (String)message.getMessageCodes().get("severity");
        if (severity == null) {
            severity = "info";
        }
        StringBuilder header = new StringBuilder();
        header.append(String.valueOf(this.severityToEmoji(severity)) + " @" + message.getReceiver().substring(message.getReceiver().indexOf(58) + 1));
        Set entrySet = message.getMessageCodes().entrySet();
        if (!entrySet.isEmpty()) {
            header.append(" | ");
            message.getMessageCodes().entrySet().forEach(c -> {
                StringBuilder stringBuilder2 = header.append(String.valueOf((String)c.getKey()) + ":" + (String)c.getValue() + " ");
            });
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("color", this.severityToColor(severity));
        params.put("text", message.getMessageText());
        RocketchatMessage rocketchatMessage = new RocketchatMessage();
        rocketchatMessage.setSender(message.getSender());
        rocketchatMessage.setText(header.toString());
        rocketchatMessage.setAttachments(params);
        return new Gson().toJson((Object)rocketchatMessage);
    }

    private IStatus send(URL url, byte[] postDataBytes) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
        con.getOutputStream().write(postDataBytes);
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            return Status.OK_STATUS;
        }
        return new Status(4, "ch.elexis.core.services", "Error sending, with response code: " + responseCode);
    }

    private String severityToColor(String severity) {
        switch (severity) {
            case "warn": {
                return "#FFDB00";
            }
            case "error": {
                return "#FF0000";
            }
        }
        return "#0000FF";
    }

    private String severityToEmoji(String severity) {
        switch (severity) {
            case "error": {
                return ":stop_sign:";
            }
            case "warn": {
                return ":warning:";
            }
        }
        return "";
    }
}

