/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.ac.AccessControlDefaults;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IBillableAdjuster;
import ch.elexis.core.services.IBilledAdjuster;
import ch.elexis.core.services.IBillingService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.services.holder.CodeElementServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.status.StatusUtil;
import ch.rgw.tools.Result;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class BillingService
implements IBillingService {
    private static Logger logger = LoggerFactory.getLogger(BillingService.class);
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private IAccessControlService accessControlService;
    @Reference
    private IStockService stockService;
    @Reference
    private IContextService contextService;
    private List<IBilledAdjuster> billedAdjusters = new ArrayList<IBilledAdjuster>();
    private List<IBillableAdjuster> billableAdjusters = new ArrayList<IBillableAdjuster>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setBilledAdjuster(IBilledAdjuster adjuster) {
        if (!this.billedAdjusters.contains(adjuster)) {
            this.billedAdjusters.add(adjuster);
        }
    }

    public void unsetBilledAdjuster(IBilledAdjuster adjuster) {
        if (this.billedAdjusters.contains(adjuster)) {
            this.billedAdjusters.remove(adjuster);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setBillableAdjuster(IBillableAdjuster adjuster) {
        if (!this.billableAdjusters.contains(adjuster)) {
            this.billableAdjusters.add(adjuster);
        }
    }

    public void unsetBillableAdjuster(IBillableAdjuster adjuster) {
        if (this.billableAdjusters.contains(adjuster)) {
            this.billableAdjusters.remove(adjuster);
        }
    }

    public Result<IEncounter> isEditable(IEncounter encounter) {
        boolean ok;
        boolean mandatorLoggedIn;
        ICoverage coverage = encounter.getCoverage();
        if (coverage != null && !coverage.isOpen()) {
            return new Result(Result.SEVERITY.WARNING, 0, "Diese Konsultation geh\u00f6rt zu einem abgeschlossenen Fall", (Object)encounter, false);
        }
        IMandator encounterMandator = encounter.getMandator();
        boolean checkMandant = !this.accessControlService.request(AccessControlDefaults.LSTG_CHARGE_FOR_ALL);
        boolean mandatorOk = true;
        boolean invoiceOk = true;
        IMandator activeMandator = ContextServiceHolder.get().getActiveMandator().orElse(null);
        boolean bl = mandatorLoggedIn = activeMandator != null;
        if (encounterMandator != null && activeMandator != null) {
            InvoiceState state;
            IInvoice rn;
            if (checkMandant && !encounterMandator.getId().equals(activeMandator.getId())) {
                mandatorOk = false;
            }
            invoiceOk = (rn = encounter.getInvoice()) == null ? true : (state = rn.getState()) == InvoiceState.CANCELLED;
        }
        boolean bl2 = ok = invoiceOk && mandatorOk && mandatorLoggedIn;
        if (ok) {
            return new Result((Object)encounter);
        }
        String msg2 = "";
        msg2 = !mandatorLoggedIn ? "Es ist kein Mandant eingeloggt" : (!invoiceOk ? "F\u00fcr diese Behandlung wurde bereits eine Rechnung erstellt." : "Diese Behandlung ist nicht von Ihnen");
        return new Result(Result.SEVERITY.WARNING, 0, msg2, (Object)encounter, false);
    }

    public Result<IBilled> bill(IBillable billable, IEncounter encounter, double amount) {
        Result<IEncounter> editable = this.isEditable(encounter);
        if (!editable.isOK()) {
            return this.translateResult(editable);
        }
        IBillable beforeAdjust = billable;
        CoreModelServiceHolder.get().refresh((Identifiable)encounter, true);
        logger.info("Billing [" + amount + "] of [" + billable + "] on [" + encounter + "]");
        for (IBillableAdjuster iBillableAdjuster : this.billableAdjusters) {
            billable = iBillableAdjuster.adjust(billable, encounter);
        }
        if (billable != null) {
            Result verificationResult = billable.getVerifier().verifyAdd(billable, encounter, amount);
            if (verificationResult.isOK()) {
                IStatus status;
                IBillableOptifier optifier = billable.getOptifier();
                Result optifierResult = optifier.add(billable, encounter, amount);
                if (billable instanceof IArticle && !(status = this.stockService.performSingleDisposal((IArticle)billable, this.doubleToInt(amount), (String)this.contextService.getActiveMandator().map(m -> m.getId()).orElse(null))).isOK()) {
                    StatusUtil.logStatus((Logger)logger, (IStatus)status, (boolean)true);
                }
                if (!optifierResult.isOK() && optifierResult.getCode() == 11) {
                    String initialResult = optifierResult.toString();
                    optifier.putContext("Seite", (Object)"r");
                    optifierResult = optifier.add(billable, encounter, amount);
                    if (!optifierResult.isOK() && optifierResult.getCode() == 11) {
                        optifier.putContext("Seite", (Object)"l");
                        optifierResult = optifier.add(billable, encounter, amount);
                    }
                    if (optifierResult.isOK()) {
                        String message = "Achtung: " + initialResult + "\n Es wurde bei der Position " + billable.getCode() + " automatisch die Seite gewechselt." + " Bitte korrigieren Sie die Leistung falls dies nicht korrekt ist.";
                        optifierResult.addMessage(Result.SEVERITY.OK, message);
                    }
                    optifier.clearContext();
                }
                if (optifierResult.get() != null) {
                    for (IBilledAdjuster iBilledAdjuster : this.billedAdjusters) {
                        iBilledAdjuster.adjust((IBilled)optifierResult.get());
                    }
                    if (optifierResult.isOK()) {
                        CodeElementServiceHolder.updateStatistics(billable, ContextServiceHolder.get().getActiveUserContact().orElse(null));
                        CodeElementServiceHolder.updateStatistics(billable, (IContact)encounter.getPatient());
                    }
                }
                return optifierResult;
            }
            return this.translateResult(verificationResult);
        }
        return new Result(Result.SEVERITY.WARNING, 1, "Folgende Leistung '" + beforeAdjust.getCode() + "' konnte im aktuellen Kontext (Fall, Konsultation, Gesetz) nicht verrechnet werden.", null, false);
    }

    private int doubleToInt(double value) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(0, RoundingMode.HALF_UP);
        return bd.intValue();
    }

    public Result<?> removeBilled(IBilled billed, IEncounter encounter) {
        Result<IEncounter> editable = this.isEditable(encounter);
        if (!editable.isOK()) {
            return editable;
        }
        IBillable billable = billed.getBillable();
        if (billable != null && billable.getOptifier() != null) {
            billable.getOptifier().remove(billed, encounter);
        } else {
            encounter.removeBilled(billed);
        }
        if (billable instanceof IArticle) {
            IPrescription prescription;
            IArticle article = (IArticle)billable;
            String mandatorId = this.contextService.getActiveMandator().map(m -> m.getId()).orElse(null);
            this.stockService.performSingleReturn(article, (int)billed.getAmount(), mandatorId);
            Object prescId = billed.getExtInfo((Object)"prescriptionId");
            if (prescId instanceof String && (prescription = (IPrescription)this.coreModelService.load((String)prescId, IPrescription.class).orElse(null)) != null && EntryType.SELF_DISPENSED == prescription.getEntryType()) {
                this.coreModelService.remove((Identifiable)prescription);
                ContextServiceHolder.get().postEvent("info/elexis/model/reload", (Object)prescription);
            }
        }
        return Result.OK();
    }

    private Result<IBilled> translateResult(Result<?> verificationResult) {
        Result ret = new Result();
        verificationResult.getMessages().forEach(msg2 -> ret.addMessage(msg2.getSeverity(), msg2.getText()));
        return ret;
    }

    public Optional<IBillingSystemFactor> getBillingSystemFactor(String system, LocalDate date) {
        IQuery query = this.coreModelService.getQuery(IBillingSystemFactor.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IBILLING_SYSTEM_FACTOR__SYSTEM, IQuery.COMPARATOR.EQUALS, (Object)system);
        query.and((EStructuralFeature)ModelPackage.Literals.IBILLING_SYSTEM_FACTOR__VALID_FROM, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)date);
        query.and((EStructuralFeature)ModelPackage.Literals.IBILLING_SYSTEM_FACTOR__VALID_TO, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)date);
        return query.executeSingleResult();
    }

    public void setBillingSystemFactor(LocalDate from, LocalDate to, double factor, String system) {
        if (to == null) {
            to = LocalDate.of(2038, 1, 18);
        }
        IQuery query = this.coreModelService.getQuery(IBillingSystemFactor.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IBILLING_SYSTEM_FACTOR__SYSTEM, IQuery.COMPARATOR.EQUALS, (Object)system);
        List existingWithSystem = query.execute();
        for (IBillingSystemFactor iBillingSystemFactor : existingWithSystem) {
            if (iBillingSystemFactor.getValidTo() != null && !iBillingSystemFactor.getValidTo().isAfter(from)) continue;
            iBillingSystemFactor.setValidTo(from);
            this.coreModelService.save((Identifiable)iBillingSystemFactor);
        }
        IBillingSystemFactor billingSystemFactor = (IBillingSystemFactor)this.coreModelService.create(IBillingSystemFactor.class);
        billingSystemFactor.setFactor(factor);
        billingSystemFactor.setSystem(system);
        billingSystemFactor.setValidFrom(from);
        billingSystemFactor.setValidTo(to);
        this.coreModelService.save((Identifiable)billingSystemFactor);
    }

    public IStatus changeAmountValidated(IBilled billed, double newAmount) {
        double oldAmount = billed.getAmount();
        if (newAmount == oldAmount) {
            return Status.OK_STATUS;
        }
        IEncounter encounter = billed.getEncounter();
        if (newAmount == 0.0) {
            this.removeBilled(billed, encounter);
            return Status.OK_STATUS;
        }
        IStatus ret = Status.OK_STATUS;
        boolean bAllowOverrideStrict = ConfigServiceHolder.get().getActiveUserContact("billing/allowoverride/strict", false);
        double difference = newAmount - oldAmount;
        if (difference > 0.0) {
            IBillable billable = billed.getBillable();
            int i = 0;
            while ((double)i < difference) {
                String message;
                Result<IBilled> result = this.bill(billable, encounter, 1.0);
                if (bAllowOverrideStrict) {
                    if (ret.isOK() && !result.isOK()) {
                        message = result.getMessages().stream().map(m -> m.getText()).collect(Collectors.joining(", "));
                        ret = new Status(2, "ch.elexis.core.services", message);
                    }
                } else if (!result.isOK()) {
                    message = result.getMessages().stream().map(m -> m.getText()).collect(Collectors.joining(", "));
                    return new Status(4, "ch.elexis.core.services", message);
                }
                ++i;
            }
        } else if (difference < 0.0) {
            this.changeAmount(billed, newAmount);
        }
        return ret;
    }

    public void changeAmount(IBilled billed, double newAmount) {
        double oldAmount = billed.getAmount();
        billed.setAmount(newAmount);
        IBillable billable = billed.getBillable();
        if (billable instanceof IArticle) {
            IArticle art = (IArticle)billable;
            String mandatorId = this.contextService.getActiveMandator().map(m -> m.getId()).orElse(null);
            double difference = newAmount - oldAmount;
            if (difference > 0.0) {
                this.stockService.performSingleDisposal(art, (int)difference, mandatorId);
            } else if (difference < 0.0) {
                this.stockService.performSingleReturn(art, (int)(difference *= -1.0), mandatorId);
            }
        }
    }
}

