/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.importers.multifile.strategy;

import ch.elexis.core.importer.div.importers.multifile.strategy.DefaultHL7ImportStrategy;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategy;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategyFactory;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.rgw.io.FileTool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicFileImportStrategyFactory
implements IFileImportStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(BasicFileImportStrategyFactory.class);

    @Override
    public Map<IVirtualFilesystemService.IVirtualFilesystemHandle, IFileImportStrategy> createImportStrategyMap(IVirtualFilesystemService.IVirtualFilesystemHandle fileHandle) {
        HashMap<IVirtualFilesystemService.IVirtualFilesystemHandle, IFileImportStrategy> ret = new HashMap<IVirtualFilesystemService.IVirtualFilesystemHandle, IFileImportStrategy>();
        if (!this.validateHL7File(fileHandle)) {
            throw new IllegalStateException("File [" + fileHandle + "] is not a processable HL7 File");
        }
        ret.put(fileHandle, new DefaultHL7ImportStrategy());
        return ret;
    }

    protected List<IVirtualFilesystemService.IVirtualFilesystemHandle> getMatchingFiles(IVirtualFilesystemService.IVirtualFilesystemHandle hl7File) throws IOException {
        ArrayList<IVirtualFilesystemService.IVirtualFilesystemHandle> matchingFiles = new ArrayList<IVirtualFilesystemService.IVirtualFilesystemHandle>();
        String origin = hl7File.getName();
        String seekName = FileTool.getNakedFilename((String)origin);
        IVirtualFilesystemService.IVirtualFilesystemHandle directory = hl7File.getParent();
        IVirtualFilesystemService.IVirtualFilesystemHandle[] iVirtualFilesystemHandleArray = directory.listHandles();
        int n = iVirtualFilesystemHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualFilesystemService.IVirtualFilesystemHandle f = iVirtualFilesystemHandleArray[n2];
            String name = f.getName();
            if (name.startsWith(seekName) && !name.equals(origin)) {
                matchingFiles.add(f);
            }
            ++n2;
        }
        log.debug("Found " + matchingFiles.size() + " matching files for HL7File [" + hl7File.getName() + "]");
        return matchingFiles;
    }

    protected boolean validateHL7File(IVirtualFilesystemService.IVirtualFilesystemHandle hl7File) {
        if (hl7File == null) {
            return false;
        }
        try {
            return hl7File.exists() && hl7File.getExtension().equalsIgnoreCase("hl7");
        }
        catch (IOException e) {
            return false;
        }
    }
}

