/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.importers;

import ch.elexis.core.importer.div.importers.ILabImportUtil;
import ch.elexis.core.importer.div.importers.Messages;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabOrder;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.types.PathologicDescription;
import ch.elexis.hl7.model.OrcMessage;
import ch.rgw.tools.TimeTool;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TransientLabResult {
    private IPatient patient;
    private ILabItem labItem;
    private ILaboratory origin;
    private String result;
    private String comment;
    private String refMale;
    private String refFemale;
    private String unit;
    private String subId;
    private Integer flags;
    private String rawAbnormalFlags;
    private TimeTool date;
    private TimeTool analyseTime;
    private TimeTool observationTime;
    private TimeTool transmissionTime;
    private Map<String, String> setProperties;
    private ILabImportUtil labImportUtil;
    private OrcMessage orcMessage;

    private TransientLabResult(Builder builder, ILabImportUtil labImportUtil) {
        this.patient = builder.patient;
        this.labItem = builder.labItem;
        this.origin = builder.origin;
        this.result = builder.result;
        this.comment = builder.comment;
        this.refMale = builder.refMale;
        this.refFemale = builder.refFemale;
        this.unit = builder.unit;
        this.flags = builder.flags;
        this.rawAbnormalFlags = builder.rawAbnormalFlags;
        this.date = builder.date;
        this.analyseTime = builder.analyseTime;
        this.observationTime = builder.observationTime;
        this.transmissionTime = builder.transmissionTime;
        this.setProperties = builder.setProperties;
        this.labImportUtil = labImportUtil;
        this.orcMessage = builder.orcMessage;
        this.subId = builder.subId;
    }

    public boolean isSameResult(ILabResult labResult) {
        if (this.refMale != null && !labResult.getReferenceMale().equals(this.refMale)) {
            return false;
        }
        if (this.refFemale != null && !labResult.getReferenceFemale().equals(this.refFemale)) {
            return false;
        }
        if (this.unit != null && !labResult.getUnit().equals(this.unit)) {
            return false;
        }
        String matchResult = labResult.getResult();
        return matchResult.equals(this.result);
    }

    public void overwriteExisting(ILabResult labResult) {
        labResult.setComment(this.comment);
        labResult.setResult(this.result);
        this.setFieldsAndInterpret(labResult);
        if (this.labItem.getTyp() == LabItemTyp.NUMERIC) {
            this.flags = labResult.isPathologic() ? 1 : 0;
        } else if (this.flags != null) {
            labResult.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_IMPORT, this.rawAbnormalFlags));
        } else {
            labResult.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_IMPORT_NO_INFO, this.rawAbnormalFlags));
        }
        CoreModelServiceHolder.get().save((Identifiable)labResult);
    }

    public ILabResult persist(ILabOrder labOrder, String orderId, IMandator mandantor, TimeTool time, String groupName) {
        String refVal = Gender.MALE == this.patient.getGender() ? this.refMale : this.refFemale;
        ILabResult labResult = this.labImportUtil.createLabResult(this.patient, this.date, this.labItem, this.result, this.comment, refVal, this.origin, this.subId, labOrder, orderId, mandantor, time, groupName);
        this.setFieldsAndInterpret(labResult);
        if (this.flags != null) {
            labResult.setPathologic(this.flags > 0);
            labResult.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_IMPORT, this.rawAbnormalFlags));
        } else {
            List mpfRuleContactIds;
            if (LabItemTyp.NUMERIC != this.labItem.getTyp()) {
                labResult.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_IMPORT_NO_INFO, this.rawAbnormalFlags));
            }
            if (this.origin != null && (mpfRuleContactIds = ConfigServiceHolder.get().getAsList("lab/eval/missingPathologicFlagMeansNonPathologicFor", Collections.emptyList())).contains(this.origin.getId())) {
                labResult.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_IMPORT, Messages.MPF_Rule_PathDescriptionText));
                labResult.setPathologic(false);
            }
        }
        CoreModelServiceHolder.get().save((Identifiable)labResult);
        return labResult;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.labItem.getLabel()).append(", ").append(this.getDate().toString(4)).append(": ").append(this.getResult());
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.labItem.getLabel()).append(", date ").append(this.getDate().toString(13));
        if (this.refMale != null) {
            sb.append(" refm ").append(this.refMale);
        }
        if (this.refFemale != null) {
            sb.append(" reff ").append(this.refFemale);
        }
        if (this.unit != null) {
            sb.append(" unit ").append(this.unit);
        }
        if (this.analyseTime != null) {
            sb.append(" aTime ").append(this.analyseTime.toString(13));
        }
        if (this.observationTime != null) {
            sb.append(" oTime ").append(this.observationTime.toString(13));
        }
        if (this.transmissionTime != null) {
            sb.append(" tTime ").append(this.transmissionTime.toString(13));
        }
        sb.append(" res ").append(this.getResult());
        return sb.toString();
    }

    private void setFieldsAndInterpret(ILabResult labResult) {
        ILabItem item;
        if (this.refMale != null) {
            String itemRefMale;
            labResult.setReferenceMale(this.refMale);
            item = labResult.getItem();
            if (item != null && ((itemRefMale = item.getReferenceMale()) == null || itemRefMale.isEmpty())) {
                item.setReferenceMale(this.refMale);
            }
        }
        if (this.refFemale != null) {
            String itemRefFemale;
            labResult.setReferenceFemale(this.refFemale);
            item = labResult.getItem();
            if (item != null && ((itemRefFemale = item.getReferenceFemale()) == null || itemRefFemale.isEmpty())) {
                item.setReferenceFemale(this.refFemale);
            }
        }
        if (this.unit != null) {
            labResult.setUnit(this.unit);
        }
        if (this.analyseTime != null) {
            labResult.setAnalyseTime(this.analyseTime.toLocalDateTime());
        }
        if (this.observationTime != null) {
            labResult.setObservationTime(this.observationTime.toLocalDateTime());
        }
        if (this.transmissionTime != null) {
            labResult.setTransmissionTime(this.transmissionTime.toLocalDateTime());
        }
        this.labImportUtil.updateLabResult(labResult, this);
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public ILabItem getLabItem() {
        return this.labItem;
    }

    public String getResult() {
        return this.result;
    }

    public String getComment() {
        return this.comment;
    }

    public String getRefMale() {
        return this.refMale;
    }

    public String getRefFemale() {
        return this.refFemale;
    }

    public String getUnit() {
        return this.unit;
    }

    public int getFlags() {
        return this.flags;
    }

    public TimeTool getDate() {
        return this.date;
    }

    public TimeTool getAnalyseTime() {
        return this.analyseTime;
    }

    public OrcMessage getOrcMessage() {
        return this.orcMessage;
    }

    public String getSubId() {
        return this.subId;
    }

    public boolean isAnalyseTime() {
        if (this.analyseTime == null) {
            return false;
        }
        if (this.transmissionTime != null) {
            return !this.analyseTime.isEqual(this.transmissionTime);
        }
        return true;
    }

    public TimeTool getObservationTime() {
        return this.observationTime;
    }

    public boolean isObservationTime() {
        if (this.observationTime == null) {
            return false;
        }
        if (this.transmissionTime != null) {
            return !this.observationTime.isEqual(this.transmissionTime);
        }
        return true;
    }

    public TimeTool getTransmissionTime() {
        return this.transmissionTime;
    }

    public static class Builder {
        private IPatient patient;
        private ILabItem labItem;
        private ILaboratory origin;
        private String result;
        private String subId;
        private String comment;
        private String refMale;
        private String refFemale;
        private String unit;
        private Integer flags;
        private String rawAbnormalFlags;
        private TimeTool date;
        private TimeTool analyseTime;
        private TimeTool observationTime;
        private TimeTool transmissionTime;
        private Map<String, String> setProperties;
        private OrcMessage orcMessage;

        public Builder(IPatient patient, ILaboratory origin, ILabItem labItem, String result) {
            this.patient = patient;
            this.labItem = labItem;
            this.result = result;
            this.origin = origin;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder refMale(String refMale) {
            this.refMale = refMale;
            return this;
        }

        public Builder refFemale(String refFemale) {
            this.refFemale = refFemale;
            return this;
        }

        public Builder ref(String ref) {
            if (this.patient.getGender() == Gender.MALE) {
                this.refMale(ref);
            } else {
                this.refFemale(ref);
            }
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public Builder flags(Integer flags) {
            this.flags = flags;
            return this;
        }

        public Builder rawAbnormalFlags(String rawAbnormalFlags) {
            this.rawAbnormalFlags = rawAbnormalFlags;
            return this;
        }

        public Builder date(TimeTool date) {
            this.date = date;
            return this;
        }

        public Builder analyseTime(TimeTool analyseTime) {
            this.analyseTime = analyseTime;
            return this;
        }

        public Builder observationTime(TimeTool observationTime) {
            this.observationTime = observationTime;
            return this;
        }

        public Builder transmissionTime(TimeTool transmissionTime) {
            this.transmissionTime = transmissionTime;
            return this;
        }

        public TransientLabResult build(ILabImportUtil labImportUtil) {
            return new TransientLabResult(this, labImportUtil);
        }

        public Builder orcMessage(OrcMessage orcMessage) {
            this.orcMessage = orcMessage;
            return this;
        }

        public Builder subId(String subId) {
            this.subId = subId;
            return this;
        }
    }
}

