/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.ui.dlg;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.ILocalCoding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.templates.ui.dlg.LocalCodeViewerComparator;
import ch.elexis.core.findings.templates.ui.dlg.LocalCodeViewerFilter;
import ch.elexis.core.findings.templates.ui.util.FindingsServiceHolder;
import ch.elexis.core.findings.util.FindingsTextUtil;
import ch.elexis.core.services.IQuery;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MergeLocalCodeDialog
extends TitleAreaDialog {
    private TableViewer destinationItems;
    private Text destinationFilterTxt;
    private LocalCodeViewerFilter destinationFilter;
    private TableViewer sourceItems;
    private Text sourceFilterTxt;
    private LocalCodeViewerFilter sourceFilter;
    private LabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            ILocalCoding iCoding = (ILocalCoding)element;
            StringBuilder stringBuilder = new StringBuilder();
            for (ICoding mappedCoding : iCoding.getMappedCodes()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(mappedCoding.getSystem());
                stringBuilder.append(": ");
                stringBuilder.append(mappedCoding.getCode());
            }
            return iCoding != null ? String.valueOf(iCoding.getDisplay()) + " (" + iCoding.getCode() + ")" + (stringBuilder.length() > 0 ? " [" + stringBuilder.toString() + "]" : "") : "";
        }
    };

    public MergeLocalCodeDialog(Shell parentShell) {
        super(parentShell);
        this.destinationFilter = new LocalCodeViewerFilter((ILabelProvider)this.labelProvider);
        this.sourceFilter = new LocalCodeViewerFilter((ILabelProvider)this.labelProvider);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Codes vereinen");
        this.setTitle("Codes vereinen");
        this.setMessage("Bitte die zu vereinenden Codes ausw\u00e4hlen");
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)new GridData(1808));
        ret.setLayout((Layout)new GridLayout(1, false));
        Label lbl = new Label(ret, 0);
        lbl.setText("Code der nach dem vereinen gesetzt ist");
        GridData layoutData = new GridData(4, 4, true, false, 4, 1);
        layoutData.heightHint = 150;
        this.destinationFilterTxt = new Text(ret, 2048);
        this.destinationFilterTxt.setLayoutData((Object)new GridData(768));
        this.destinationFilterTxt.setMessage("Filter");
        this.destinationFilterTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MergeLocalCodeDialog.this.destinationFilterTxt.getText().length() > 1) {
                    MergeLocalCodeDialog.this.destinationFilter.setSearchText(MergeLocalCodeDialog.this.destinationFilterTxt.getText());
                    MergeLocalCodeDialog.this.destinationItems.refresh();
                } else {
                    MergeLocalCodeDialog.this.destinationFilter.setSearchText("");
                    MergeLocalCodeDialog.this.destinationItems.refresh();
                }
            }
        });
        this.destinationItems = new TableViewer(ret, 2048);
        this.destinationItems.getTable().setLayoutData((Object)layoutData);
        this.destinationItems.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.destinationItems.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.destinationItems.setComparator((ViewerComparator)new LocalCodeViewerComparator(this.labelProvider));
        this.destinationItems.addFilter((ViewerFilter)this.destinationFilter);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.destinationItems, (int)2);
        lbl = new Label(ret, 0);
        lbl.setText("Code der nach dem vereinen entfernt wird");
        this.sourceFilterTxt = new Text(ret, 2048);
        this.sourceFilterTxt.setLayoutData((Object)new GridData(768));
        this.sourceFilterTxt.setMessage("Filter");
        this.sourceFilterTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MergeLocalCodeDialog.this.sourceFilterTxt.getText().length() > 1) {
                    MergeLocalCodeDialog.this.sourceFilter.setSearchText(MergeLocalCodeDialog.this.sourceFilterTxt.getText());
                    MergeLocalCodeDialog.this.sourceItems.refresh();
                } else {
                    MergeLocalCodeDialog.this.sourceFilter.setSearchText("");
                    MergeLocalCodeDialog.this.sourceItems.refresh();
                }
            }
        });
        this.sourceItems = new TableViewer(ret, 2048);
        this.sourceItems.getTable().setLayoutData((Object)layoutData);
        this.sourceItems.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sourceItems.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.sourceItems.setComparator((ViewerComparator)new LocalCodeViewerComparator(this.labelProvider));
        this.sourceItems.addFilter((ViewerFilter)this.sourceFilter);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.sourceItems, (int)2);
        List codings = FindingsServiceHolder.codingService.getAvailableCodes(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem());
        this.destinationItems.setInput((Object)codings);
        this.sourceItems.setInput((Object)codings);
        return ret;
    }

    protected void okPressed() {
        StructuredSelection selection = (StructuredSelection)this.destinationItems.getSelection();
        if (selection.isEmpty()) {
            this.setErrorMessage("Kein Code zum setzen selektiert");
            return;
        }
        ILocalCoding destination = (ILocalCoding)selection.getFirstElement();
        selection = (StructuredSelection)this.sourceItems.getSelection();
        if (selection.isEmpty()) {
            this.setErrorMessage("Kein Code zum entfernen selektiert");
            return;
        }
        ILocalCoding source = (ILocalCoding)selection.getFirstElement();
        if (source == destination) {
            this.setErrorMessage("Selber Code zum setzen und entfernen selektiert");
            return;
        }
        boolean confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Warnung", (String)"Warnung vereinen kann nicht r\u00fcckg\u00e4ngig gemacht werden.\nSollen die Codes vereint werden?");
        if (!confirm) {
            return;
        }
        this.mergeLocalCode(source, destination);
        FindingsServiceHolder.codingService.removeLocalCoding((ICoding)source);
        super.okPressed();
    }

    private void mergeLocalCode(ILocalCoding source, ILocalCoding destination) {
        IQuery obsQuery = FindingsServiceHolder.findingsModelService.getQuery(IObservation.class);
        obsQuery.and("content", IQuery.COMPARATOR.LIKE, (Object)("%\"system\":\"" + source.getSystem() + "\",\"code\":\"" + source.getCode() + "\"%"));
        List obsWithCode = obsQuery.execute();
        for (IObservation iObservation : obsWithCode) {
            List coding = iObservation.getCoding();
            coding = coding.stream().filter(c -> !c.getSystem().equals(source.getSystem()) || !c.getCode().equals(source.getCode())).collect(Collectors.toList());
            coding.add(destination);
            iObservation.setCoding(coding);
            FindingsTextUtil.getObservationText((IObservation)iObservation, (boolean)true);
            FindingsServiceHolder.findingsService.saveFinding((IFinding)iObservation);
        }
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent(null, ICoding.class, 8)});
    }

    public void setSource(ILocalCoding source) {
        this.sourceItems.setSelection((ISelection)new StructuredSelection((Object)source));
    }
}

