/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.ui.composite;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ILocalCoding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.templates.ui.dlg.CodeCreateDialog;
import ch.elexis.core.findings.templates.ui.dlg.MergeLocalCodeDialog;
import ch.elexis.core.findings.templates.ui.util.FindingsServiceHolder;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.icons.Images;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class CodesSystemsComposite
extends Composite {
    private TableViewer tableViewer;
    private int comparatorColumn;
    private int comparatorDirection = 1024;

    public CodesSystemsComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(4, false));
        this.setLayoutData(new GridData(4, 4, true, true));
    }

    public void createContens() {
        Label lblCodeSystem = new Label((Composite)this, 0);
        lblCodeSystem.setText("Code System:");
        Label lblCodeSystemText = new Label((Composite)this, 0);
        lblCodeSystemText.setText(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem());
        Button btnAdd = new Button((Composite)this, 8);
        btnAdd.setImage(Images.IMG_NEW.getImage());
        btnAdd.setLayoutData((Object)new GridData(131072, 4, false, false, 2, 1));
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeCreateDialog codeDialog = new CodeCreateDialog(CodesSystemsComposite.this.getShell());
                if (codeDialog.open() == 0) {
                    CodesSystemsComposite.this.loadTable();
                }
            }
        });
        this.tableViewer = new TableViewer((Composite)this, 68354);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        TableViewerColumn col = this.createTableViewerColumn("Code", 300, 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ILocalCoding iCoding = (ILocalCoding)element;
                return CodesSystemsComposite.this.getLabel(iCoding);
            }
        });
        col.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodesSystemsComposite.this.comparatorColumn = 0;
                CodesSystemsComposite.this.comparatorDirection = CodesSystemsComposite.this.comparatorDirection == 128 ? 1024 : 128;
                CodesSystemsComposite.this.tableViewer.refresh();
            }
        });
        col = this.createTableViewerColumn("Sequenz", 50, 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ILocalCoding iCoding = (ILocalCoding)element;
                return Integer.toString(iCoding.getPrio());
            }
        });
        col.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof ILocalCoding && value instanceof String) {
                    ((ILocalCoding)element).setPrio(Integer.parseInt((String)value));
                    FindingsServiceHolder.findingsModelService.save((Identifiable)((ILocalCoding)element));
                    CodesSystemsComposite.this.tableViewer.update((Object)((ILocalCoding)element), null);
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent(null, ICoding.class, 8)});
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof ILocalCoding) {
                    return Integer.toString(((ILocalCoding)element).getPrio());
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof ILocalCoding) {
                    TextCellEditor ret = new TextCellEditor((Composite)CodesSystemsComposite.this.tableViewer.getTable());
                    ret.setValidator(new ICellEditorValidator(){

                        public String isValid(Object value) {
                            if (value instanceof String) {
                                try {
                                    Integer.parseInt((String)value);
                                }
                                catch (NumberFormatException e) {
                                    return "[" + value + "] ist nicht numerisch";
                                }
                            }
                            return null;
                        }
                    });
                    return ret;
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof ILocalCoding;
            }
        });
        col.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodesSystemsComposite.this.comparatorColumn = 1;
                CodesSystemsComposite.this.comparatorDirection = CodesSystemsComposite.this.comparatorDirection == 128 ? 1024 : 128;
                CodesSystemsComposite.this.tableViewer.refresh();
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ILocalCoding left = (ILocalCoding)e1;
                ILocalCoding right = (ILocalCoding)e2;
                if (left != null && right != null) {
                    if (CodesSystemsComposite.this.comparatorColumn == 0) {
                        if (CodesSystemsComposite.this.comparatorDirection == 1024) {
                            return CodesSystemsComposite.this.getLabel(left).compareTo(CodesSystemsComposite.this.getLabel(right));
                        }
                        return CodesSystemsComposite.this.getLabel(right).compareTo(CodesSystemsComposite.this.getLabel(left));
                    }
                    if (CodesSystemsComposite.this.comparatorColumn == 1) {
                        if (CodesSystemsComposite.this.comparatorDirection == 1024) {
                            return Integer.valueOf(left.getPrio()).compareTo(right.getPrio());
                        }
                        return Integer.valueOf(right.getPrio()).compareTo(left.getPrio());
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.loadTable();
        this.createContextMenu((Viewer)this.tableViewer);
    }

    private String getLabel(ILocalCoding iCoding) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ICoding mappedCoding : iCoding.getMappedCodes()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(mappedCoding.getSystem());
            stringBuilder.append(": ");
            stringBuilder.append(mappedCoding.getCode());
        }
        return iCoding != null ? String.valueOf(iCoding.getDisplay()) + " (" + iCoding.getCode() + ")" + (stringBuilder.length() > 0 ? " [" + stringBuilder.toString() + "]" : "") : "";
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setData((Object)title);
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(false);
        return viewerColumn;
    }

    private void createContextMenu(final Viewer viewer) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (selection.getFirstElement() instanceof ICoding) {
                    CodesSystemsComposite.this.fillContextMenu(mgr, selection.toArray());
                }
            }
        });
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    public void loadTable() {
        List codings = FindingsServiceHolder.codingService.getAvailableCodes(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem());
        codings.sort((a, b) -> ObjectUtils.compare((Comparable)((Object)a.getDisplay()), (Comparable)((Object)b.getDisplay())));
        this.tableViewer.setInput((Object)codings);
    }

    private void fillContextMenu(IMenuManager contextMenu, final Object[] objects) {
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        contextMenu.add((IAction)new Action("Entfernen"){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_DELETE.getImageDescriptor();
            }

            public void run() {
                if (objects != null) {
                    Object[] objectArray = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o instanceof ICoding) {
                            ICoding coding = (ICoding)o;
                            IQuery obsQuery = FindingsServiceHolder.findingsModelService.getQuery(IObservation.class);
                            obsQuery.and("content", IQuery.COMPARATOR.LIKE, (Object)("%\"system\":\"" + coding.getSystem() + "\",\"code\":\"" + coding.getCode() + "\"%"));
                            List obsWithCode = obsQuery.execute();
                            if (obsWithCode.isEmpty() || MessageDialog.openQuestion((Shell)CodesSystemsComposite.this.getShell(), (String)"Code entfernen", (String)("Der Code wird noch in " + obsWithCode.size() + " Befunden verwendet.\nSoll er trotzdem entfernt werden?"))) {
                                FindingsServiceHolder.codingService.removeLocalCoding((ICoding)o);
                            }
                        }
                        ++n2;
                    }
                    CodesSystemsComposite.this.loadTable();
                }
            }
        });
        contextMenu.add((IAction)new Action("Codes vereinen"){

            public void run() {
                MergeLocalCodeDialog dialog = new MergeLocalCodeDialog(CodesSystemsComposite.this.getShell());
                dialog.create();
                if (!((IStructuredSelection)CodesSystemsComposite.this.tableViewer.getSelection()).isEmpty()) {
                    dialog.setSource((ILocalCoding)((IStructuredSelection)CodesSystemsComposite.this.tableViewer.getSelection()).getFirstElement());
                }
                dialog.open();
                CodesSystemsComposite.this.loadTable();
            }
        });
    }
}

