/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.jface.preference;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;

public class URIFieldEditor
extends StringButtonFieldEditor {
    private File filterPath = null;
    private String unmaskedValue = null;

    protected URIFieldEditor() {
    }

    public URIFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.setErrorMessage(JFaceResources.getString((String)"DirectoryFieldEditor.errorMessage"));
        this.setChangeButtonText(JFaceResources.getString((String)"openBrowse"));
        this.setValidateStrategy(1);
        this.createControl(parent);
    }

    protected String changePressed() {
        File d;
        File f = new File(this.getTextControl().getText());
        if (!f.exists()) {
            f = null;
        }
        if ((d = this.getDirectory(f)) == null) {
            return null;
        }
        this.unmaskedValue = d.getAbsolutePath();
        return this.unmaskedValue;
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.unmaskedValue);
    }

    protected boolean doCheckState() {
        this.setErrorMessage("");
        this.unmaskedValue = this.getTextControl().getText();
        String uri = this.unmaskedValue.trim();
        if (uri.length() == 0 && this.isEmptyStringAllowed()) {
            return true;
        }
        if (uri.contains("*")) {
            this.setErrorMessage("Passwort muss gesetzt sein");
            return false;
        }
        try {
            VirtualFilesystemServiceHolder.get().of(uri);
            return true;
        }
        catch (IOException | IllegalArgumentException e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
    }

    protected void doLoad() {
        if (this.getTextControl() != null) {
            this.unmaskedValue = this.getPreferenceStore().getString(this.getPreferenceName());
            try {
                URI uri = IVirtualFilesystemService.stringToURI((String)this.unmaskedValue);
                String maskedValue = IVirtualFilesystemService.hidePasswordInUrlString((String)uri.toString());
                if (maskedValue.contains("*")) {
                    this.getTextControl().setText(maskedValue);
                    this.oldValue = maskedValue;
                } else {
                    this.getTextControl().setText(this.unmaskedValue);
                    this.oldValue = this.unmaskedValue;
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                this.setErrorMessage(e.getMessage());
            }
        }
    }

    private File getDirectory(File startingDirectory) {
        DirectoryDialog fileDialog = new DirectoryDialog(this.getShell(), 0x10001000);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        } else if (this.filterPath != null) {
            fileDialog.setFilterPath(this.filterPath.getPath());
        }
        String dir = fileDialog.open();
        if (dir != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    public void setFilterPath(File path) {
        this.filterPath = path;
    }
}

