/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.v22;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.GenericPrimitive;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.FT;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TX;
import ca.uhn.hl7v2.model.v22.message.ORU_R01;
import ca.uhn.hl7v2.model.v22.segment.NTE;
import ca.uhn.hl7v2.model.v22.segment.OBR;
import ca.uhn.hl7v2.model.v22.segment.OBX;
import ca.uhn.hl7v2.model.v22.segment.PID;
import ca.uhn.hl7v2.model.v26.datatype.ED;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.hl7.HL7Writer;
import ch.elexis.hl7.data.HL7Mandant;
import ch.elexis.hl7.model.EncapsulatedData;
import ch.elexis.hl7.model.ObservationMessage;
import ch.elexis.hl7.model.StringData;
import ch.elexis.hl7.model.TextData;
import ch.elexis.hl7.v26.ElexisValidation;
import ch.elexis.hl7.v26.Messages;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;

public class HL7_ORU_R01
extends HL7Writer {
    final String uniqueMessageControlID;
    final String uniqueProcessingID;
    final HL7Mandant mandant;

    public HL7_ORU_R01() {
        this.uniqueMessageControlID = null;
        this.uniqueProcessingID = null;
        this.mandant = null;
    }

    public HL7_ORU_R01(String sendingApplication1, String sendingApplication3, String receivingApplication1, String receivingApplication3, String receivingFacility, String uniqueMessageControlID, String uniqueProcessingID, HL7Mandant mandant) {
        super(sendingApplication1, sendingApplication3, receivingApplication1, receivingApplication3, receivingFacility);
        this.uniqueMessageControlID = uniqueMessageControlID;
        this.uniqueProcessingID = uniqueProcessingID;
        this.mandant = mandant;
    }

    public ORU_R01 read(String text, boolean readWithValidation) throws HL7Exception {
        PipeParser p = new PipeParser();
        if (readWithValidation) {
            p.setValidationContext((ValidationContext)new ElexisValidation());
        } else {
            p.setValidationContext((ValidationContext)new NoValidation());
        }
        Message hl7Msg = p.parse(text);
        if (hl7Msg instanceof ORU_R01) {
            return (ORU_R01)hl7Msg;
        }
        this.addError(MessageFormat.format(Messages.HL7_ORU_R01_Error_WrongMsgType, hl7Msg.getName()));
        return null;
    }

    public ObservationMessage readObservation(String text) throws IOException, ElexisException {
        return this.readObservation(text, true);
    }

    public ObservationMessage readObservation(String text, boolean readWithValidation) throws IOException, ElexisException {
        this.clearMessages();
        ObservationMessage observation = null;
        try {
            ORU_R01 oru = this.read(text, readWithValidation);
            if (oru != null) {
                String msh3_sendingApplication = oru.getMSH().getMsh3_SendingApplication().getValue();
                String msh4_sendingFacility = oru.getMSH().getMsh4_SendingFacility().getValue();
                String msh7_dateTimeOfMessage = oru.getMSH().getMsh7_DateTimeOfMessage().getComponent(0).toString();
                String msh10_messageControlId = oru.getMSH().getMsh10_MessageControlID().getValue();
                PID pid = oru.getPATIENT_RESULT().getPATIENT().getPID();
                String pid2_patientId = pid.getPid2_PatientIDExternalID().getCk1_IDNumber().getValue();
                if (pid2_patientId == null || "".equals(pid2_patientId)) {
                    pid2_patientId = pid.getPid3_PatientIDInternalID(0).getCm_pat_id1_IDNumber().getValue();
                }
                String pid4_alternatePatientId = pid.getPid4_AlternatePatientID().getValue();
                String pid5_patientLastName = "";
                String pid5_patientFirstName = "";
                if (pid.getPid5_PatientName().getName() != null) {
                    pid5_patientLastName = pid.getPid5_PatientName().getFamilyName().getValue();
                }
                if (pid.getPid5_PatientName().getFamilyName() != null) {
                    pid5_patientFirstName = pid.getPid5_PatientName().getGivenName().getValue();
                }
                String pid7_patientBirthdate = pid.getPid7_DateOfBirth().getComponent(0).toString();
                String pid8_patientSex = pid.getPid8_Sex().getValue();
                FT[] nteAfterPid_patientNotesAndCommentsArray = oru.getPATIENT_RESULT().getPATIENT().getNTE().getComment();
                String nteAfterPid_patientNotesAndComments = String.join((CharSequence)"\n", nteAfterPid_patientNotesAndCommentsArray.length > 0 ? nteAfterPid_patientNotesAndCommentsArray[0].getValue() : null);
                if ("W".equals(pid8_patientSex.toUpperCase())) {
                    pid8_patientSex = "F";
                }
                String orc2_placerOrderNumber = oru.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getOrc2_PlacerOrderNumber().getCm_placer1_UniquePlacerId().getValue();
                String orc3_fillerOrderNumber = oru.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getOrc3_FillerOrderNumber().getCm_filler1_UniqueFillerId().getValue();
                String orc9_dateTimeOfTransaction = oru.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getOrc9_DateTimeOfTransaction().getComponent(0).toString();
                observation = new ObservationMessage(msh3_sendingApplication, msh4_sendingFacility, msh7_dateTimeOfMessage, msh10_messageControlId, orc9_dateTimeOfTransaction, pid2_patientId, pid5_patientLastName, pid5_patientFirstName, nteAfterPid_patientNotesAndComments, pid7_patientBirthdate, pid8_patientSex, pid4_alternatePatientId, orc2_placerOrderNumber, orc3_fillerOrderNumber);
                int obscount = oru.getPATIENT_RESULT().getORDER_OBSERVATIONReps();
                int j = 0;
                while (j < obscount) {
                    String appendedTX = "";
                    OBR obr = oru.getPATIENT_RESULT().getORDER_OBSERVATION(j).getOBR();
                    String obrDateOfObservation = obr.getObr7_ObservationDateTime().getComponent(0).toString();
                    if (obrDateOfObservation == null || "".equals(obrDateOfObservation)) {
                        obrDateOfObservation = obr.getObr22_ResultsReportStatusChangeDateTime().getComponent(0).toString();
                    }
                    if (obrDateOfObservation == null || "".equals(obrDateOfObservation)) {
                        obrDateOfObservation = orc9_dateTimeOfTransaction;
                    }
                    if (obrDateOfObservation == null || "".equals(obrDateOfObservation)) {
                        obrDateOfObservation = msh7_dateTimeOfMessage;
                    }
                    String orderCommentNTE = null;
                    int n = 0;
                    while (n < oru.getPATIENT_RESULT().getORDER_OBSERVATION(j).getNTEReps()) {
                        NTE nte = oru.getPATIENT_RESULT().getORDER_OBSERVATION(j).getNTE(n);
                        FT comment = nte.getNte3_Comment(0);
                        if (comment != null) {
                            orderCommentNTE = orderCommentNTE != null ? String.valueOf(orderCommentNTE) + "\n" : "";
                            orderCommentNTE = String.valueOf(orderCommentNTE) + comment.getValue();
                        }
                        ++n;
                    }
                    if (orderCommentNTE != null) {
                        TextData txtData = new TextData("Kommentar", orderCommentNTE, obrDateOfObservation, "00 Kommentar", null);
                        observation.add(txtData);
                    }
                    int i = 0;
                    while (i < oru.getPATIENT_RESULT().getORDER_OBSERVATION(j).getOBSERVATIONReps()) {
                        String range;
                        String unit;
                        Type value;
                        String valueST;
                        String name;
                        String kuerzel;
                        String dateOfObservation;
                        String commentNTE = null;
                        int n2 = 0;
                        while (n2 < oru.getPATIENT_RESULT().getORDER_OBSERVATION(j).getOBSERVATION(i).getNTEReps()) {
                            NTE nte = oru.getPATIENT_RESULT().getORDER_OBSERVATION(j).getOBSERVATION(i).getNTE(n2);
                            FT comment = nte.getNte3_Comment(0);
                            if (comment != null) {
                                commentNTE = commentNTE != null ? String.valueOf(commentNTE) + "\n" : "";
                                commentNTE = String.valueOf(commentNTE) + comment.getValue();
                            }
                            ++n2;
                        }
                        OBX obx = oru.getPATIENT_RESULT().getORDER_OBSERVATION(j).getOBSERVATION(i).getOBX();
                        String valueType = obx.getObx2_ValueType().getValue();
                        if ("ED".equals(valueType)) {
                            String filename;
                            String observationId = obx.getObx3_ObservationIdentifier().getCe1_Identifier().getValue();
                            if (!"DOCUMENT".equals(observationId)) {
                                this.addWarning(MessageFormat.format(Messages.HL7_ORU_R01_Error_WrongObsIdentifier, observationId));
                            }
                            ED ed = (ED)obx.getObx5_ObservationValue().getData();
                            String kuerzel2 = filename = ed.getEd3_DataSubtype().getValue();
                            String encoding = ed.getEd4_Encoding().getValue();
                            String data = ed.getEd5_Data().getValue();
                            dateOfObservation = obx.getObx14_DateTimeOfTheObservation().getComponent(0).toString();
                            EncapsulatedData encapsData = new EncapsulatedData(filename, encoding, data, dateOfObservation, commentNTE, null, null);
                            observation.add(encapsData);
                        } else if ("ST".equals(valueType)) {
                            kuerzel = obx.getObx3_ObservationIdentifier().getCe1_Identifier().getValue();
                            name = obx.getObx3_ObservationIdentifier().getCe2_Text().getValue();
                            valueST = "";
                            value = obx.getObx5_ObservationValue().getData();
                            if (value instanceof ST) {
                                valueST = ((ST)obx.getObx5_ObservationValue().getData()).getValue();
                            }
                            unit = obx.getObx6_Units().getCe1_Identifier().getValue();
                            range = obx.getObx7_ReferencesRange().getValue();
                            dateOfObservation = obx.getObx14_DateTimeOfTheObservation().getComponent(0).toString();
                            StringData strData = new StringData(name, unit, valueST, range, dateOfObservation, commentNTE, null, null);
                            observation.add(strData);
                        } else if ("TX".equals(valueType)) {
                            String valueTX = "";
                            Type value2 = obx.getObx5_ObservationValue().getData();
                            if (value2 instanceof TX) {
                                valueTX = ((TX)obx.getObx5_ObservationValue().getData()).getValue();
                            }
                            appendedTX = String.valueOf(appendedTX) + valueTX + "\n";
                        } else if ("FT".equals(valueType)) {
                            kuerzel = obx.getObx3_ObservationIdentifier().getCe1_Identifier().getValue();
                            name = obx.getObx3_ObservationIdentifier().getCe2_Text().getValue();
                            valueST = "";
                            value = obx.getObx5_ObservationValue().getData();
                            if (value instanceof ST) {
                                ST st = (ST)value;
                                valueST = st.getValue();
                            } else if (value instanceof FT) {
                                FT ft = (FT)value;
                                valueST = ft.getValue();
                            } else if (value instanceof GenericPrimitive) {
                                GenericPrimitive gp = (GenericPrimitive)value;
                                valueST = gp.getValue();
                            } else {
                                this.addError(MessageFormat.format("Value type of FT ({0}) is not implemented!", value.getClass().getName()));
                            }
                            unit = obx.getObx6_Units().getCe1_Identifier().getValue();
                            range = obx.getObx7_ReferencesRange().getValue();
                            dateOfObservation = obx.getObx14_DateTimeOfTheObservation().getComponent(0).toString();
                            StringData data = new StringData(name, unit, valueST, range, dateOfObservation, commentNTE, null, null);
                            observation.add(data);
                        } else {
                            this.addError(MessageFormat.format("Value type {0} is not implemented!", valueType));
                        }
                        ++i;
                    }
                    if (appendedTX.length() > 0) {
                        String name = null;
                        CE ceIdentifier = obr.getObr4_UniversalServiceID();
                        String kuerzel = ceIdentifier.getCe1_Identifier().getValue();
                        if (ceIdentifier.getCe2_Text() != null) {
                            name = ceIdentifier.getCe2_Text().getValue();
                        }
                        if (name == null || name.trim().length() == 0) {
                            name = kuerzel;
                        }
                        TextData textData = new TextData(name, appendedTX, obrDateOfObservation, null, null);
                        observation.add(textData);
                    }
                    ++j;
                }
            }
        }
        catch (HL7Exception | ParseException e) {
            throw new ElexisException(e.getMessage(), e);
        }
        return observation;
    }

    @Override
    public String getVersion() {
        return "2.2";
    }
}

