/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IStockEntry;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.data.Artikel;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Stock;
import org.apache.commons.lang3.StringUtils;

public class StockEntry
extends PersistentObject
implements IStockEntry {
    public static final String TABLENAME = "STOCK_ENTRY";
    public static final String FLD_STOCK = "STOCK";
    public static final String FLD_ARTICLE_TYPE = "ARTICLE_TYPE";
    public static final String FLD_ARTICLE_ID = "ARTICLE_ID";
    public static final String FLD_MIN = "MIN";
    public static final String FLD_CURRENT = "CURRENT";
    public static final String FLD_MAX = "MAX";
    public static final String FLD_FRACTIONUNITS = "FRACTIONUNITS";
    public static final String FLD_PROVIDER = "PROVIDER";

    static {
        StockEntry.addMapping(TABLENAME, FLD_STOCK, FLD_ARTICLE_TYPE, FLD_ARTICLE_ID, "MIN=S:N:MIN", "CURRENT=S:N:CURRENT", "MAX=S:N:MAX", "FRACTIONUNITS=S:N:FRACTIONUNITS", FLD_PROVIDER);
    }

    protected StockEntry() {
    }

    protected StockEntry(String id) {
        super(id);
    }

    public StockEntry(Stock stock, PersistentObject article) {
        String provider = ConfigServiceHolder.getGlobal((String)"inventory/defaultArticleProvider", null);
        String[] fields = new String[]{FLD_STOCK, FLD_ARTICLE_TYPE, FLD_ARTICLE_ID, FLD_PROVIDER};
        String[] values = new String[]{stock.getId(), article.getClass().getName(), article.getId(), provider != null ? provider : null};
        this.create(null, fields, values);
    }

    public static StockEntry load(String id) {
        return new StockEntry(id);
    }

    @Override
    public boolean isDragOK() {
        return true;
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    @Override
    public Artikel getArticle() {
        String[] vals = this.get(false, FLD_ARTICLE_TYPE, FLD_ARTICLE_ID);
        if (StringUtils.isNotBlank((CharSequence)vals[1])) {
            return (Artikel)CoreHub.poFactory.createFromString(String.valueOf(vals[0]) + "::" + vals[1]);
        }
        return null;
    }

    public void setArticle(Artikel article) {
        if (article != null) {
            this.set(new String[]{FLD_ARTICLE_TYPE, FLD_ARTICLE_ID}, article.getClass().getName(), article.getId());
        } else {
            this.set(new String[]{FLD_ARTICLE_TYPE, FLD_ARTICLE_ID}, null, null);
        }
    }

    @Override
    public Stock getStock() {
        return Stock.load(this.get(FLD_STOCK));
    }

    public void setStock(Stock stock) {
        this.set(FLD_STOCK, stock.getId());
    }

    @Override
    public int getCurrentStock() {
        return this.getInt(FLD_CURRENT);
    }

    @Override
    public void setCurrentStock(int currentStock) {
        this.setInt(FLD_CURRENT, currentStock);
    }

    @Override
    public int getMinimumStock() {
        return this.getInt(FLD_MIN);
    }

    @Override
    public int getMaximumStock() {
        return this.getInt(FLD_MAX);
    }

    @Override
    public int getFractionUnits() {
        return this.getInt(FLD_FRACTIONUNITS);
    }

    @Override
    public void setFractionUnits(int rest) {
        this.setInt(FLD_FRACTIONUNITS, rest);
    }

    @Override
    public void setMinimumStock(int minStock) {
        this.setInt(FLD_MIN, minStock);
    }

    @Override
    public void setMaximumStock(int maxStock) {
        this.setInt(FLD_MAX, maxStock);
    }

    @Override
    public Kontakt getProvider() {
        String providerId = this.get(FLD_PROVIDER);
        if (StringUtils.isNotBlank((CharSequence)providerId)) {
            return Kontakt.load(providerId);
        }
        return null;
    }

    @Override
    public void setProvider(Object provider) {
        if (provider instanceof Kontakt) {
            this.set(FLD_PROVIDER, ((Kontakt)provider).getId());
        }
    }
}

