/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.interfaces.ISticker;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class Sticker
extends PersistentObject
implements ISticker {
    public static final String TABLENAME = "ETIKETTEN";
    public static final String FLD_NAME = "Name";
    public static final String FLD_LINKTABLE = "ETIKETTEN_OBJECT_LINK";
    public static final String FLD_CLASSLINK = "ETIKETTEN_OBJCLASS_LINK";
    public static final String FLD_BACKGROUND = "bg";
    public static final String FLD_FOREGROUND = "vg";
    public static final String FLD_IMAGE_ID = "BildID";
    public static final String FLD_VALUE = "wert";
    private static final String RGB_BLACK = "000000";
    private static final String RGB_WHITE = "FFFFFF";
    static final HashMap<Class<?>, List<Sticker>> cache = new HashMap();
    private static String queryClassStickerString;
    private static String queryStickerClassString;

    static {
        Sticker.addMapping(TABLENAME, "Datum=S:D:Datum", "BildID=Image", "vg=foreground", "bg=background", FLD_NAME, "wert=importance");
        queryClassStickerString = "SELECT objclass FROM ETIKETTEN_OBJCLASS_LINK WHERE sticker=?";
        queryStickerClassString = "SELECT sticker FROM ETIKETTEN_OBJCLASS_LINK WHERE objclass=?";
    }

    public Sticker(String name, String fg, String bg) {
        this.create(null);
        if (fg == null) {
            fg = RGB_BLACK;
        }
        if (bg == null) {
            bg = RGB_WHITE;
        }
        this.set(new String[]{FLD_NAME, FLD_FOREGROUND, FLD_BACKGROUND}, name, fg, bg);
    }

    public static Sticker load(String id) {
        Sticker ret = new Sticker(id);
        return ret;
    }

    protected Sticker(String id) {
        super(id);
    }

    protected Sticker() {
    }

    @Override
    public String getLabel() {
        return this.get(FLD_NAME);
    }

    @Override
    public int getWert() {
        return Sticker.checkZero(this.get(FLD_VALUE));
    }

    @Override
    public void setWert(int w) {
        this.set(FLD_VALUE, Integer.toString(w));
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    @Override
    public boolean delete() {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(FLD_LINKTABLE).append(" WHERE ").append("etikette = '").append(this.getId()).append("'");
        JdbcLink.Stm stm = this.getDBConnection().getStatement();
        try {
            stm.exec(sb.toString());
        }
        finally {
            this.getDBConnection().releaseStatement(stm);
        }
        return super.delete();
    }

    @Override
    public void setClassForSticker(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ETIKETTEN_OBJCLASS_LINK (objclass,sticker) VALUES (").append(JdbcLink.wrap((String)clazz.getName())).append(",").append(this.getWrappedId()).append(");");
        JdbcLink.Stm stm = this.getDBConnection().getStatement();
        try {
            stm.exec(sb.toString());
        }
        finally {
            this.getDBConnection().releaseStatement(stm);
        }
    }

    @Override
    public void removeClassForSticker(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ETIKETTEN_OBJCLASS_LINK WHERE objclass=").append(JdbcLink.wrap((String)clazz.getName())).append(" AND sticker=").append(this.getWrappedId());
        JdbcLink.Stm stm = this.getDBConnection().getStatement();
        try {
            stm.exec(sb.toString());
        }
        finally {
            this.getDBConnection().releaseStatement(stm);
        }
    }

    @Override
    public List<String> getClassesForSticker() {
        ArrayList<String> ret = new ArrayList<String>();
        PreparedStatement queryClasses = null;
        try {
            try {
                queryClasses = this.getDBConnection().getPreparedStatement(queryClassStickerString);
                queryClasses.setString(1, this.getId());
                ResultSet res = queryClasses.executeQuery();
                while (res.next()) {
                    ret.add(res.getString(1));
                }
                res.close();
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                this.getDBConnection().releasePreparedStatement(queryClasses);
            }
        }
        finally {
            this.getDBConnection().releasePreparedStatement(queryClasses);
        }
        return ret;
    }

    public static List<Sticker> getStickersForClass(Class<?> clazz) {
        List<Sticker> ret = cache.get(clazz);
        if (ret != null) {
            return ret;
        }
        HashSet<Sticker> uniqueRet = new HashSet<Sticker>();
        PreparedStatement queryStickers = null;
        try {
            try {
                queryStickers = Sticker.getDefaultConnection().getPreparedStatement(queryStickerClassString);
                queryStickers.setString(1, clazz.getName());
                ResultSet res = queryStickers.executeQuery();
                while (res.next()) {
                    Sticker et = Sticker.load(res.getString(1));
                    if (et == null || !et.exists()) continue;
                    uniqueRet.add(et);
                }
                res.close();
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                List<Sticker> list = ret;
                Sticker.getDefaultConnection().releasePreparedStatement(queryStickers);
                return list;
            }
        }
        finally {
            Sticker.getDefaultConnection().releasePreparedStatement(queryStickers);
        }
        cache.put(clazz, new ArrayList(uniqueRet));
        return new ArrayList<Sticker>(uniqueRet);
    }

    @Override
    public int compareTo(ISticker o) {
        if (o != null) {
            return o.getWert() - this.getWert();
        }
        return 1;
    }

    @Override
    public void setBackground(String bg) {
        this.set(FLD_BACKGROUND, bg);
    }

    @Override
    public void setForeground(String fg) {
        this.set(FLD_FOREGROUND, fg);
    }

    @Override
    public String getBackground() {
        return this.get(FLD_BACKGROUND);
    }

    @Override
    public String getForeground() {
        return this.get(FLD_FOREGROUND);
    }

    @Override
    public boolean isVisible() {
        return this.getWert() >= 0;
    }

    @Override
    public void setVisible(boolean value) {
    }
}

