/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.scripting.Interpreter;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.NamedBlob2;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class Script
extends NamedBlob2 {
    public static final String INTERPRETER_BEANSHELL = "BSH";
    public static final String INTERPRETER_SCALA = "SCALA";
    public static final String INTERPRETER_DEFAULT = "BSH";
    private static final Pattern varPattern = Pattern.compile("\\[[*]?[-a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\.[-a-zA-Z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\]");
    private static final String PREFIX = "Script:";
    public static final String SCRIPT_MARKER = "SCRIPT:";
    private Interpreter interpreter = null;

    private static Interpreter getInterpreter(String name) throws ElexisException {
        if (name == null) {
            name = "BSH";
        }
        List<IConfigurationElement> scripters = Extensions.getExtensions("ch.elexis.core.data.scripting");
        for (IConfigurationElement scripter : scripters) {
            if (!scripter.getAttribute("name").equals(name)) continue;
            try {
                return (Interpreter)scripter.createExecutableExtension("class");
            }
            catch (CoreException e) {
                ExHandler.handle((Throwable)e);
                throw new ElexisException(Script.class, "Could not load intepreter " + e.getMessage(), 5);
            }
        }
        throw new ElexisException(Script.class, String.valueOf(name) + " interpreter plug-in not available", 5);
    }

    private void loadInterpreter(String script) throws ElexisException {
        if (this.interpreter == null) {
            Pattern ip;
            Matcher m;
            if (script == null) {
                script = this.getString();
            }
            this.interpreter = (m = (ip = Pattern.compile("^\\/\\*\\s*!([A-Z]+)!\\s*\\*\\/", 8)).matcher(script)).matches() ? Script.getInterpreter(m.group(1)) : Script.getInterpreter(null);
        }
    }

    public static Script create(String name, String contents) throws ElexisException {
        String mid = PREFIX + name;
        Script ret = new Script(mid);
        if (ret.state() == 0) {
            ret.create(mid);
        } else if (ret.state() == 2) {
            ret.undelete();
        }
        if (StringTool.isNothing((Object)contents)) {
            contents = "/* !BSH! */";
        }
        ret.putString(contents);
        return ret;
    }

    @Override
    public String getLabel() {
        String[] name = this.getId().split(":");
        return name[1];
    }

    public void init() throws ElexisException {
        this.loadInterpreter(null);
        this.interpreter.setValue("finished", false);
        this.interpreter.setValue("init", true);
        this.interpreter.run(Script.parse(this.getString(), new PersistentObject[0]), false);
        this.interpreter.setValue("init", false);
    }

    public void finished() throws ElexisException {
        this.loadInterpreter(null);
        this.interpreter.setValue("finished", true);
        this.interpreter.run(Script.parse(this.getString(), null), false);
    }

    public void setVariable(String name, Object value) throws ElexisException {
        this.loadInterpreter(null);
        this.interpreter.setValue(name, value);
    }

    private static String parse(String script, PersistentObject ... params) {
        if (params == null) {
            params = new PersistentObject[]{};
        }
        Matcher matcher = varPattern.matcher(script);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            boolean bMatched = false;
            String var = matcher.group().replaceAll("[\\[\\]]", "");
            String[] fields = var.split("\\.");
            if (fields.length > 1) {
                String fqname = "ch.elexis.data." + fields[0];
                PersistentObject[] persistentObjectArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    PersistentObject o = persistentObjectArray[n2];
                    if (o.getClass().getName().equals(fqname)) {
                        String repl = o.get(fields[1]);
                        repl = repl.replace('\\', '/');
                        repl = repl.replace('\"', ' ');
                        repl = repl.replace('\n', ' ');
                        repl = repl.replace('\r', ' ');
                        matcher.appendReplacement(sb, "\"" + repl + "\"");
                        bMatched = true;
                    }
                    ++n2;
                }
            }
            if (bMatched) continue;
            matcher.appendReplacement(sb, "\"\"");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static Object execute(Interpreter scripter, String script, String params, PersistentObject ... objects) throws ElexisException {
        return Script.execute(scripter, script, params, true, objects);
    }

    public static Object execute(Interpreter scripter, String script, String params, boolean showErrors, PersistentObject ... objects) throws ElexisException {
        if (!StringTool.isNothing((Object)script)) {
            if (params != null) {
                String var = "\\$";
                String[] parameters = params.split("\\s*,\\s*");
                int i = 0;
                while (i < parameters.length) {
                    String parm = parameters[i].trim();
                    String[] p = parm.split("=");
                    script = p.length == 2 ? script.replaceAll("\\" + p[0], p[1]) : script.replaceAll(String.valueOf(var) + i, p[0]);
                    ++i;
                }
            }
            String parsed = Script.parse(script, objects);
            scripter.setValue("actPatient", ElexisEventDispatcher.getSelectedPatient());
            scripter.setValue("actFall", ElexisEventDispatcher.getSelected(Fall.class));
            scripter.setValue("actKons", ElexisEventDispatcher.getSelected(Konsultation.class));
            scripter.setValue("actMandant", CoreHub.actMandant);
            scripter.setValue("actUser", CoreHub.getLoggedInContact());
            scripter.setValue("Elexis", CoreHub.plugin);
            return scripter.run(parsed, showErrors);
        }
        return null;
    }

    public Object execute(String params, PersistentObject ... objects) throws ElexisException {
        String script = this.getString();
        this.loadInterpreter(script);
        return Script.execute(this.interpreter, script, params, objects);
    }

    public static List<Script> getScripts() {
        Query qbe = new Query(Script.class);
        qbe.add("ID", "LIKE", "Script:%");
        return qbe.execute();
    }

    public static Object executeScript(String call, PersistentObject ... objects) throws ElexisException {
        String name = call = call.trim();
        String params = null;
        int x = name.indexOf(40);
        if (x != -1) {
            name = call.substring(0, x);
            params = call.substring(x + 1, call.length() - 1);
        }
        Query qbe = new Query(Script.class);
        qbe.add("ID", "=", PREFIX + name);
        List found = qbe.execute();
        if (found.size() == 0) {
            throw new ElexisException(Script.class, "A Script with this name was not found " + name, 6);
        }
        Script script = (Script)found.get(0);
        try {
            return script.execute(params, objects);
        }
        catch (Exception e) {
            ExHandler.handle((Throwable)e);
            throw new ElexisException(Script.class, "Error while executing " + name + ": " + e.getMessage(), 3);
        }
    }

    @Override
    public boolean isDragOK() {
        return true;
    }

    @Override
    public boolean isValid() {
        if (this.getId().matches("Script:[a-zA-Z0-9_-]+")) {
            return super.isValid();
        }
        return false;
    }

    public static Script load(String id) {
        Script ret = new Script(id);
        if (ret.isValid()) {
            return ret;
        }
        return null;
    }

    protected Script(String id) {
        super(id);
    }

    protected Script() {
    }

    public static Interpreter getInterpreterFor(String script) throws ElexisException {
        Script s = new Script();
        s.loadInterpreter(script);
        return s.interpreter;
    }

    public static Script importFromFile(String filepath) throws ElexisException {
        File file = new File(filepath);
        if (!file.exists() && !(file = new File(String.valueOf(filepath) + ".script")).exists()) {
            throw new ElexisException(Script.class, "Could not find file " + filepath, 6);
        }
        try {
            String in;
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            StringBuilder sb = new StringBuilder();
            while ((in = br.readLine()) != null) {
                sb.append(in);
            }
            br.close();
            String name = FileTool.getNakedFilename((String)filepath);
            return Script.create(name, sb.toString());
        }
        catch (IOException ioex) {
            throw new ElexisException(Script.class, "Error loading file " + filepath + ": " + ioex.getMessage(), 4);
        }
    }
}

