/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IOutputter;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class OutputLog
extends PersistentObject {
    public static final String FLD_OBJECT_TYPE = "ObjectType";
    public static final String FLD_OBJECT_ID = "ObjectID";
    public static final String FLD_OUTPUTTER = "Outputter";
    static final String TABLENAME = "OUTPUT_LOG";
    static final HashMap<String, IOutputter> outputter_cache = new HashMap();

    static {
        OutputLog.addMapping(TABLENAME, FLD_OBJECT_ID, FLD_OBJECT_TYPE, FLD_OUTPUTTER, "Datum=S:D:Datum", "ExtInfo");
    }

    public OutputLog(PersistentObject po, IOutputter io) {
        this.create(null);
        this.set(new String[]{FLD_OBJECT_ID, FLD_OBJECT_TYPE, "Datum", FLD_OUTPUTTER}, po.getId(), po.getClass().getName(), new TimeTool().toString(4), io.getOutputterID());
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po, po.getClass(), 4));
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.get("Datum")) + ":" + this.get(FLD_OUTPUTTER);
    }

    public String getOutputterID() {
        return OutputLog.checkNull(this.get(FLD_OUTPUTTER));
    }

    public static List<OutputLog> getOutputs(PersistentObject po) {
        Query qbe = new Query(OutputLog.class);
        qbe.add(FLD_OBJECT_ID, "=", po.getId());
        qbe.orderBy(true, "lastupdate");
        return qbe.execute();
    }

    public static IOutputter getOutputter(String outputterID) {
        IOutputter ret = outputter_cache.get(outputterID);
        if (ret == null) {
            List<IConfigurationElement> eps = Extensions.getExtensions("ch.elexis.core.data.OutputLogDescriptor");
            for (IConfigurationElement ep : eps) {
                String id = ep.getAttribute("id");
                if (id == null || !id.equals(outputterID)) continue;
                try {
                    ret = (IOutputter)ep.createExecutableExtension(FLD_OUTPUTTER);
                    outputter_cache.put(outputterID, ret);
                    break;
                }
                catch (CoreException ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        }
        return ret;
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public static OutputLog load(String id) {
        return new OutputLog(id);
    }

    protected OutputLog(String id) {
        super(id);
    }

    OutputLog() {
    }
}

