/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IArticle;
import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.data.VerrechenbarAdapter;
import ch.elexis.data.Xid;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Artikel
extends VerrechenbarAdapter
implements IArticle {
    public static final String TABLENAME = "ARTIKEL";
    public static final String FLD_EAN = "EAN";
    public static final String FLD_CODECLASS = "Codeclass";
    public static final String FLD_KLASSE = "Klasse";
    public static final String XID_PHARMACODE = "www.xid.ch/id/pharmacode/ch";
    public static final String FLD_SUB_ID = "SubID";
    public static final String ARTIKEL = "Artikel";
    public static final String FLD_PHARMACODE = "Pharmacode";
    public static final String FLD_EXTID = "ExtID";
    public static final String VERKAUFSEINHEIT = "Verkaufseinheit";
    public static final String VERPACKUNGSEINHEIT = "Verpackungseinheit";
    public static final String FLD_VK_PREIS = "VK_Preis";
    public static final String FLD_EK_PREIS = "EK_Preis";
    public static final String EIGENNAME = "Eigenname";
    public static final String FLD_TYP = "Typ";
    public static final String FLD_NAME = "Name";
    public static final String FLD_ATC_CODE = "ATC_code";
    public static final Pattern NAME_VE_PATTERN = Pattern.compile(".+ ([0-9]+) Stk.*");

    static {
        Artikel.addMapping(TABLENAME, FLD_NAME, FLD_EK_PREIS, FLD_VK_PREIS, FLD_TYP, "ExtInfo", FLD_EAN, FLD_SUB_ID, "Eigenname=Name_intern", FLD_CODECLASS, FLD_KLASSE, FLD_ATC_CODE, FLD_EXTID);
        Xid.localRegisterXIDDomainIfNotExists(XID_PHARMACODE, FLD_PHARMACODE, 2);
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    @Override
    public String getXidDomain() {
        return XID_PHARMACODE;
    }

    public static Artikel load(String id) {
        if (id == null) {
            return null;
        }
        Artikel ret = new Artikel(id);
        if (!ret.exists()) {
            return ret;
        }
        String clazz = ret.get(FLD_KLASSE);
        if (!StringTool.isNothing((Object)clazz)) {
            try {
                ret = (Artikel)CoreHub.poFactory.createFromString(String.valueOf(clazz) + "::" + id);
            }
            catch (Exception ex) {
                log.error("Fehlerhafter Leistungscode " + clazz + "::" + id);
            }
        }
        return ret;
    }

    public Artikel(String Name, String Typ) {
        this.create(null);
        this.set(new String[]{FLD_NAME, FLD_TYP}, Name, Typ);
    }

    public Artikel(String Name, String Typ, String subid) {
        this.create(null);
        this.set(new String[]{FLD_NAME, FLD_TYP, FLD_SUB_ID}, Name, Typ, subid);
    }

    @Override
    public String getLabel() {
        if (!this.exists()) {
            return "(" + this.getName() + ")";
        }
        return this.getInternalName();
    }

    public String[] getDisplayedFields() {
        return new String[]{FLD_TYP, FLD_NAME};
    }

    public void setInternalName(String nick) {
        this.set(EIGENNAME, nick);
    }

    public String getInternalName() {
        String ret = this.get(EIGENNAME);
        if (StringTool.isNothing((Object)ret)) {
            ret = this.getName();
        }
        return ret;
    }

    @Override
    public String getName() {
        return Artikel.checkNull(this.get(FLD_NAME));
    }

    public void setName(String name) {
        this.set(FLD_NAME, name);
    }

    public Money getEKPreis() {
        try {
            return new Money(Artikel.checkZero(this.get(FLD_EK_PREIS)));
        }
        catch (Throwable ex) {
            log.error("Fehler beim Einlesen von EK f\u00fcr " + this.getLabel());
            return new Money();
        }
    }

    public Money getVKPreis() {
        try {
            return new Money(Artikel.checkZero(this.get(FLD_VK_PREIS)));
        }
        catch (Throwable ex) {
            log.error("Fehler beim Einlesen von VK f\u00fcr " + this.getLabel());
            return new Money();
        }
    }

    public void setEKPreis(Money preis) {
        this.set(FLD_EK_PREIS, preis.getCentsAsString());
    }

    public void setVKPreis(Money preis) {
        this.set(FLD_VK_PREIS, preis.getCentsAsString());
    }

    public int guessVE() {
        String name;
        Matcher matcher;
        int ret = this.getVerpackungsEinheit();
        if (ret == 0 && (matcher = NAME_VE_PATTERN.matcher(name = this.getName())).matches()) {
            String num = matcher.group(1);
            try {
                return Integer.parseInt(num);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public String getEAN() {
        return this.get(FLD_EAN);
    }

    @Override
    public String getGTIN() {
        return this.getEAN();
    }

    public void setEAN(String ean) {
        this.set(FLD_EAN, ean);
    }

    public boolean isVaccination() {
        String atcCode = this.getATC_code();
        return atcCode != null && atcCode.toUpperCase().startsWith("J07") && !atcCode.toUpperCase().startsWith("J07AX");
    }

    public String getATC_code() {
        String ATC_code = this.get(FLD_ATC_CODE);
        return ATC_code;
    }

    public void setATC_code(String ATC_code) {
        this.set(FLD_ATC_CODE, ATC_code);
    }

    public void setPharmaCode(String pharmacode) {
        Map ext = this.getMap("ExtInfo");
        ext.put(FLD_PHARMACODE, pharmacode);
        this.setMap("ExtInfo", ext);
    }

    public String getPharmaCode() {
        return Artikel.checkNull(this.getExt(FLD_PHARMACODE));
    }

    public int getVerpackungsEinheit() {
        return Artikel.checkZero((String)this.getExtInfoStoredObjectByKey(VERPACKUNGSEINHEIT));
    }

    @Override
    public int getPackageUnit() {
        return this.getVerpackungsEinheit();
    }

    public void setVerpackungsEinheit(int ve) {
        this.setExt(VERPACKUNGSEINHEIT, Integer.toString(ve));
    }

    public int getVerkaufseinheit() {
        return Artikel.checkZero(this.getExt(VERKAUFSEINHEIT));
    }

    @Override
    public int getSellingUnit() {
        return this.getVerkaufseinheit();
    }

    public void setVerkaufseinheit(int number) {
        this.setExt(VERKAUFSEINHEIT, Integer.toString(number));
    }

    public int getPackungsGroesse() {
        return Artikel.checkZero(this.getExt(VERPACKUNGSEINHEIT));
    }

    public void setPackungsGroesse(int packageSize) {
        this.setExtInfoStoredObjectByKey(VERPACKUNGSEINHEIT, Integer.toString(packageSize));
    }

    public String getPackungsGroesseDesc() {
        return Integer.toString(this.getPackungsGroesse());
    }

    public int getAbgabeEinheit() {
        return Artikel.checkZero(this.getExt(VERKAUFSEINHEIT));
    }

    public void setExt(String name, String value) {
        Map h = this.getMap("ExtInfo");
        if (value == null) {
            h.remove(name);
        } else {
            h.put(name, value);
        }
        this.setMap("ExtInfo", h);
    }

    public String getExt(String name) {
        Map h = this.getMap("ExtInfo");
        return Artikel.checkNull((String)h.get(name));
    }

    protected Artikel(String id) {
        super(id);
    }

    protected Artikel() {
    }

    @Override
    public String getCode() {
        return this.getId();
    }

    @Override
    public String getText() {
        return this.getInternalName();
    }

    @Override
    public String getCodeSystemName() {
        return ARTIKEL;
    }

    @Override
    public boolean isProduct() {
        return false;
    }

    public int getPreis(TimeTool dat, IFall fall) {
        double vkt = Artikel.checkZeroDouble(this.get(FLD_VK_PREIS));
        Map ext = this.getMap("ExtInfo");
        double vpe = Artikel.checkZeroDouble((String)ext.get(VERPACKUNGSEINHEIT));
        double vke = Artikel.checkZeroDouble((String)ext.get(VERKAUFSEINHEIT));
        if (vpe > 0.0 && vke > 0.0 && vpe != vke) {
            return (int)Math.round(vke * (vkt / vpe));
        }
        return (int)Math.round(vkt);
    }

    @Override
    public Money getKosten(TimeTool dat) {
        double vkt = Artikel.checkZeroDouble(this.get(FLD_EK_PREIS));
        Map ext = this.getMap("ExtInfo");
        double vpe = Artikel.checkZeroDouble((String)ext.get(VERPACKUNGSEINHEIT));
        double vke = Artikel.checkZeroDouble((String)ext.get(VERKAUFSEINHEIT));
        if (vpe > 0.0 && vke > 0.0 && vpe != vke) {
            return new Money((int)Math.round(vke * (vkt / vpe)));
        }
        return new Money((int)Math.round(vkt));
    }

    @Override
    public int getTP(TimeTool date, IFall fall) {
        return this.getPreis(date, fall);
    }

    @Override
    public double getFactor(TimeTool date, IFall fall) {
        return 1.0;
    }

    @Override
    protected String[] getExportFields() {
        return new String[]{FLD_EAN, FLD_SUB_ID, FLD_KLASSE, FLD_NAME, FLD_EK_PREIS, FLD_VK_PREIS, FLD_TYP, FLD_CODECLASS, FLD_ATC_CODE, "ExtInfo"};
    }

    @Override
    protected String getExportUIDValue() {
        String pharmacode = this.getExt(FLD_PHARMACODE);
        String ean = this.get(FLD_EAN);
        return String.valueOf(ean) + "_" + pharmacode;
    }

    public ch.elexis.core.model.IArticle toIArticle() {
        return (ch.elexis.core.model.IArticle)CoreModelServiceHolder.get().load(this.getId(), ch.elexis.core.model.IArticle.class).orElseThrow(() -> new IllegalStateException("Could not convert article [" + this.getId() + "]"));
    }
}

